/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.protocol.codec;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.builtin.CodecUtil;
import com.hazelcast.client.impl.protocol.codec.builtin.FixedSizeTypesCodec;
import com.hazelcast.client.impl.protocol.codec.builtin.ListMultiFrameCodec;
import com.hazelcast.client.impl.protocol.codec.builtin.StringCodec;
import com.hazelcast.client.impl.protocol.codec.custom.ListenerConfigHolderCodec;
import com.hazelcast.client.impl.protocol.task.dynamicconfig.ListenerConfigHolder;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;

public final class DynamicConfigAddMultiMapConfigCodec {
    public static final int REQUEST_MESSAGE_TYPE = 0x1B0100;
    public static final int RESPONSE_MESSAGE_TYPE = 0x1B0101;
    private static final int REQUEST_BINARY_FIELD_OFFSET = 16;
    private static final int REQUEST_BACKUP_COUNT_FIELD_OFFSET = 17;
    private static final int REQUEST_ASYNC_BACKUP_COUNT_FIELD_OFFSET = 21;
    private static final int REQUEST_STATISTICS_ENABLED_FIELD_OFFSET = 25;
    private static final int REQUEST_MERGE_BATCH_SIZE_FIELD_OFFSET = 26;
    private static final int REQUEST_INITIAL_FRAME_SIZE = 30;
    private static final int RESPONSE_INITIAL_FRAME_SIZE = 13;

    private DynamicConfigAddMultiMapConfigCodec() {
    }

    public static ClientMessage encodeRequest(String name, String collectionType, @Nullable Collection<ListenerConfigHolder> listenerConfigs, boolean binary, int backupCount, int asyncBackupCount, boolean statisticsEnabled, @Nullable String splitBrainProtectionName, String mergePolicy, int mergeBatchSize) {
        ClientMessage clientMessage = ClientMessage.createForEncode();
        clientMessage.setRetryable(false);
        clientMessage.setOperationName("DynamicConfig.AddMultiMapConfig");
        ClientMessage.Frame initialFrame = new ClientMessage.Frame(new byte[30], 49152);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 0, 0x1B0100);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 12, -1);
        FixedSizeTypesCodec.encodeBoolean(initialFrame.content, 16, binary);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 17, backupCount);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 21, asyncBackupCount);
        FixedSizeTypesCodec.encodeBoolean(initialFrame.content, 25, statisticsEnabled);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 26, mergeBatchSize);
        clientMessage.add(initialFrame);
        StringCodec.encode(clientMessage, name);
        StringCodec.encode(clientMessage, collectionType);
        ListMultiFrameCodec.encodeNullable(clientMessage, listenerConfigs, ListenerConfigHolderCodec::encode);
        CodecUtil.encodeNullable(clientMessage, splitBrainProtectionName, StringCodec::encode);
        StringCodec.encode(clientMessage, mergePolicy);
        return clientMessage;
    }

    public static RequestParameters decodeRequest(ClientMessage clientMessage) {
        ClientMessage.ForwardFrameIterator iterator2 = clientMessage.frameIterator();
        RequestParameters request = new RequestParameters();
        ClientMessage.Frame initialFrame = iterator2.next();
        request.binary = FixedSizeTypesCodec.decodeBoolean(initialFrame.content, 16);
        request.backupCount = FixedSizeTypesCodec.decodeInt(initialFrame.content, 17);
        request.asyncBackupCount = FixedSizeTypesCodec.decodeInt(initialFrame.content, 21);
        request.statisticsEnabled = FixedSizeTypesCodec.decodeBoolean(initialFrame.content, 25);
        request.mergeBatchSize = FixedSizeTypesCodec.decodeInt(initialFrame.content, 26);
        request.name = StringCodec.decode(iterator2);
        request.collectionType = StringCodec.decode(iterator2);
        request.listenerConfigs = ListMultiFrameCodec.decodeNullable(iterator2, ListenerConfigHolderCodec::decode);
        request.splitBrainProtectionName = CodecUtil.decodeNullable(iterator2, StringCodec::decode);
        request.mergePolicy = StringCodec.decode(iterator2);
        return request;
    }

    public static ClientMessage encodeResponse() {
        ClientMessage clientMessage = ClientMessage.createForEncode();
        ClientMessage.Frame initialFrame = new ClientMessage.Frame(new byte[13], 49152);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 0, 0x1B0101);
        clientMessage.add(initialFrame);
        return clientMessage;
    }

    @SuppressFBWarnings(value={"URF_UNREAD_PUBLIC_OR_PROTECTED_FIELD"})
    public static class RequestParameters {
        public String name;
        public String collectionType;
        @Nullable
        public List<ListenerConfigHolder> listenerConfigs;
        public boolean binary;
        public int backupCount;
        public int asyncBackupCount;
        public boolean statisticsEnabled;
        @Nullable
        public String splitBrainProtectionName;
        public String mergePolicy;
        public int mergeBatchSize;
    }
}

