/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.transform;

import com.google.auto.service.AutoService;
import org.apache.seatunnel.api.configuration.Option;
import org.apache.seatunnel.api.configuration.Options;
import org.apache.seatunnel.api.table.type.SeaTunnelRow;
import org.apache.seatunnel.api.table.type.SeaTunnelRowType;
import org.apache.seatunnel.api.transform.SeaTunnelTransform;
import org.apache.seatunnel.common.config.CheckConfigUtil;
import org.apache.seatunnel.common.config.CheckResult;
import org.apache.seatunnel.shade.com.typesafe.config.Config;
import org.apache.seatunnel.transform.common.AbstractSeaTunnelTransform;
import org.apache.seatunnel.transform.sqlengine.SQLEngine;
import org.apache.seatunnel.transform.sqlengine.SQLEngineFactory;

@AutoService(value={SeaTunnelTransform.class})
public class SQLTransform
extends AbstractSeaTunnelTransform {
    public static final Option<String> KEY_QUERY = Options.key((String)"query").stringType().noDefaultValue().withDescription("The query SQL");
    public static final Option<String> KEY_ENGINE = Options.key((String)"engine").stringType().defaultValue((Object)SQLEngineFactory.EngineType.ZETA.name()).withDescription("The SQL engine type");
    private String query;
    private SQLEngineFactory.EngineType engineType;
    private transient SQLEngine sqlEngine;

    public String getPluginName() {
        return "Sql";
    }

    @Override
    protected void setConfig(Config pluginConfig) {
        CheckResult checkResult = CheckConfigUtil.checkAllExists((Config)pluginConfig, (String[])new String[]{KEY_QUERY.key()});
        if (!checkResult.isSuccess()) {
            throw new IllegalArgumentException("Failed to check config! " + checkResult.getMsg());
        }
        this.query = pluginConfig.getString(KEY_QUERY.key());
        this.engineType = pluginConfig.hasPath(KEY_ENGINE.key()) ? SQLEngineFactory.EngineType.valueOf(pluginConfig.getString(KEY_ENGINE.key()).toUpperCase()) : SQLEngineFactory.EngineType.ZETA;
    }

    public void open() {
        this.sqlEngine = SQLEngineFactory.getSQLEngine(this.engineType);
        this.sqlEngine.init(this.inputTableName, this.inputRowType, this.query);
    }

    private void tryOpen() {
        if (this.sqlEngine == null) {
            this.open();
        }
    }

    @Override
    protected SeaTunnelRowType transformRowType(SeaTunnelRowType inputRowType) {
        this.tryOpen();
        return this.sqlEngine.typeMapping();
    }

    @Override
    protected SeaTunnelRow transformRow(SeaTunnelRow inputRow) {
        this.tryOpen();
        return this.sqlEngine.transformBySQL(inputRow);
    }

    public void close() {
        this.sqlEngine.close();
    }
}

