/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.transform;

import com.google.auto.service.AutoService;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.seatunnel.api.common.SeaTunnelAPIErrorCode;
import org.apache.seatunnel.api.configuration.Option;
import org.apache.seatunnel.api.configuration.Options;
import org.apache.seatunnel.api.table.type.SeaTunnelDataType;
import org.apache.seatunnel.api.table.type.SeaTunnelRow;
import org.apache.seatunnel.api.table.type.SeaTunnelRowType;
import org.apache.seatunnel.api.transform.SeaTunnelTransform;
import org.apache.seatunnel.common.exception.CommonErrorCode;
import org.apache.seatunnel.common.exception.SeaTunnelErrorCode;
import org.apache.seatunnel.common.utils.JsonUtils;
import org.apache.seatunnel.shade.com.fasterxml.jackson.databind.JsonNode;
import org.apache.seatunnel.shade.com.fasterxml.jackson.databind.node.ObjectNode;
import org.apache.seatunnel.shade.com.typesafe.config.Config;
import org.apache.seatunnel.shade.com.typesafe.config.ConfigRenderOptions;
import org.apache.seatunnel.transform.common.AbstractSeaTunnelTransform;
import org.apache.seatunnel.transform.exception.FieldMapperTransformErrorCode;
import org.apache.seatunnel.transform.exception.FieldMapperTransformException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@AutoService(value={SeaTunnelTransform.class})
public class FieldMapperTransform
extends AbstractSeaTunnelTransform {
    private static final Logger log = LoggerFactory.getLogger(FieldMapperTransform.class);
    public static final Option<Map<String, String>> FIELD_MAPPER = Options.key((String)"field_mapper").mapType().noDefaultValue().withDescription("Specify the field mapping relationship between input and output");
    private LinkedHashMap<String, String> fieldMapper = new LinkedHashMap();
    private List<Integer> needReaderColIndex;

    public String getPluginName() {
        return "FieldMapper";
    }

    @Override
    protected void setConfig(Config pluginConfig) {
        if (!pluginConfig.hasPath(FIELD_MAPPER.key())) {
            throw new FieldMapperTransformException((SeaTunnelErrorCode)SeaTunnelAPIErrorCode.CONFIG_VALIDATION_FAILED, "The configuration missing key: " + FIELD_MAPPER);
        }
        this.fieldMapper = FieldMapperTransform.convertConfigToSortedMap(pluginConfig.getConfig(FIELD_MAPPER.key()));
    }

    private static LinkedHashMap<String, String> convertConfigToSortedMap(Config config) {
        ConfigRenderOptions options = ConfigRenderOptions.concise();
        String json = config.root().render(options);
        ObjectNode jsonNodes = JsonUtils.parseObject((String)json);
        LinkedHashMap<String, String> fieldsMap = new LinkedHashMap<String, String>();
        jsonNodes.fields().forEachRemaining(field -> {
            String key = (String)field.getKey();
            JsonNode value = (JsonNode)field.getValue();
            if (!value.isTextual()) {
                String errorMsg = String.format("The value [%s] of key [%s] that in config is not text", value, key);
                throw new FieldMapperTransformException((SeaTunnelErrorCode)CommonErrorCode.ILLEGAL_ARGUMENT, errorMsg);
            }
            fieldsMap.put(key, value.textValue());
        });
        return fieldsMap;
    }

    @Override
    protected SeaTunnelRowType transformRowType(SeaTunnelRowType inputRowType) {
        this.needReaderColIndex = new ArrayList<Integer>(this.fieldMapper.size());
        ArrayList outputFiledNameList = new ArrayList(this.fieldMapper.size());
        ArrayList outputDataTypeList = new ArrayList(this.fieldMapper.size());
        ArrayList inputFieldNames = Lists.newArrayList((Object[])inputRowType.getFieldNames());
        this.fieldMapper.forEach((key, value) -> {
            int fieldIndex = inputFieldNames.indexOf(key);
            if (fieldIndex < 0) {
                throw new FieldMapperTransformException((SeaTunnelErrorCode)FieldMapperTransformErrorCode.INPUT_FIELD_NOT_FOUND, "Can not found field " + key + " from inputRowType");
            }
            this.needReaderColIndex.add(fieldIndex);
            outputFiledNameList.add(value);
            outputDataTypeList.add(inputRowType.getFieldTypes()[fieldIndex]);
        });
        return new SeaTunnelRowType(outputFiledNameList.toArray(new String[0]), outputDataTypeList.toArray(new SeaTunnelDataType[0]));
    }

    @Override
    protected SeaTunnelRow transformRow(SeaTunnelRow inputRow) {
        Object[] outputDataArray = new Object[this.fieldMapper.size()];
        for (int i = 0; i < outputDataArray.length; ++i) {
            outputDataArray[i] = inputRow.getField(this.needReaderColIndex.get(i).intValue());
        }
        SeaTunnelRow outputRow = new SeaTunnelRow(outputDataArray);
        outputRow.setRowKind(inputRow.getRowKind());
        outputRow.setTableId(inputRow.getTableId());
        return outputRow;
    }
}

