/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.engine.server.master;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.hazelcast.logging.ILogger;
import com.hazelcast.map.IMap;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;
import org.apache.seatunnel.api.common.metrics.JobMetrics;
import org.apache.seatunnel.api.common.metrics.RawJobMetrics;
import org.apache.seatunnel.engine.core.job.JobDAGInfo;
import org.apache.seatunnel.engine.core.job.JobStatus;
import org.apache.seatunnel.engine.core.job.PipelineStatus;
import org.apache.seatunnel.engine.server.dag.physical.PipelineLocation;
import org.apache.seatunnel.engine.server.execution.ExecutionState;
import org.apache.seatunnel.engine.server.execution.TaskGroupLocation;
import org.apache.seatunnel.engine.server.master.JobMaster;
import org.apache.seatunnel.engine.server.metrics.JobMetricsUtil;

public class JobHistoryService {
    private final IMap<Object, Object> runningJobStateIMap;
    private final ILogger logger;
    private final Map<Long, JobMaster> runningJobMasterMap;
    private final IMap<Long, JobDAGInfo> finishedJobDAGInfoImap;
    private final IMap<Long, JobStateData> finishedJobStateImap;
    private final IMap<Long, JobMetrics> finishedJobMetricsImap;
    private final ObjectMapper objectMapper;

    public JobHistoryService(IMap<Object, Object> runningJobStateIMap, ILogger logger, Map<Long, JobMaster> runningJobMasterMap, IMap<Long, JobStateData> finishedJobStateImap, IMap<Long, JobMetrics> finishedJobMetricsImap, IMap<Long, JobDAGInfo> finishedJobVertexInfoImap) {
        this.runningJobStateIMap = runningJobStateIMap;
        this.logger = logger;
        this.runningJobMasterMap = runningJobMasterMap;
        this.finishedJobStateImap = finishedJobStateImap;
        this.finishedJobMetricsImap = finishedJobMetricsImap;
        this.finishedJobDAGInfoImap = finishedJobVertexInfoImap;
        this.objectMapper = new ObjectMapper();
        this.objectMapper.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
    }

    public String listAllJob() {
        ObjectNode objectNode = this.objectMapper.createObjectNode();
        ArrayNode jobs = objectNode.putArray("jobs");
        Stream.concat(this.runningJobMasterMap.values().stream().map(this::toJobStateMapper), this.finishedJobStateImap.values().stream()).forEach(jobStateData -> {
            JobStatusData jobStatusData = new JobStatusData(jobStateData.jobId, jobStateData.jobStatus);
            Object jsonNode = this.objectMapper.valueToTree(jobStatusData);
            jobs.add((JsonNode)jsonNode);
        });
        return jobs.toString();
    }

    public JobStateData getJobDetailState(Long jobId) {
        return this.runningJobMasterMap.containsKey(jobId) ? this.toJobStateMapper(this.runningJobMasterMap.get(jobId)) : (JobStateData)this.finishedJobStateImap.getOrDefault(jobId, null);
    }

    public JobMetrics getJobMetrics(Long jobId) {
        return this.finishedJobMetricsImap.getOrDefault(jobId, null);
    }

    public JobDAGInfo getJobDAGInfo(Long jobId) {
        return this.finishedJobDAGInfoImap.getOrDefault(jobId, null);
    }

    public String getJobDetailStateAsString(Long jobId) {
        JobStateData jobStatus = this.getJobDetailState(jobId);
        if (null != jobStatus) {
            try {
                return this.objectMapper.writeValueAsString(jobStatus);
            }
            catch (JsonProcessingException e) {
                this.logger.severe("serialize jobStateMapper err", e);
                ObjectNode objectNode = this.objectMapper.createObjectNode();
                objectNode.put("err", "serialize jobStateMapper err");
                return objectNode.toString();
            }
        }
        ObjectNode objectNode = this.objectMapper.createObjectNode();
        objectNode.put("err", String.format("jobId : %s not found", jobId));
        return objectNode.toString();
    }

    public void storeFinishedJobState(JobMaster jobMaster) {
        JobStateData jobStateData = this.toJobStateMapper(jobMaster);
        this.finishedJobStateImap.put(jobStateData.jobId, jobStateData, 14L, TimeUnit.DAYS);
    }

    public void storeFinishedJobMetrics(JobMaster jobMaster) {
        List<RawJobMetrics> currJobMetrics = jobMaster.getCurrJobMetrics();
        JobMetrics jobMetrics = JobMetricsUtil.toJobMetrics(currJobMetrics);
        Long jobId = jobMaster.getJobImmutableInformation().getJobId();
        this.finishedJobMetricsImap.put(jobId, jobMetrics, 14L, TimeUnit.DAYS);
        jobMaster.cleanTaskGroupContext();
    }

    private JobStateData toJobStateMapper(JobMaster jobMaster) {
        Long jobId = jobMaster.getJobImmutableInformation().getJobId();
        HashMap<PipelineLocation, PipelineStateData> pipelineStateMapperMap = new HashMap<PipelineLocation, PipelineStateData>();
        jobMaster.getPhysicalPlan().getPipelineList().forEach(pipeline -> {
            PipelineLocation pipelineLocation = pipeline.getPipelineLocation();
            PipelineStatus pipelineState = (PipelineStatus)((Object)((Object)this.runningJobStateIMap.get(pipelineLocation)));
            HashMap<TaskGroupLocation, ExecutionState> taskStateMap = new HashMap<TaskGroupLocation, ExecutionState>();
            pipeline.getCoordinatorVertexList().forEach(coordinator -> {
                TaskGroupLocation taskGroupLocation = coordinator.getTaskGroupLocation();
                taskStateMap.put(taskGroupLocation, (ExecutionState)this.runningJobStateIMap.get(taskGroupLocation));
            });
            pipeline.getPhysicalVertexList().forEach(task -> {
                TaskGroupLocation taskGroupLocation = task.getTaskGroupLocation();
                taskStateMap.put(taskGroupLocation, (ExecutionState)this.runningJobStateIMap.get(taskGroupLocation));
            });
            PipelineStateData pipelineStateData = new PipelineStateData(pipelineState, taskStateMap);
            pipelineStateMapperMap.put(pipelineLocation, pipelineStateData);
        });
        JobStatus jobStatus = (JobStatus)((Object)this.runningJobStateIMap.get(jobId));
        return new JobStateData(jobId, jobStatus, pipelineStateMapperMap);
    }

    public void storeJobInfo(long jobId, JobDAGInfo jobInfo) {
        this.finishedJobDAGInfoImap.put(jobId, jobInfo);
    }

    public static final class PipelineStateData
    implements Serializable {
        PipelineStatus pipelineStatus;
        Map<TaskGroupLocation, ExecutionState> executionStateMap;

        public PipelineStateData(PipelineStatus pipelineStatus, Map<TaskGroupLocation, ExecutionState> executionStateMap) {
            this.pipelineStatus = pipelineStatus;
            this.executionStateMap = executionStateMap;
        }

        public PipelineStatus getPipelineStatus() {
            return this.pipelineStatus;
        }

        public Map<TaskGroupLocation, ExecutionState> getExecutionStateMap() {
            return this.executionStateMap;
        }

        public void setPipelineStatus(PipelineStatus pipelineStatus) {
            this.pipelineStatus = pipelineStatus;
        }

        public void setExecutionStateMap(Map<TaskGroupLocation, ExecutionState> executionStateMap) {
            this.executionStateMap = executionStateMap;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof PipelineStateData)) {
                return false;
            }
            PipelineStateData other = (PipelineStateData)o;
            PipelineStatus this$pipelineStatus = this.getPipelineStatus();
            PipelineStatus other$pipelineStatus = other.getPipelineStatus();
            if (this$pipelineStatus == null ? other$pipelineStatus != null : !((Object)((Object)this$pipelineStatus)).equals((Object)other$pipelineStatus)) {
                return false;
            }
            Map<TaskGroupLocation, ExecutionState> this$executionStateMap = this.getExecutionStateMap();
            Map<TaskGroupLocation, ExecutionState> other$executionStateMap = other.getExecutionStateMap();
            return !(this$executionStateMap == null ? other$executionStateMap != null : !((Object)this$executionStateMap).equals(other$executionStateMap));
        }

        public int hashCode() {
            int PRIME = 59;
            int result2 = 1;
            PipelineStatus $pipelineStatus = this.getPipelineStatus();
            result2 = result2 * 59 + ($pipelineStatus == null ? 43 : ((Object)((Object)$pipelineStatus)).hashCode());
            Map<TaskGroupLocation, ExecutionState> $executionStateMap = this.getExecutionStateMap();
            result2 = result2 * 59 + ($executionStateMap == null ? 43 : ((Object)$executionStateMap).hashCode());
            return result2;
        }

        public String toString() {
            return "JobHistoryService.PipelineStateData(pipelineStatus=" + (Object)((Object)this.getPipelineStatus()) + ", executionStateMap=" + this.getExecutionStateMap() + ")";
        }
    }

    public static final class JobStateData
    implements Serializable {
        Long jobId;
        JobStatus jobStatus;
        Map<PipelineLocation, PipelineStateData> pipelineStateMapperMap;

        public JobStateData(Long jobId, JobStatus jobStatus, Map<PipelineLocation, PipelineStateData> pipelineStateMapperMap) {
            this.jobId = jobId;
            this.jobStatus = jobStatus;
            this.pipelineStateMapperMap = pipelineStateMapperMap;
        }

        public Long getJobId() {
            return this.jobId;
        }

        public JobStatus getJobStatus() {
            return this.jobStatus;
        }

        public Map<PipelineLocation, PipelineStateData> getPipelineStateMapperMap() {
            return this.pipelineStateMapperMap;
        }

        public void setJobId(Long jobId) {
            this.jobId = jobId;
        }

        public void setJobStatus(JobStatus jobStatus) {
            this.jobStatus = jobStatus;
        }

        public void setPipelineStateMapperMap(Map<PipelineLocation, PipelineStateData> pipelineStateMapperMap) {
            this.pipelineStateMapperMap = pipelineStateMapperMap;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof JobStateData)) {
                return false;
            }
            JobStateData other = (JobStateData)o;
            Long this$jobId = this.getJobId();
            Long other$jobId = other.getJobId();
            if (this$jobId == null ? other$jobId != null : !((Object)this$jobId).equals(other$jobId)) {
                return false;
            }
            JobStatus this$jobStatus = this.getJobStatus();
            JobStatus other$jobStatus = other.getJobStatus();
            if (this$jobStatus == null ? other$jobStatus != null : !((Object)((Object)this$jobStatus)).equals((Object)other$jobStatus)) {
                return false;
            }
            Map<PipelineLocation, PipelineStateData> this$pipelineStateMapperMap = this.getPipelineStateMapperMap();
            Map<PipelineLocation, PipelineStateData> other$pipelineStateMapperMap = other.getPipelineStateMapperMap();
            return !(this$pipelineStateMapperMap == null ? other$pipelineStateMapperMap != null : !((Object)this$pipelineStateMapperMap).equals(other$pipelineStateMapperMap));
        }

        public int hashCode() {
            int PRIME = 59;
            int result2 = 1;
            Long $jobId = this.getJobId();
            result2 = result2 * 59 + ($jobId == null ? 43 : ((Object)$jobId).hashCode());
            JobStatus $jobStatus = this.getJobStatus();
            result2 = result2 * 59 + ($jobStatus == null ? 43 : ((Object)((Object)$jobStatus)).hashCode());
            Map<PipelineLocation, PipelineStateData> $pipelineStateMapperMap = this.getPipelineStateMapperMap();
            result2 = result2 * 59 + ($pipelineStateMapperMap == null ? 43 : ((Object)$pipelineStateMapperMap).hashCode());
            return result2;
        }

        public String toString() {
            return "JobHistoryService.JobStateData(jobId=" + this.getJobId() + ", jobStatus=" + (Object)((Object)this.getJobStatus()) + ", pipelineStateMapperMap=" + this.getPipelineStateMapperMap() + ")";
        }
    }

    public static final class JobStatusData
    implements Serializable {
        Long jobId;
        JobStatus jobStatus;

        public JobStatusData(Long jobId, JobStatus jobStatus) {
            this.jobId = jobId;
            this.jobStatus = jobStatus;
        }

        public Long getJobId() {
            return this.jobId;
        }

        public JobStatus getJobStatus() {
            return this.jobStatus;
        }

        public void setJobId(Long jobId) {
            this.jobId = jobId;
        }

        public void setJobStatus(JobStatus jobStatus) {
            this.jobStatus = jobStatus;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof JobStatusData)) {
                return false;
            }
            JobStatusData other = (JobStatusData)o;
            Long this$jobId = this.getJobId();
            Long other$jobId = other.getJobId();
            if (this$jobId == null ? other$jobId != null : !((Object)this$jobId).equals(other$jobId)) {
                return false;
            }
            JobStatus this$jobStatus = this.getJobStatus();
            JobStatus other$jobStatus = other.getJobStatus();
            return !(this$jobStatus == null ? other$jobStatus != null : !((Object)((Object)this$jobStatus)).equals((Object)other$jobStatus));
        }

        public int hashCode() {
            int PRIME = 59;
            int result2 = 1;
            Long $jobId = this.getJobId();
            result2 = result2 * 59 + ($jobId == null ? 43 : ((Object)$jobId).hashCode());
            JobStatus $jobStatus = this.getJobStatus();
            result2 = result2 * 59 + ($jobStatus == null ? 43 : ((Object)((Object)$jobStatus)).hashCode());
            return result2;
        }

        public String toString() {
            return "JobHistoryService.JobStatusData(jobId=" + this.getJobId() + ", jobStatus=" + (Object)((Object)this.getJobStatus()) + ")";
        }
    }
}

