/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.common.utils;

public class RetryUtils {
    public static <T> T retryWithException(Execution<T, Exception> execution, RetryMaterial retryMaterial) throws Exception {
        RetryCondition<Exception> retryCondition = retryMaterial.getRetryCondition();
        int retryTimes = retryMaterial.getRetryTimes();
        if (retryMaterial.getRetryTimes() < 0) {
            throw new IllegalArgumentException("Retry times must be greater than 0");
        }
        int i = 0;
        while (true) {
            ++i;
            try {
                return execution.execute();
            }
            catch (Exception e) {
                Exception lastException = e;
                if (retryCondition != null && !retryCondition.canRetry(e)) {
                    if (!retryMaterial.shouldThrowException()) continue;
                    throw e;
                }
                if (retryMaterial.getSleepTimeMillis() <= 0L) continue;
                Thread.sleep(retryMaterial.getSleepTimeMillis());
                if (i <= retryTimes) continue;
                if (retryMaterial.shouldThrowException()) {
                    throw new RuntimeException("Execute given execution failed after retry " + retryTimes + " times", lastException);
                }
                return null;
            }
            break;
        }
    }

    public static interface RetryCondition<T> {
        public boolean canRetry(T var1);
    }

    @FunctionalInterface
    public static interface Execution<T, E extends Exception> {
        public T execute() throws E;
    }

    public static class RetryMaterial {
        private final int retryTimes;
        private final boolean shouldThrowException;
        private final RetryCondition<Exception> retryCondition;
        private final long sleepTimeMillis;

        public RetryMaterial(int retryTimes, boolean shouldThrowException, RetryCondition<Exception> retryCondition) {
            this(retryTimes, shouldThrowException, retryCondition, 0L);
        }

        public RetryMaterial(int retryTimes, boolean shouldThrowException, RetryCondition<Exception> retryCondition, long sleepTimeMillis) {
            this.retryTimes = retryTimes;
            this.shouldThrowException = shouldThrowException;
            this.retryCondition = retryCondition;
            this.sleepTimeMillis = sleepTimeMillis;
        }

        public int getRetryTimes() {
            return this.retryTimes;
        }

        public boolean shouldThrowException() {
            return this.shouldThrowException;
        }

        public RetryCondition<Exception> getRetryCondition() {
            return this.retryCondition;
        }

        public long getSleepTimeMillis() {
            return this.sleepTimeMillis;
        }
    }
}

