/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.sql.impl.expression.string;

import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.sql.impl.QueryException;
import com.hazelcast.sql.impl.SqlDataSerializerHook;
import com.hazelcast.sql.impl.expression.Expression;
import com.hazelcast.sql.impl.expression.ExpressionEvalContext;
import com.hazelcast.sql.impl.expression.TriExpression;
import com.hazelcast.sql.impl.expression.math.MathFunctionUtils;
import com.hazelcast.sql.impl.expression.string.StringFunctionUtils;
import com.hazelcast.sql.impl.row.Row;
import com.hazelcast.sql.impl.type.QueryDataType;

public class SubstringFunction
extends TriExpression<String>
implements IdentifiedDataSerializable {
    public SubstringFunction() {
    }

    private SubstringFunction(Expression<?> input2, Expression<?> start, Expression<?> length) {
        super(input2, start, length);
    }

    public static SubstringFunction create(Expression<?> input2, Expression<?> start, Expression<?> length) {
        return new SubstringFunction(input2, start, length);
    }

    @Override
    public String eval(Row row, ExpressionEvalContext context) {
        Integer length;
        String input2;
        try {
            input2 = StringFunctionUtils.asVarchar(this.operand1, row, context);
        }
        catch (Exception e) {
            throw QueryException.dataException("Failed to get value of input operand of SUBSTRING function: " + e.getMessage(), e);
        }
        if (input2 == null) {
            return null;
        }
        Integer start = MathFunctionUtils.asInt(this.operand2, row, context);
        if (start == null) {
            return null;
        }
        if (start < 1) {
            throw QueryException.dataException("SUBSTRING \"start\" operand must be positive");
        }
        int adjustedStart = start - 1;
        if (adjustedStart >= input2.length()) {
            return "";
        }
        if (this.operand3 != null) {
            length = MathFunctionUtils.asInt(this.operand3, row, context);
            if (length == null) {
                return null;
            }
        } else {
            length = null;
        }
        if (length == null) {
            return adjustedStart > 0 ? input2.substring(adjustedStart) : input2;
        }
        if (length < 0) {
            throw QueryException.dataException("SUBSTRING \"length\" operand cannot be negative");
        }
        if (length == 0) {
            return "";
        }
        if (adjustedStart + length > input2.length()) {
            return adjustedStart > 0 ? input2.substring(adjustedStart) : input2;
        }
        return input2.substring(adjustedStart, adjustedStart + length);
    }

    @Override
    public QueryDataType getType() {
        return QueryDataType.VARCHAR;
    }

    @Override
    public int getFactoryId() {
        return SqlDataSerializerHook.F_ID;
    }

    @Override
    public int getClassId() {
        return 46;
    }
}

