/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.spi.impl.merge;

import com.hazelcast.internal.nio.IOUtil;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.internal.serialization.SerializationService;
import com.hazelcast.internal.serialization.SerializationServiceAware;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.spi.impl.merge.SplitBrainDataSerializerHook;
import com.hazelcast.spi.merge.SplitBrainMergeTypes;
import java.io.IOException;
import java.util.Objects;

public class MapMergingEntryImpl<K, V>
implements SplitBrainMergeTypes.MapMergeTypes<K, V>,
SerializationServiceAware,
IdentifiedDataSerializable {
    private Data value;
    private Data key;
    private long cost = -1L;
    private long creationTime = -1L;
    private long expirationTime = -1L;
    private long hits = -1L;
    private long lastAccessTime = -1L;
    private long lastStoredTime = -1L;
    private long lastUpdateTime = -1L;
    private long version = -1L;
    private long ttl = -1L;
    private Long maxIdle;
    private transient SerializationService serializationService;

    public MapMergingEntryImpl() {
    }

    public MapMergingEntryImpl(SerializationService serializationService) {
        this.serializationService = serializationService;
    }

    @Override
    public Data getRawValue() {
        return this.value;
    }

    @Override
    public V getValue() {
        return (V)this.serializationService.toObject(this.value);
    }

    public MapMergingEntryImpl<K, V> setValue(Data value) {
        this.value = value;
        return this;
    }

    @Override
    public Data getRawKey() {
        return this.key;
    }

    @Override
    public K getKey() {
        return (K)this.serializationService.toObject(this.key);
    }

    public MapMergingEntryImpl<K, V> setKey(Data key) {
        this.key = key;
        return this;
    }

    @Override
    public long getCost() {
        return this.cost;
    }

    public MapMergingEntryImpl<K, V> setCost(long cost) {
        this.cost = cost;
        return this;
    }

    @Override
    public long getCreationTime() {
        return this.creationTime;
    }

    public MapMergingEntryImpl<K, V> setCreationTime(long creationTime) {
        this.creationTime = creationTime;
        return this;
    }

    @Override
    public long getExpirationTime() {
        return this.expirationTime;
    }

    public MapMergingEntryImpl<K, V> setExpirationTime(long expirationTime) {
        this.expirationTime = expirationTime;
        return this;
    }

    @Override
    public long getHits() {
        return this.hits;
    }

    public MapMergingEntryImpl<K, V> setHits(long hits) {
        this.hits = hits;
        return this;
    }

    @Override
    public long getLastAccessTime() {
        return this.lastAccessTime;
    }

    public MapMergingEntryImpl<K, V> setLastAccessTime(long lastAccessTime) {
        this.lastAccessTime = lastAccessTime;
        return this;
    }

    @Override
    public long getLastStoredTime() {
        return this.lastStoredTime;
    }

    public MapMergingEntryImpl<K, V> setLastStoredTime(long lastStoredTime) {
        this.lastStoredTime = lastStoredTime;
        return this;
    }

    @Override
    public long getLastUpdateTime() {
        return this.lastUpdateTime;
    }

    public MapMergingEntryImpl<K, V> setLastUpdateTime(long lastUpdateTime) {
        this.lastUpdateTime = lastUpdateTime;
        return this;
    }

    @Override
    public long getVersion() {
        return this.version;
    }

    public MapMergingEntryImpl<K, V> setVersion(long version) {
        this.version = version;
        return this;
    }

    @Override
    public long getTtl() {
        return this.ttl;
    }

    public MapMergingEntryImpl<K, V> setTtl(long ttl) {
        this.ttl = ttl;
        return this;
    }

    @Override
    public Long getMaxIdle() {
        return this.maxIdle;
    }

    public MapMergingEntryImpl<K, V> setMaxIdle(Long maxIdle) {
        this.maxIdle = maxIdle;
        return this;
    }

    @Override
    public void setSerializationService(SerializationService serializationService) {
        this.serializationService = serializationService;
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        IOUtil.writeObject(out, this.key);
        IOUtil.writeObject(out, this.value);
        out.writeLong(this.cost);
        out.writeLong(this.creationTime);
        out.writeLong(this.expirationTime);
        out.writeLong(this.hits);
        out.writeLong(this.lastAccessTime);
        out.writeLong(this.lastStoredTime);
        out.writeLong(this.lastUpdateTime);
        out.writeLong(this.version);
        out.writeLong(this.ttl);
        boolean hasMaxIdle = this.maxIdle != null;
        out.writeBoolean(hasMaxIdle);
        if (hasMaxIdle) {
            out.writeLong(this.maxIdle);
        }
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        this.key = (Data)IOUtil.readObject(in);
        this.value = (Data)IOUtil.readObject(in);
        this.cost = in.readLong();
        this.creationTime = in.readLong();
        this.expirationTime = in.readLong();
        this.hits = in.readLong();
        this.lastAccessTime = in.readLong();
        this.lastStoredTime = in.readLong();
        this.lastUpdateTime = in.readLong();
        this.version = in.readLong();
        this.ttl = in.readLong();
        boolean hasMaxIdle = in.readBoolean();
        if (hasMaxIdle) {
            this.maxIdle = in.readLong();
        }
    }

    @Override
    public int getFactoryId() {
        return SplitBrainDataSerializerHook.F_ID;
    }

    @Override
    public int getClassId() {
        return 4;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MapMergingEntryImpl that = (MapMergingEntryImpl)o;
        if (this.cost != that.cost) {
            return false;
        }
        if (this.creationTime != that.creationTime) {
            return false;
        }
        if (this.expirationTime != that.expirationTime) {
            return false;
        }
        if (this.hits != that.hits) {
            return false;
        }
        if (this.lastAccessTime != that.lastAccessTime) {
            return false;
        }
        if (this.lastStoredTime != that.lastStoredTime) {
            return false;
        }
        if (this.lastUpdateTime != that.lastUpdateTime) {
            return false;
        }
        if (this.version != that.version) {
            return false;
        }
        if (this.ttl != that.ttl) {
            return false;
        }
        if (!Objects.equals(this.value, that.value)) {
            return false;
        }
        if (!Objects.equals(this.key, that.key)) {
            return false;
        }
        return Objects.equals(this.maxIdle, that.maxIdle);
    }

    public int hashCode() {
        int result2 = this.value != null ? this.value.hashCode() : 0;
        result2 = 31 * result2 + (this.key != null ? this.key.hashCode() : 0);
        result2 = 31 * result2 + (int)(this.cost ^ this.cost >>> 32);
        result2 = 31 * result2 + (int)(this.creationTime ^ this.creationTime >>> 32);
        result2 = 31 * result2 + (int)(this.expirationTime ^ this.expirationTime >>> 32);
        result2 = 31 * result2 + (int)(this.hits ^ this.hits >>> 32);
        result2 = 31 * result2 + (int)(this.lastAccessTime ^ this.lastAccessTime >>> 32);
        result2 = 31 * result2 + (int)(this.lastStoredTime ^ this.lastStoredTime >>> 32);
        result2 = 31 * result2 + (int)(this.lastUpdateTime ^ this.lastUpdateTime >>> 32);
        result2 = 31 * result2 + (int)(this.version ^ this.version >>> 32);
        result2 = 31 * result2 + (int)(this.ttl ^ this.ttl >>> 32);
        result2 = 31 * result2 + (this.maxIdle != null ? this.maxIdle.hashCode() : 0);
        return result2;
    }

    public String toString() {
        return "MapMergingEntry{key=" + this.key + ", value=" + this.value + ", cost=" + this.cost + ", creationTime=" + this.creationTime + ", expirationTime=" + this.expirationTime + ", hits=" + this.hits + ", lastAccessTime=" + this.lastAccessTime + ", lastStoredTime=" + this.lastStoredTime + ", lastUpdateTime=" + this.lastUpdateTime + ", version=" + this.version + ", ttl=" + this.ttl + ", maxIdle=" + this.maxIdle + '}';
    }
}

