/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.com.fasterxml.jackson.jr.ob.impl;

import com.hazelcast.com.fasterxml.jackson.jr.ob.impl.JSONReader;
import com.hazelcast.com.fasterxml.jackson.jr.ob.impl.JSONWriter;
import com.hazelcast.com.fasterxml.jackson.jr.ob.impl.POJODefinition;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Map;
import java.util.TreeMap;

public class BeanPropertyIntrospector {
    protected static final POJODefinition.Prop[] NO_PROPS = new POJODefinition.Prop[0];
    private static final BeanPropertyIntrospector INSTANCE = new BeanPropertyIntrospector();

    public static BeanPropertyIntrospector instance() {
        return INSTANCE;
    }

    public POJODefinition pojoDefinitionForDeserialization(JSONReader jSONReader, Class<?> clazz) {
        return this._construct(clazz);
    }

    public POJODefinition pojoDefinitionForSerialization(JSONWriter jSONWriter, Class<?> clazz) {
        return this._construct(clazz);
    }

    private POJODefinition _construct(Class<?> clazz) {
        POJODefinition.Prop[] propArray;
        TreeMap<String, POJODefinition.PropBuilder> treeMap = new TreeMap<String, POJODefinition.PropBuilder>();
        BeanPropertyIntrospector._introspect(clazz, treeMap);
        Constructor<?> constructor = null;
        Constructor<?> constructor2 = null;
        Constructor<?> constructor3 = null;
        for (Constructor<?> constructor4 : clazz.getDeclaredConstructors()) {
            Object object = constructor4.getParameterTypes();
            if (((Class<?>[])object).length == 0) {
                constructor = constructor4;
                continue;
            }
            if (((Class<?>[])object).length != 1) continue;
            Class<?> clazz2 = object[0];
            if (clazz2 == String.class) {
                constructor2 = constructor4;
                continue;
            }
            if (clazz2 != Long.class && clazz2 != Long.TYPE) continue;
            constructor3 = constructor4;
        }
        int n = treeMap.size();
        if (n == 0) {
            propArray = NO_PROPS;
        } else {
            propArray = new POJODefinition.Prop[n];
            int n2 = 0;
            for (Object object : treeMap.values()) {
                propArray[n2++] = ((POJODefinition.PropBuilder)object).build();
            }
        }
        return new POJODefinition(clazz, propArray, constructor, constructor2, constructor3);
    }

    private static void _introspect(Class<?> clazz, Map<String, POJODefinition.PropBuilder> map2) {
        if (clazz == null || clazz == Object.class) {
            return;
        }
        BeanPropertyIntrospector._introspect(clazz.getSuperclass(), map2);
        for (Field accessibleObject : clazz.getDeclaredFields()) {
            if (!Modifier.isPublic(accessibleObject.getModifiers()) || accessibleObject.isEnumConstant() || accessibleObject.isSynthetic()) continue;
            BeanPropertyIntrospector._propFrom(map2, accessibleObject.getName()).withField(accessibleObject);
        }
        for (AccessibleObject accessibleObject : clazz.getDeclaredMethods()) {
            Object object;
            int n = ((Method)accessibleObject).getModifiers();
            if (Modifier.isStatic(n) || ((Method)accessibleObject).isSynthetic() || ((Method)accessibleObject).isBridge()) continue;
            Class<?>[] classArray = ((Method)accessibleObject).getParameterTypes();
            if (classArray.length == 0) {
                if (!Modifier.isPublic(n) || (object = ((Method)accessibleObject).getReturnType()) == Void.class) continue;
                String string2 = ((Method)accessibleObject).getName();
                if (string2.startsWith("get")) {
                    if (string2.length() <= 3) continue;
                    string2 = BeanPropertyIntrospector.decap(string2.substring(3));
                    BeanPropertyIntrospector._propFrom(map2, string2).withGetter((Method)accessibleObject);
                    continue;
                }
                if (!string2.startsWith("is") || string2.length() <= 2) continue;
                string2 = BeanPropertyIntrospector.decap(string2.substring(2));
                BeanPropertyIntrospector._propFrom(map2, string2).withIsGetter((Method)accessibleObject);
                continue;
            }
            if (classArray.length != 1 || !((String)(object = ((Method)accessibleObject).getName())).startsWith("set") || ((String)object).length() == 3) continue;
            object = BeanPropertyIntrospector.decap(((String)object).substring(3));
            BeanPropertyIntrospector._propFrom(map2, (String)object).withSetter((Method)accessibleObject);
        }
    }

    private static POJODefinition.PropBuilder _propFrom(Map<String, POJODefinition.PropBuilder> map2, String string2) {
        POJODefinition.PropBuilder propBuilder = map2.get(string2);
        if (propBuilder == null) {
            propBuilder = POJODefinition.Prop.builder(string2);
            map2.put(string2, propBuilder);
        }
        return propBuilder;
    }

    private static String decap(String string2) {
        char c;
        char c2 = string2.charAt(0);
        if (!(c2 == (c = Character.toLowerCase(c2)) || string2.length() != 1 && Character.isUpperCase(string2.charAt(1)))) {
            char[] cArray = string2.toCharArray();
            cArray[0] = c;
            return new String(cArray);
        }
        return string2;
    }
}

