/*
 * Decompiled with CFR 0.152.
 */
package org.apache.samza.storage.kv.descriptors;

import java.util.HashMap;
import java.util.Map;
import org.apache.samza.serializers.KVSerde;
import org.apache.samza.storage.kv.descriptors.BaseLocalStoreBackedTableDescriptor;
import org.apache.samza.storage.kv.descriptors.RocksDbTableProviderFactory;
import org.apache.samza.table.TableSpec;

public class RocksDbTableDescriptor<K, V>
extends BaseLocalStoreBackedTableDescriptor<K, V, RocksDbTableDescriptor<K, V>> {
    public static final String WRITE_BATCH_SIZE = "write.batch.size";
    public static final String OBJECT_CACHE_SIZE = "object.cache.size";
    public static final String CONTAINER_CACHE_SIZE_BYTES = "container.cache.size.bytes";
    public static final String CONTAINER_WRITE_BUFFER_SIZE_BYTES = "container.write.buffer.size.bytes";
    public static final String ROCKSDB_COMPRESSION = "rocksdb.compression";
    public static final String ROCKSDB_BLOCK_SIZE_BYTES = "rocksdb.block.size.bytes";
    public static final String ROCKSDB_TTL_MS = "rocksdb.ttl.ms";
    public static final String ROCKSDB_COMPACTION_STYLE = "rocksdb.compaction.style";
    public static final String ROCKSDB_NUM_WRITE_BUFFERS = "rocksdb.num.write.buffers";
    public static final String ROCKSDB_MAX_LOG_FILE_SIZE_BYTES = "rocksdb.max.log.file.size.bytes";
    public static final String ROCKSDB_KEEP_LOG_FILE_NUM = "rocksdb.keep.log.file.num";
    private Integer writeBatchSize;
    private Integer objectCacheSize;
    private Integer cacheSize;
    private Integer writeBufferSize;
    private Integer blockSize;
    private Integer ttl;
    private Integer numWriteBuffers;
    private Integer maxLogFileSize;
    private Integer numLogFilesToKeep;
    private String compressionType;
    private String compactionStyle;

    public RocksDbTableDescriptor(String tableId) {
        super(tableId);
    }

    public RocksDbTableDescriptor(String tableId, KVSerde<K, V> serde) {
        super(tableId, serde);
    }

    public RocksDbTableDescriptor withWriteBatchSize(int writeBatchSize) {
        this.writeBatchSize = writeBatchSize;
        return this;
    }

    public RocksDbTableDescriptor withObjectCacheSize(int objectCacheSize) {
        this.objectCacheSize = objectCacheSize;
        return this;
    }

    public RocksDbTableDescriptor<K, V> withCacheSize(int cacheSize) {
        this.cacheSize = cacheSize;
        return this;
    }

    public RocksDbTableDescriptor<K, V> withWriteBufferSize(int writeBufferSize) {
        this.writeBufferSize = writeBufferSize;
        return this;
    }

    public RocksDbTableDescriptor<K, V> withCompressionType(String compressionType) {
        this.compressionType = compressionType;
        return this;
    }

    public RocksDbTableDescriptor<K, V> withBlockSize(int blockSize) {
        this.blockSize = blockSize;
        return this;
    }

    public RocksDbTableDescriptor<K, V> withTtl(int ttl) {
        this.ttl = ttl;
        return this;
    }

    public RocksDbTableDescriptor<K, V> withCompactionStyle(String compactionStyle) {
        this.compactionStyle = compactionStyle;
        return this;
    }

    public RocksDbTableDescriptor<K, V> withNumWriteBuffers(int numWriteBuffers) {
        this.numWriteBuffers = numWriteBuffers;
        return this;
    }

    public RocksDbTableDescriptor<K, V> withMaxLogFileSize(int maxLogFileSize) {
        this.maxLogFileSize = maxLogFileSize;
        return this;
    }

    public RocksDbTableDescriptor<K, V> withNumLogFilesToKeep(int numLogFilesToKeep) {
        this.numLogFilesToKeep = numLogFilesToKeep;
        return this;
    }

    public TableSpec getTableSpec() {
        this.validate();
        HashMap<String, String> tableSpecConfig = new HashMap<String, String>();
        this.generateTableSpecConfig(tableSpecConfig);
        return new TableSpec(this.tableId, this.serde, RocksDbTableProviderFactory.class.getName(), tableSpecConfig, this.sideInputs, this.sideInputsProcessor);
    }

    protected void generateTableSpecConfig(Map<String, String> tableSpecConfig) {
        super.generateTableSpecConfig(tableSpecConfig);
        if (this.writeBatchSize != null) {
            this.addRocksDbConfig(tableSpecConfig, WRITE_BATCH_SIZE, this.writeBatchSize.toString());
        }
        if (this.objectCacheSize != null) {
            this.addRocksDbConfig(tableSpecConfig, OBJECT_CACHE_SIZE, this.objectCacheSize.toString());
        }
        if (this.cacheSize != null) {
            this.addRocksDbConfig(tableSpecConfig, CONTAINER_CACHE_SIZE_BYTES, this.cacheSize.toString());
        }
        if (this.writeBufferSize != null) {
            this.addRocksDbConfig(tableSpecConfig, CONTAINER_WRITE_BUFFER_SIZE_BYTES, this.writeBufferSize.toString());
        }
        if (this.compressionType != null) {
            this.addRocksDbConfig(tableSpecConfig, ROCKSDB_COMPRESSION, this.compressionType);
        }
        if (this.blockSize != null) {
            this.addRocksDbConfig(tableSpecConfig, ROCKSDB_BLOCK_SIZE_BYTES, this.blockSize.toString());
        }
        if (this.ttl != null) {
            this.addRocksDbConfig(tableSpecConfig, ROCKSDB_TTL_MS, this.ttl.toString());
        }
        if (this.compactionStyle != null) {
            this.addRocksDbConfig(tableSpecConfig, ROCKSDB_COMPACTION_STYLE, this.compactionStyle);
        }
        if (this.numWriteBuffers != null) {
            this.addRocksDbConfig(tableSpecConfig, ROCKSDB_NUM_WRITE_BUFFERS, this.numWriteBuffers.toString());
        }
        if (this.maxLogFileSize != null) {
            this.addRocksDbConfig(tableSpecConfig, ROCKSDB_MAX_LOG_FILE_SIZE_BYTES, this.maxLogFileSize.toString());
        }
        if (this.numLogFilesToKeep != null) {
            this.addRocksDbConfig(tableSpecConfig, ROCKSDB_KEEP_LOG_FILE_NUM, this.numLogFilesToKeep.toString());
        }
    }

    private void addRocksDbConfig(Map<String, String> map, String key, String value) {
        map.put("rocksdb." + key, value);
    }
}

