/*
 * Decompiled with CFR 0.152.
 */
package org.apache.samza.storage.kv;

import java.io.File;
import org.apache.samza.config.Config;
import org.apache.samza.config.StorageConfig$;
import org.apache.samza.context.ContainerContext;
import org.apache.samza.context.JobContext;
import org.apache.samza.metrics.MetricsRegistry;
import org.apache.samza.serializers.Serde;
import org.apache.samza.storage.StorageEngine;
import org.apache.samza.storage.kv.BaseKeyValueStorageEngineFactory;
import org.apache.samza.storage.kv.KeyValueStore;
import org.apache.samza.storage.kv.KeyValueStoreMetrics;
import org.apache.samza.storage.kv.RocksDbKeyValueStore;
import org.apache.samza.storage.kv.RocksDbOptionsHelper;
import org.apache.samza.system.SystemStreamPartition;
import org.apache.samza.task.MessageCollector;
import org.rocksdb.FlushOptions;
import org.rocksdb.Options;
import org.rocksdb.WriteOptions;
import scala.Function0;
import scala.Serializable;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001)4A!\u0001\u0002\u0001\u001b\t\u0019#k\\2lg\u0012\u00137*Z=WC2,Xm\u0015;pe\u0006<W-\u00128hS:,g)Y2u_JL(BA\u0002\u0005\u0003\tYgO\u0003\u0002\u0006\r\u000591\u000f^8sC\u001e,'BA\u0004\t\u0003\u0015\u0019\u0018-\u001c>b\u0015\tI!\"\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u0017\u0005\u0019qN]4\u0004\u0001U\u0019a\"\b\u0016\u0014\u0007\u0001yq\u0003\u0005\u0002\u0011+5\t\u0011C\u0003\u0002\u0013'\u0005!A.\u00198h\u0015\u0005!\u0012\u0001\u00026bm\u0006L!AF\t\u0003\r=\u0013'.Z2u!\u0011A\u0012dG\u0015\u000e\u0003\tI!A\u0007\u0002\u0003A\t\u000b7/Z&fsZ\u000bG.^3Ti>\u0014\u0018mZ3F]\u001eLg.\u001a$bGR|'/\u001f\t\u00039ua\u0001\u0001B\u0003\u001f\u0001\t\u0007qDA\u0001L#\t\u0001c\u0005\u0005\u0002\"I5\t!EC\u0001$\u0003\u0015\u00198-\u00197b\u0013\t)#EA\u0004O_RD\u0017N\\4\u0011\u0005\u0005:\u0013B\u0001\u0015#\u0005\r\te.\u001f\t\u00039)\"Qa\u000b\u0001C\u0002}\u0011\u0011A\u0016\u0005\u0006[\u0001!\tAL\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003=\u0002B\u0001\u0007\u0001\u001cS!)\u0011\u0007\u0001C!e\u0005Qq-\u001a;L-N#xN]3\u0015\u000fMbT)T+^KB!\u0001\u0004\u000e\u001c7\u0013\t)$AA\u0007LKf4\u0016\r\\;f'R|'/\u001a\t\u0004C]J\u0014B\u0001\u001d#\u0005\u0015\t%O]1z!\t\t#(\u0003\u0002<E\t!!)\u001f;f\u0011\u0015i\u0004\u00071\u0001?\u0003%\u0019Ho\u001c:f\u001d\u0006lW\r\u0005\u0002@\u0005:\u0011\u0011\u0005Q\u0005\u0003\u0003\n\na\u0001\u0015:fI\u00164\u0017BA\"E\u0005\u0019\u0019FO]5oO*\u0011\u0011I\t\u0005\u0006\rB\u0002\raR\u0001\tgR|'/\u001a#jeB\u0011\u0001jS\u0007\u0002\u0013*\u0011!jE\u0001\u0003S>L!\u0001T%\u0003\t\u0019KG.\u001a\u0005\u0006\u001dB\u0002\raT\u0001\te\u0016<\u0017n\u001d;ssB\u0011\u0001kU\u0007\u0002#*\u0011!KB\u0001\b[\u0016$(/[2t\u0013\t!\u0016KA\bNKR\u0014\u0018nY:SK\u001eL7\u000f\u001e:z\u0011\u00151\u0006\u00071\u0001X\u0003y\u0019\u0007.\u00198hK2{wmU=ti\u0016l7\u000b\u001e:fC6\u0004\u0016M\u001d;ji&|g\u000e\u0005\u0002Y76\t\u0011L\u0003\u0002[\r\u000511/_:uK6L!\u0001X-\u0003+MK8\u000f^3n'R\u0014X-Y7QCJ$\u0018\u000e^5p]\")a\f\ra\u0001?\u0006Q!n\u001c2D_:$X\r\u001f;\u0011\u0005\u0001\u001cW\"A1\u000b\u0005\t4\u0011aB2p]R,\u0007\u0010^\u0005\u0003I\u0006\u0014!BS8c\u0007>tG/\u001a=u\u0011\u00151\u0007\u00071\u0001h\u0003A\u0019wN\u001c;bS:,'oQ8oi\u0016DH\u000f\u0005\u0002aQ&\u0011\u0011.\u0019\u0002\u0011\u0007>tG/Y5oKJ\u001cuN\u001c;fqR\u0004")
public class RocksDbKeyValueStorageEngineFactory<K, V>
implements BaseKeyValueStorageEngineFactory<K, V> {
    private final String org$apache$samza$storage$kv$BaseKeyValueStorageEngineFactory$$INMEMORY_KV_STORAGE_ENGINE_FACTORY;

    public String org$apache$samza$storage$kv$BaseKeyValueStorageEngineFactory$$INMEMORY_KV_STORAGE_ENGINE_FACTORY() {
        return this.org$apache$samza$storage$kv$BaseKeyValueStorageEngineFactory$$INMEMORY_KV_STORAGE_ENGINE_FACTORY;
    }

    public void org$apache$samza$storage$kv$BaseKeyValueStorageEngineFactory$_setter_$org$apache$samza$storage$kv$BaseKeyValueStorageEngineFactory$$INMEMORY_KV_STORAGE_ENGINE_FACTORY_$eq(String x$1) {
        this.org$apache$samza$storage$kv$BaseKeyValueStorageEngineFactory$$INMEMORY_KV_STORAGE_ENGINE_FACTORY = x$1;
    }

    public StorageEngine getStorageEngine(String storeName, File storeDir, Serde<K> keySerde, Serde<V> msgSerde, MessageCollector collector, MetricsRegistry registry, SystemStreamPartition changeLogSystemStreamPartition, JobContext jobContext, ContainerContext containerContext) {
        return BaseKeyValueStorageEngineFactory.class.getStorageEngine((BaseKeyValueStorageEngineFactory)this, (String)storeName, (File)storeDir, keySerde, msgSerde, (MessageCollector)collector, (MetricsRegistry)registry, (SystemStreamPartition)changeLogSystemStreamPartition, (JobContext)jobContext, (ContainerContext)containerContext);
    }

    public KeyValueStore<byte[], byte[]> getKVStore(String storeName, File storeDir, MetricsRegistry registry, SystemStreamPartition changeLogSystemStreamPartition, JobContext jobContext, ContainerContext containerContext) {
        Config storageConfig = jobContext.getConfig().subset(new StringBuilder().append((Object)"stores.").append((Object)storeName).append((Object)".").toString(), true);
        boolean isLoggedStore = StorageConfig$.MODULE$.Config2Storage(jobContext.getConfig()).getChangelogStream(storeName).isDefined();
        KeyValueStoreMetrics rocksDbMetrics = new KeyValueStoreMetrics(storeName, registry);
        int numTasksForContainer = containerContext.getContainerModel().getTasks().keySet().size();
        rocksDbMetrics.newGauge("rocksdb.block-cache-size", (Function0)new Serializable(this, storageConfig, numTasksForContainer){
            public static final long serialVersionUID = 0L;
            private final Config storageConfig$1;
            private final int numTasksForContainer$1;

            public final Long apply() {
                return RocksDbOptionsHelper.getBlockCacheSize(this.storageConfig$1, this.numTasksForContainer$1);
            }
            {
                this.storageConfig$1 = storageConfig$1;
                this.numTasksForContainer$1 = numTasksForContainer$1;
            }
        });
        Options rocksDbOptions = RocksDbOptionsHelper.options(storageConfig, numTasksForContainer);
        WriteOptions rocksDbWriteOptions = new WriteOptions().setDisableWAL(true);
        FlushOptions rocksDbFlushOptions = new FlushOptions().setWaitForFlush(true);
        RocksDbKeyValueStore rocksDb = new RocksDbKeyValueStore(storeDir, rocksDbOptions, storageConfig, isLoggedStore, storeName, rocksDbWriteOptions, rocksDbFlushOptions, rocksDbMetrics);
        return rocksDb;
    }

    public RocksDbKeyValueStorageEngineFactory() {
        BaseKeyValueStorageEngineFactory.class.$init$((BaseKeyValueStorageEngineFactory)this);
    }
}

