/*
 * Decompiled with CFR 0.152.
 */
package org.apache.samza.util;

import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import kafka.common.ErrorMapping$;
import org.apache.kafka.common.PartitionInfo;
import org.apache.kafka.common.errors.ReplicaNotAvailableException;
import org.apache.samza.config.Config;
import org.apache.samza.execution.StreamManager;
import org.apache.samza.system.OutgoingMessageEnvelope;
import org.apache.samza.util.ExponentialSleepStrategy;
import org.apache.samza.util.Logging;
import org.slf4j.Logger;
import scala.Function0;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.math.package$;
import scala.runtime.BoxesRunTime;

public final class KafkaUtil$
implements Logging {
    public static final KafkaUtil$ MODULE$;
    private final int CHECKPOINT_LOG_VERSION_NUMBER;
    private final AtomicLong counter;
    private final String loggerName;
    private final Logger logger;
    private final String startupLoggerName;
    private final Logger startupLogger;
    private volatile byte bitmap$0;

    static {
        new KafkaUtil$();
    }

    public String loggerName() {
        return this.loggerName;
    }

    private Logger logger$lzycompute() {
        KafkaUtil$ kafkaUtil$ = this;
        synchronized (kafkaUtil$) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.logger = Logging.class.logger((Logging)this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.logger$lzycompute() : this.logger;
    }

    public String startupLoggerName() {
        return this.startupLoggerName;
    }

    private Logger startupLogger$lzycompute() {
        KafkaUtil$ kafkaUtil$ = this;
        synchronized (kafkaUtil$) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.startupLogger = Logging.class.startupLogger((Logging)this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
            return this.startupLogger;
        }
    }

    public Logger startupLogger() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.startupLogger$lzycompute() : this.startupLogger;
    }

    public void org$apache$samza$util$Logging$_setter_$loggerName_$eq(String x$1) {
        this.loggerName = x$1;
    }

    public void org$apache$samza$util$Logging$_setter_$startupLoggerName_$eq(String x$1) {
        this.startupLoggerName = x$1;
    }

    public void startupLog(Function0<Object> message) {
        Logging.class.startupLog((Logging)this, message);
    }

    public void trace(Function0<Object> message) {
        Logging.class.trace((Logging)this, message);
    }

    public void trace(Function0<Object> message, Function0<Throwable> e) {
        Logging.class.trace((Logging)this, message, e);
    }

    public void debug(Function0<Object> message) {
        Logging.class.debug((Logging)this, message);
    }

    public void debug(Function0<Object> message, Function0<Throwable> e) {
        Logging.class.debug((Logging)this, message, e);
    }

    public void info(Function0<Object> message) {
        Logging.class.info((Logging)this, message);
    }

    public void info(Function0<Object> message, Function0<Throwable> e) {
        Logging.class.info((Logging)this, message, e);
    }

    public void warn(Function0<Object> message) {
        Logging.class.warn((Logging)this, message);
    }

    public void warn(Function0<Object> message, Function0<Throwable> e) {
        Logging.class.warn((Logging)this, message, e);
    }

    public void error(Function0<Object> message) {
        Logging.class.error((Logging)this, message);
    }

    public void error(Function0<Object> message, Function0<Throwable> e) {
        Logging.class.error((Logging)this, message, e);
    }

    public void putMDC(Function0<String> key, Function0<String> value) {
        Logging.class.putMDC((Logging)this, key, value);
    }

    public String getMDC(Function0<String> key) {
        return Logging.class.getMDC((Logging)this, key);
    }

    public void removeMDC(Function0<String> key) {
        Logging.class.removeMDC((Logging)this, key);
    }

    public void clearMDC() {
        Logging.class.clearMDC((Logging)this);
    }

    public int CHECKPOINT_LOG_VERSION_NUMBER() {
        return this.CHECKPOINT_LOG_VERSION_NUMBER;
    }

    public AtomicLong counter() {
        return this.counter;
    }

    private int abs(int n) {
        return n == Integer.MIN_VALUE ? 0 : package$.MODULE$.abs(n);
    }

    public Integer getIntegerPartitionKey(OutgoingMessageEnvelope envelope, List<PartitionInfo> partitions) {
        int numPartitions = partitions.size();
        return Predef$.MODULE$.int2Integer(this.abs(envelope.getPartitionKey().hashCode()) % numPartitions);
    }

    public String getCheckpointTopic(String jobName, String jobId, Config config) {
        String checkpointTopic = new StringOps(Predef$.MODULE$.augmentString("__samza_checkpoint_ver_%d_for_%s_%s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.CHECKPOINT_LOG_VERSION_NUMBER()), jobName.replaceAll("_", "-"), jobId.replaceAll("_", "-")}));
        return StreamManager.createUniqueNameForBatch((String)checkpointTopic, (Config)config);
    }

    public void maybeThrowException(Exception e) {
        try {
            if (e != null) {
                throw e;
            }
        }
        catch (ReplicaNotAvailableException replicaNotAvailableException) {
            this.debug((Function0<Object>)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Got ReplicaNotAvailableException, but ignoring since it's safe to do so.";
                }
            });
        }
    }

    public boolean isBadErrorCode(short code) {
        return code != ErrorMapping$.MODULE$.NoError() && code != ErrorMapping$.MODULE$.ReplicaNotAvailableCode();
    }

    public ExponentialSleepStrategy $lessinit$greater$default$1() {
        return new ExponentialSleepStrategy();
    }

    private KafkaUtil$() {
        MODULE$ = this;
        Logging.class.$init$((Logging)this);
        this.CHECKPOINT_LOG_VERSION_NUMBER = 1;
        this.counter = new AtomicLong(0L);
    }
}

