/*
 * Decompiled with CFR 0.152.
 */
package org.apache.samza.util;

import java.util.concurrent.atomic.AtomicInteger;
import kafka.api.TopicMetadata;
import kafka.api.TopicMetadataResponse;
import kafka.client.ClientUtils$;
import kafka.cluster.BrokerEndPoint;
import org.apache.samza.SamzaException;
import org.apache.samza.util.ClientUtilTopicMetadataStore$;
import org.apache.samza.util.Logging;
import org.apache.samza.util.TopicMetadataStore;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0005a\u0001B\u0001\u0003\u0001-\u0011Ad\u00117jK:$X\u000b^5m)>\u0004\u0018nY'fi\u0006$\u0017\r^1Ti>\u0014XM\u0003\u0002\u0004\t\u0005!Q\u000f^5m\u0015\t)a!A\u0003tC6T\u0018M\u0003\u0002\b\u0011\u00051\u0011\r]1dQ\u0016T\u0011!C\u0001\u0004_J<7\u0001A\n\u0004\u00011\u0011\u0002CA\u0007\u0011\u001b\u0005q!\"A\b\u0002\u000bM\u001c\u0017\r\\1\n\u0005Eq!AB!osJ+g\r\u0005\u0002\u0014)5\t!!\u0003\u0002\u0016\u0005\t\u0011Bk\u001c9jG6+G/\u00193bi\u0006\u001cFo\u001c:f\u0011!9\u0002A!A!\u0002\u0013A\u0012!\u00052s_.,'o\u001d'jgR\u001cFO]5oOB\u0011\u0011\u0004\b\b\u0003\u001biI!a\u0007\b\u0002\rA\u0013X\rZ3g\u0013\tibD\u0001\u0004TiJLgn\u001a\u0006\u000379A\u0001\u0002\t\u0001\u0003\u0002\u0003\u0006I\u0001G\u0001\tG2LWM\u001c;JI\"A!\u0005\u0001B\u0001B\u0003%1%A\u0004uS6,w.\u001e;\u0011\u00055!\u0013BA\u0013\u000f\u0005\rIe\u000e\u001e\u0005\u0006O\u0001!\t\u0001K\u0001\u0007y%t\u0017\u000e\u001e \u0015\t%R3\u0006\f\t\u0003'\u0001AQa\u0006\u0014A\u0002aAQ\u0001\t\u0014A\u0002aAqA\t\u0014\u0011\u0002\u0003\u00071\u0005C\u0004/\u0001\t\u0007I\u0011A\u0018\u0002\u000f\t\u0014xn[3sgV\t\u0001\u0007E\u00022iYj\u0011A\r\u0006\u0003g9\t!bY8mY\u0016\u001cG/[8o\u0013\t)$GA\u0002TKF\u0004\"a\u000e\u001f\u000e\u0003aR!!\u000f\u001e\u0002\u000f\rdWo\u001d;fe*\t1(A\u0003lC\u001a\\\u0017-\u0003\u0002>q\tq!I]8lKJ,e\u000e\u001a)pS:$\bBB \u0001A\u0003%\u0001'\u0001\u0005ce>\\WM]:!\u0011\u001d\t\u0005\u00011A\u0005\u0002\t\u000baaY8se&#U#A\"\u0011\u0005\u0011cU\"A#\u000b\u0005\u0019;\u0015AB1u_6L7M\u0003\u0002I\u0013\u0006Q1m\u001c8dkJ\u0014XM\u001c;\u000b\u0005\rQ%\"A&\u0002\t)\fg/Y\u0005\u0003\u001b\u0016\u0013Q\"\u0011;p[&\u001c\u0017J\u001c;fO\u0016\u0014\bbB(\u0001\u0001\u0004%\t\u0001U\u0001\u000bG>\u0014(/\u0013#`I\u0015\fHCA)U!\ti!+\u0003\u0002T\u001d\t!QK\\5u\u0011\u001d)f*!AA\u0002\r\u000b1\u0001\u001f\u00132\u0011\u00199\u0006\u0001)Q\u0005\u0007\u000691m\u001c:s\u0013\u0012\u0003\u0003\"B-\u0001\t\u0003Q\u0016\u0001D4fiR{\u0007/[2J]\u001a|GCA.h!\u0011av\fG1\u000e\u0003uS!A\u0018\u001a\u0002\u0013%lW.\u001e;bE2,\u0017B\u00011^\u0005\ri\u0015\r\u001d\t\u0003E\u0016l\u0011a\u0019\u0006\u0003Ij\n1!\u00199j\u0013\t17MA\u0007U_BL7-T3uC\u0012\fG/\u0019\u0005\u0006Qb\u0003\r![\u0001\u0007i>\u0004\u0018nY:\u0011\u0007eQ\u0007$\u0003\u0002l=\t\u00191+\u001a;\b\u000f5\u0014\u0011\u0011!E\u0001]\u0006a2\t\\5f]R,F/\u001b7U_BL7-T3uC\u0012\fG/Y*u_J,\u0007CA\np\r\u001d\t!!!A\t\u0002A\u001c\"a\u001c\u0007\t\u000b\u001dzG\u0011\u0001:\u0015\u00039Dq\u0001^8\u0012\u0002\u0013\u0005Q/A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$HeM\u000b\u0002m*\u00121e^\u0016\u0002qB\u0011\u0011P`\u0007\u0002u*\u00111\u0010`\u0001\nk:\u001c\u0007.Z2lK\u0012T!! \b\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0002\u0000u\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3")
public class ClientUtilTopicMetadataStore
implements TopicMetadataStore {
    private final String clientId;
    private final int timeout;
    private final Seq<BrokerEndPoint> brokers;
    private AtomicInteger corrID;
    private final String loggerName;
    private final Logger logger;
    private final String startupLoggerName;
    private final Logger startupLogger;
    private volatile byte bitmap$0;

    public static int $lessinit$greater$default$3() {
        return ClientUtilTopicMetadataStore$.MODULE$.$lessinit$greater$default$3();
    }

    public String loggerName() {
        return this.loggerName;
    }

    private Logger logger$lzycompute() {
        ClientUtilTopicMetadataStore clientUtilTopicMetadataStore = this;
        synchronized (clientUtilTopicMetadataStore) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.logger = Logging.class.logger((Logging)this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.logger$lzycompute() : this.logger;
    }

    public String startupLoggerName() {
        return this.startupLoggerName;
    }

    private Logger startupLogger$lzycompute() {
        ClientUtilTopicMetadataStore clientUtilTopicMetadataStore = this;
        synchronized (clientUtilTopicMetadataStore) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.startupLogger = Logging.class.startupLogger((Logging)this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
            return this.startupLogger;
        }
    }

    public Logger startupLogger() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.startupLogger$lzycompute() : this.startupLogger;
    }

    public void org$apache$samza$util$Logging$_setter_$loggerName_$eq(String x$1) {
        this.loggerName = x$1;
    }

    public void org$apache$samza$util$Logging$_setter_$startupLoggerName_$eq(String x$1) {
        this.startupLoggerName = x$1;
    }

    public void startupLog(Function0<Object> message) {
        Logging.class.startupLog((Logging)this, message);
    }

    public void trace(Function0<Object> message) {
        Logging.class.trace((Logging)this, message);
    }

    public void trace(Function0<Object> message, Function0<Throwable> e) {
        Logging.class.trace((Logging)this, message, e);
    }

    public void debug(Function0<Object> message) {
        Logging.class.debug((Logging)this, message);
    }

    public void debug(Function0<Object> message, Function0<Throwable> e) {
        Logging.class.debug((Logging)this, message, e);
    }

    public void info(Function0<Object> message) {
        Logging.class.info((Logging)this, message);
    }

    public void info(Function0<Object> message, Function0<Throwable> e) {
        Logging.class.info((Logging)this, message, e);
    }

    public void warn(Function0<Object> message) {
        Logging.class.warn((Logging)this, message);
    }

    public void warn(Function0<Object> message, Function0<Throwable> e) {
        Logging.class.warn((Logging)this, message, e);
    }

    public void error(Function0<Object> message) {
        Logging.class.error((Logging)this, message);
    }

    public void error(Function0<Object> message, Function0<Throwable> e) {
        Logging.class.error((Logging)this, message, e);
    }

    public void putMDC(Function0<String> key, Function0<String> value) {
        Logging.class.putMDC((Logging)this, key, value);
    }

    public String getMDC(Function0<String> key) {
        return Logging.class.getMDC((Logging)this, key);
    }

    public void removeMDC(Function0<String> key) {
        Logging.class.removeMDC((Logging)this, key);
    }

    public void clearMDC() {
        Logging.class.clearMDC((Logging)this);
    }

    public Seq<BrokerEndPoint> brokers() {
        return this.brokers;
    }

    public AtomicInteger corrID() {
        return this.corrID;
    }

    public void corrID_$eq(AtomicInteger x$1) {
        this.corrID = x$1;
    }

    @Override
    public Map<String, TopicMetadata> getTopicInfo(Set<String> topics) {
        int currCorrId = this.corrID().getAndIncrement();
        this.debug((Function0<Object>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Fetching topic metadata.";
            }
        });
        TopicMetadataResponse response = ClientUtils$.MODULE$.fetchTopicMetadata(topics, this.brokers(), this.clientId, this.timeout, currCorrId);
        this.debug((Function0<Object>)new Serializable(this, response){
            public static final long serialVersionUID = 0L;
            private final TopicMetadataResponse response$1;

            public final String apply() {
                return new StringOps(Predef$.MODULE$.augmentString("Got topic metadata response: %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.response$1}));
            }
            {
                this.response$1 = response$1;
            }
        });
        if (response.correlationId() != currCorrId) {
            throw new SamzaException(new StringOps(Predef$.MODULE$.augmentString("CorrelationID did not match for request on topics %s (sent %d, got %d)")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topics, BoxesRunTime.boxToInteger((int)currCorrId), BoxesRunTime.boxToInteger((int)response.correlationId())})));
        }
        return ((TraversableOnce)response.topicsMetadata().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Tuple2<String, TopicMetadata> apply(TopicMetadata metadata) {
                return new Tuple2((Object)metadata.topic(), (Object)metadata);
            }
        }, Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
    }

    public ClientUtilTopicMetadataStore(String brokersListString, String clientId, int timeout) {
        this.clientId = clientId;
        this.timeout = timeout;
        Logging.class.$init$((Logging)this);
        this.brokers = ClientUtils$.MODULE$.parseBrokerList(brokersListString);
        this.corrID = new AtomicInteger(0);
    }
}

