/*
 * Decompiled with CFR 0.152.
 */
package org.apache.samza.system.kafka.descriptors;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.apache.samza.config.KafkaConfig;
import org.apache.samza.serializers.Serde;
import org.apache.samza.system.descriptors.OutputDescriptorProvider;
import org.apache.samza.system.descriptors.SimpleInputDescriptorProvider;
import org.apache.samza.system.descriptors.SystemDescriptor;
import org.apache.samza.system.kafka.KafkaSystemFactory;
import org.apache.samza.system.kafka.descriptors.KafkaInputDescriptor;
import org.apache.samza.system.kafka.descriptors.KafkaOutputDescriptor;

public class KafkaSystemDescriptor
extends SystemDescriptor<KafkaSystemDescriptor>
implements SimpleInputDescriptorProvider,
OutputDescriptorProvider {
    private static final String FACTORY_CLASS_NAME = KafkaSystemFactory.class.getName();
    private static final String CONSUMER_ZK_CONNECT_CONFIG_KEY = "systems.%s.consumer.zookeeper.connect";
    private static final String CONSUMER_AUTO_OFFSET_RESET_CONFIG_KEY = "systems.%s.consumer.auto.offset.reset";
    private static final String CONSUMER_FETCH_THRESHOLD_CONFIG_KEY = KafkaConfig.CONSUMER_FETCH_THRESHOLD();
    private static final String CONSUMER_FETCH_THRESHOLD_BYTES_CONFIG_KEY = KafkaConfig.CONSUMER_FETCH_THRESHOLD_BYTES();
    private static final String CONSUMER_FETCH_MESSAGE_MAX_BYTES_KEY = "systems.%s.consumer.fetch.message.max.bytes";
    private static final String CONSUMER_CONFIGS_CONFIG_KEY = "systems.%s.consumer.%s";
    private static final String PRODUCER_BOOTSTRAP_SERVERS_CONFIG_KEY = "systems.%s.producer.bootstrap.servers";
    private static final String PRODUCER_CONFIGS_CONFIG_KEY = "systems.%s.producer.%s";
    private List<String> consumerZkConnect = Collections.emptyList();
    private Optional<String> consumerAutoOffsetResetOptional = Optional.empty();
    private Optional<Integer> consumerFetchThresholdOptional = Optional.empty();
    private Optional<Long> consumerFetchThresholdBytesOptional = Optional.empty();
    private Optional<Long> consumerFetchMessageMaxBytesOptional = Optional.empty();
    private Map<String, String> consumerConfigs = Collections.emptyMap();
    private List<String> producerBootstrapServers = Collections.emptyList();
    private Map<String, String> producerConfigs = Collections.emptyMap();

    public KafkaSystemDescriptor(String systemName) {
        super(systemName, FACTORY_CLASS_NAME, null, null);
    }

    public <StreamMessageType> KafkaInputDescriptor<StreamMessageType> getInputDescriptor(String streamId, Serde<StreamMessageType> serde) {
        return new KafkaInputDescriptor(streamId, this, serde, null);
    }

    public <StreamMessageType> KafkaOutputDescriptor<StreamMessageType> getOutputDescriptor(String streamId, Serde<StreamMessageType> serde) {
        return new KafkaOutputDescriptor<StreamMessageType>(streamId, this, serde);
    }

    public KafkaSystemDescriptor withConsumerZkConnect(List<String> consumerZkConnect) {
        this.consumerZkConnect = consumerZkConnect;
        return this;
    }

    public KafkaSystemDescriptor withConsumerAutoOffsetReset(String consumerAutoOffsetReset) {
        this.consumerAutoOffsetResetOptional = Optional.of(StringUtils.stripToNull((String)consumerAutoOffsetReset));
        return this;
    }

    public KafkaSystemDescriptor withSamzaFetchThreshold(int fetchThreshold) {
        this.consumerFetchThresholdOptional = Optional.of(fetchThreshold);
        return this;
    }

    public KafkaSystemDescriptor withSamzaFetchThresholdBytes(long fetchThresholdBytes) {
        this.consumerFetchThresholdBytesOptional = Optional.of(fetchThresholdBytes);
        return this;
    }

    public KafkaSystemDescriptor withConsumerFetchMessageMaxBytes(long fetchMessageMaxBytes) {
        this.consumerFetchMessageMaxBytesOptional = Optional.of(fetchMessageMaxBytes);
        return this;
    }

    public KafkaSystemDescriptor withConsumerConfigs(Map<String, String> consumerConfigs) {
        this.consumerConfigs = consumerConfigs;
        return this;
    }

    public KafkaSystemDescriptor withProducerBootstrapServers(List<String> producerBootstrapServers) {
        this.producerBootstrapServers = producerBootstrapServers;
        return this;
    }

    public KafkaSystemDescriptor withProducerConfigs(Map<String, String> producerConfigs) {
        this.producerConfigs = producerConfigs;
        return this;
    }

    public Map<String, String> toConfig() {
        HashMap<String, String> configs = new HashMap<String, String>(super.toConfig());
        if (!this.consumerZkConnect.isEmpty()) {
            configs.put(String.format(CONSUMER_ZK_CONNECT_CONFIG_KEY, this.getSystemName()), String.join((CharSequence)",", this.consumerZkConnect));
        }
        this.consumerAutoOffsetResetOptional.ifPresent(consumerAutoOffsetReset -> configs.put(String.format(CONSUMER_AUTO_OFFSET_RESET_CONFIG_KEY, this.getSystemName()), (String)consumerAutoOffsetReset));
        this.consumerFetchThresholdOptional.ifPresent(consumerFetchThreshold -> configs.put(String.format(CONSUMER_FETCH_THRESHOLD_CONFIG_KEY, this.getSystemName()), Integer.toString(consumerFetchThreshold)));
        this.consumerFetchThresholdBytesOptional.ifPresent(consumerFetchThresholdBytes -> configs.put(String.format(CONSUMER_FETCH_THRESHOLD_BYTES_CONFIG_KEY, this.getSystemName()), Long.toString(consumerFetchThresholdBytes)));
        this.consumerFetchMessageMaxBytesOptional.ifPresent(consumerFetchMessageMaxBytes -> configs.put(String.format(CONSUMER_FETCH_MESSAGE_MAX_BYTES_KEY, this.getSystemName()), Long.toString(consumerFetchMessageMaxBytes)));
        this.consumerConfigs.forEach((key, value) -> configs.put(String.format(CONSUMER_CONFIGS_CONFIG_KEY, this.getSystemName(), key), (String)value));
        if (!this.producerBootstrapServers.isEmpty()) {
            configs.put(String.format(PRODUCER_BOOTSTRAP_SERVERS_CONFIG_KEY, this.getSystemName()), String.join((CharSequence)",", this.producerBootstrapServers));
        }
        this.producerConfigs.forEach((key, value) -> configs.put(String.format(PRODUCER_CONFIGS_CONFIG_KEY, this.getSystemName(), key), (String)value));
        return configs;
    }
}

