/*
 * Decompiled with CFR 0.152.
 */
package org.apache.samza.system.kafka.descriptors;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.apache.samza.serializers.Serde;
import org.apache.samza.system.descriptors.InputDescriptor;
import org.apache.samza.system.descriptors.InputTransformer;
import org.apache.samza.system.descriptors.SystemDescriptor;

public class KafkaInputDescriptor<StreamMessageType>
extends InputDescriptor<StreamMessageType, KafkaInputDescriptor<StreamMessageType>> {
    private static final String CONSUMER_AUTO_OFFSET_RESET_CONFIG_KEY = "systems.%s.streams.%s.consumer.auto.offset.reset";
    private static final String CONSUMER_FETCH_MESSAGE_MAX_BYTES_CONFIG_KEY = "systems.%s.streams.%s.consumer.fetch.message.max.bytes";
    private Optional<String> consumerAutoOffsetResetOptional = Optional.empty();
    private Optional<Long> consumerFetchMessageMaxBytesOptional = Optional.empty();

    KafkaInputDescriptor(String streamId, SystemDescriptor systemDescriptor, Serde serde, InputTransformer transformer) {
        super(streamId, serde, systemDescriptor, transformer);
    }

    public KafkaInputDescriptor<StreamMessageType> withConsumerAutoOffsetReset(String consumerAutoOffsetReset) {
        this.consumerAutoOffsetResetOptional = Optional.of(StringUtils.stripToNull((String)consumerAutoOffsetReset));
        return this;
    }

    public KafkaInputDescriptor<StreamMessageType> withConsumerFetchMessageMaxBytes(long fetchMessageMaxBytes) {
        this.consumerFetchMessageMaxBytesOptional = Optional.of(fetchMessageMaxBytes);
        return this;
    }

    public Map<String, String> toConfig() {
        HashMap<String, String> configs = new HashMap<String, String>(super.toConfig());
        String streamName = this.getPhysicalName().orElse(this.getStreamId());
        String systemName = this.getSystemName();
        this.consumerAutoOffsetResetOptional.ifPresent(autoOffsetReset -> configs.put(String.format(CONSUMER_AUTO_OFFSET_RESET_CONFIG_KEY, systemName, streamName), (String)autoOffsetReset));
        this.consumerFetchMessageMaxBytesOptional.ifPresent(fetchMessageMaxBytes -> configs.put(String.format(CONSUMER_FETCH_MESSAGE_MAX_BYTES_CONFIG_KEY, systemName, streamName), Long.toString(fetchMessageMaxBytes)));
        return configs;
    }
}

