/*
 * Decompiled with CFR 0.152.
 */
package org.apache.samza.system.kafka;

import com.google.common.annotations.VisibleForTesting;
import java.util.Map;
import java.util.Properties;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.Producer;
import org.apache.samza.config.ApplicationConfig;
import org.apache.samza.config.Config;
import org.apache.samza.config.KafkaConfig$;
import org.apache.samza.config.KafkaConsumerConfig;
import org.apache.samza.config.KafkaProducerConfig;
import org.apache.samza.config.StreamConfig;
import org.apache.samza.config.TaskConfig$;
import org.apache.samza.metrics.MetricsRegistry;
import org.apache.samza.system.SystemAdmin;
import org.apache.samza.system.SystemConsumer;
import org.apache.samza.system.SystemFactory;
import org.apache.samza.system.SystemProducer;
import org.apache.samza.system.kafka.KafkaSystemAdmin;
import org.apache.samza.system.kafka.KafkaSystemConsumer;
import org.apache.samza.system.kafka.KafkaSystemConsumerMetrics;
import org.apache.samza.system.kafka.KafkaSystemFactory$;
import org.apache.samza.system.kafka.KafkaSystemProducer;
import org.apache.samza.system.kafka.KafkaSystemProducer$;
import org.apache.samza.system.kafka.KafkaSystemProducerMetrics;
import org.apache.samza.util.Clock;
import org.apache.samza.util.ExponentialSleepStrategy;
import org.apache.samza.util.ExponentialSleepStrategy$;
import org.apache.samza.util.Logging;
import org.apache.samza.util.SystemClock;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Iterable$;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005Mr!B\u0001\u0003\u0011\u0003i\u0011AE&bM.\f7+_:uK64\u0015m\u0019;pefT!a\u0001\u0003\u0002\u000b-\fgm[1\u000b\u0005\u00151\u0011AB:zgR,WN\u0003\u0002\b\u0011\u0005)1/Y7{C*\u0011\u0011BC\u0001\u0007CB\f7\r[3\u000b\u0003-\t1a\u001c:h\u0007\u0001\u0001\"AD\b\u000e\u0003\t1Q\u0001\u0005\u0002\t\u0002E\u0011!cS1gW\u0006\u001c\u0016p\u001d;f[\u001a\u000b7\r^8ssN\u0019qB\u0005\r\u0011\u0005M1R\"\u0001\u000b\u000b\u0003U\tQa]2bY\u0006L!a\u0006\u000b\u0003\r\u0005s\u0017PU3g!\tIB$D\u0001\u001b\u0015\tYb!\u0001\u0003vi&d\u0017BA\u000f\u001b\u0005\u001daunZ4j]\u001eDQaH\b\u0005\u0002\u0001\na\u0001P5oSRtD#A\u0007\t\u000b\tzA\u0011A\u0012\u0002;\u001d,G/\u00138kK\u000e$X\r\u001a)s_\u0012,8-\u001a:Qe>\u0004XM\u001d;jKN$2\u0001J\u001a6!\u0011)#\u0006\f\u0017\u000e\u0003\u0019R!a\n\u0015\u0002\u0013%lW.\u001e;bE2,'BA\u0015\u0015\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0003W\u0019\u00121!T1q!\ti\u0003G\u0004\u0002\u0014]%\u0011q\u0006F\u0001\u0007!J,G-\u001a4\n\u0005E\u0012$AB*ue&twM\u0003\u00020)!)A'\ta\u0001Y\u0005Q1/_:uK6t\u0015-\\3\t\u000bY\n\u0003\u0019A\u001c\u0002\r\r|gNZ5h!\tA$(D\u0001:\u0015\t1d!\u0003\u0002<s\t11i\u001c8gS\u001eD#!I\u001f\u0011\u0005y:U\"A \u000b\u0005\u0001\u000b\u0015aC1o]>$\u0018\r^5p]NT!AQ\"\u0002\r\r|W.\\8o\u0015\t!U)\u0001\u0004h_><G.\u001a\u0006\u0002\r\u0006\u00191m\\7\n\u0005!{$!\u0005,jg&\u0014G.\u001a$peR+7\u000f^5oO\"9!j\u0004b\u0001\n\u0003Y\u0015\u0001G\"M\u0013\u0016sE+\u0013#`!J{E)V\"F%~\u0003&+\u0012$J1V\tA\n\u0005\u0002N%6\taJ\u0003\u0002P!\u0006!A.\u00198h\u0015\u0005\t\u0016\u0001\u00026bm\u0006L!!\r(\t\rQ{\u0001\u0015!\u0003M\u0003e\u0019E*S#O)&#u\f\u0015*P\tV\u001bUIU0Q%\u00163\u0015\n\u0017\u0011\t\u000fY{!\u0019!C\u0001\u0017\u0006A2\tT%F\u001dRKEiX\"P\u001dN+V*\u0012*`!J+e)\u0013-\t\ra{\u0001\u0015!\u0003M\u0003e\u0019E*S#O)&#ulQ(O'VkUIU0Q%\u00163\u0015\n\u0017\u0011\t\u000fi{!\u0019!C\u0001\u0017\u0006)2\tT%F\u001dRKEiX!E\u001b&su\f\u0015*F\r&C\u0006B\u0002/\u0010A\u0003%A*\u0001\fD\u0019&+e\nV%E?\u0006#U*\u0013(`!J+e)\u0013-!\r\u0011\u0001\"\u0001\u00010\u0014\tu{&\r\u0007\t\u0003\u001b\u0002L!!\u0019(\u0003\r=\u0013'.Z2u!\t\u0019G-D\u0001\u0005\u0013\t)GAA\u0007TsN$X-\u001c$bGR|'/\u001f\u0005\u0006?u#\ta\u001a\u000b\u0002QB\u0011a\"\u0018\u0005\u0006Uv#\ta[\u0001\fO\u0016$8i\u001c8tk6,'\u000f\u0006\u0003m_B\f\bCA2n\u0013\tqGA\u0001\bTsN$X-\\\"p]N,X.\u001a:\t\u000bQJ\u0007\u0019\u0001\u0017\t\u000bYJ\u0007\u0019A\u001c\t\u000bIL\u0007\u0019A:\u0002\u0011I,w-[:uef\u0004\"\u0001^<\u000e\u0003UT!A\u001e\u0004\u0002\u000f5,GO]5dg&\u0011\u00010\u001e\u0002\u0010\u001b\u0016$(/[2t%\u0016<\u0017n\u001d;ss\")!0\u0018C\u0001w\u0006Yq-\u001a;Qe>$WoY3s)\u0019ax0!\u0001\u0002\u0004A\u00111-`\u0005\u0003}\u0012\u0011abU=ti\u0016l\u0007K]8ek\u000e,'\u000fC\u00035s\u0002\u0007A\u0006C\u00037s\u0002\u0007q\u0007C\u0003ss\u0002\u00071\u000fC\u0004\u0002\bu#\t!!\u0003\u0002\u0011\u001d,G/\u00113nS:$b!a\u0003\u0002\u0012\u0005M\u0001cA2\u0002\u000e%\u0019\u0011q\u0002\u0003\u0003\u0017MK8\u000f^3n\u0003\u0012l\u0017N\u001c\u0005\u0007i\u0005\u0015\u0001\u0019\u0001\u0017\t\rY\n)\u00011\u00018\u0011\u001d\t9\"\u0018C\u0001\u00033\tQdZ3u\u0007>|'\u000fZ5oCR|'\u000fV8qS\u000e\u0004&o\u001c9feRLWm\u001d\u000b\u0005\u00037\t)\u0003\u0005\u0003\u0002\u001e\u0005\u0005RBAA\u0010\u0015\tY\u0002+\u0003\u0003\u0002$\u0005}!A\u0003)s_B,'\u000f^5fg\"1a'!\u0006A\u0002]Bq!!\u000b^\t\u0003\tY#A\u0010hKRLe\u000e^3s[\u0016$\u0017.\u0019;f'R\u0014X-Y7Qe>\u0004XM\u001d;jKN$B!!\f\u00022A1Q&a\f-\u00037I!a\u000b\u001a\t\rY\n9\u00031\u00018\u0001")
public class KafkaSystemFactory
implements SystemFactory,
Logging {
    private final String loggerName;
    private final Logger logger;
    private final String startupLoggerName;
    private final Logger startupLogger;
    private volatile byte bitmap$0;

    public static String CLIENTID_ADMIN_PREFIX() {
        return KafkaSystemFactory$.MODULE$.CLIENTID_ADMIN_PREFIX();
    }

    public static String CLIENTID_CONSUMER_PREFIX() {
        return KafkaSystemFactory$.MODULE$.CLIENTID_CONSUMER_PREFIX();
    }

    public static String CLIENTID_PRODUCER_PREFIX() {
        return KafkaSystemFactory$.MODULE$.CLIENTID_PRODUCER_PREFIX();
    }

    @VisibleForTesting
    public static scala.collection.immutable.Map<String, String> getInjectedProducerProperties(String string, Config config) {
        return KafkaSystemFactory$.MODULE$.getInjectedProducerProperties(string, config);
    }

    public String loggerName() {
        return this.loggerName;
    }

    private Logger logger$lzycompute() {
        KafkaSystemFactory kafkaSystemFactory = this;
        synchronized (kafkaSystemFactory) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.logger = Logging.class.logger((Logging)this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.logger$lzycompute() : this.logger;
    }

    public String startupLoggerName() {
        return this.startupLoggerName;
    }

    private Logger startupLogger$lzycompute() {
        KafkaSystemFactory kafkaSystemFactory = this;
        synchronized (kafkaSystemFactory) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.startupLogger = Logging.class.startupLogger((Logging)this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
            return this.startupLogger;
        }
    }

    public Logger startupLogger() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.startupLogger$lzycompute() : this.startupLogger;
    }

    public void org$apache$samza$util$Logging$_setter_$loggerName_$eq(String x$1) {
        this.loggerName = x$1;
    }

    public void org$apache$samza$util$Logging$_setter_$startupLoggerName_$eq(String x$1) {
        this.startupLoggerName = x$1;
    }

    public void startupLog(Function0<Object> message) {
        Logging.class.startupLog((Logging)this, message);
    }

    public void trace(Function0<Object> message) {
        Logging.class.trace((Logging)this, message);
    }

    public void trace(Function0<Object> message, Function0<Throwable> e) {
        Logging.class.trace((Logging)this, message, e);
    }

    public void debug(Function0<Object> message) {
        Logging.class.debug((Logging)this, message);
    }

    public void debug(Function0<Object> message, Function0<Throwable> e) {
        Logging.class.debug((Logging)this, message, e);
    }

    public void info(Function0<Object> message) {
        Logging.class.info((Logging)this, message);
    }

    public void info(Function0<Object> message, Function0<Throwable> e) {
        Logging.class.info((Logging)this, message, e);
    }

    public void warn(Function0<Object> message) {
        Logging.class.warn((Logging)this, message);
    }

    public void warn(Function0<Object> message, Function0<Throwable> e) {
        Logging.class.warn((Logging)this, message, e);
    }

    public void error(Function0<Object> message) {
        Logging.class.error((Logging)this, message);
    }

    public void error(Function0<Object> message, Function0<Throwable> e) {
        Logging.class.error((Logging)this, message, e);
    }

    public void putMDC(Function0<String> key, Function0<String> value) {
        Logging.class.putMDC((Logging)this, key, value);
    }

    public String getMDC(Function0<String> key) {
        return Logging.class.getMDC((Logging)this, key);
    }

    public void removeMDC(Function0<String> key) {
        Logging.class.removeMDC((Logging)this, key);
    }

    public void clearMDC() {
        Logging.class.clearMDC((Logging)this);
    }

    public SystemConsumer getConsumer(String systemName, Config config, MetricsRegistry registry) {
        KafkaSystemConsumerMetrics metrics = new KafkaSystemConsumerMetrics(systemName, registry);
        String clientId = KafkaConsumerConfig.createClientId(KafkaSystemFactory$.MODULE$.CLIENTID_CONSUMER_PREFIX(), config);
        KafkaConsumerConfig kafkaConsumerConfig = KafkaConsumerConfig.getKafkaSystemConsumerConfig(config, systemName, clientId);
        KafkaConsumer kafkaConsumer = KafkaSystemConsumer.createKafkaConsumerImpl(systemName, kafkaConsumerConfig);
        this.info((Function0<Object>)new Serializable(this, systemName, clientId, kafkaConsumer){
            public static final long serialVersionUID = 0L;
            private final String systemName$2;
            private final String clientId$1;
            private final KafkaConsumer kafkaConsumer$1;

            public final String apply() {
                return new StringOps(Predef$.MODULE$.augmentString("Created kafka consumer for system %s, clientId %s: %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.systemName$2, this.clientId$1, this.kafkaConsumer$1}));
            }
            {
                this.systemName$2 = systemName$2;
                this.clientId$1 = clientId$1;
                this.kafkaConsumer$1 = kafkaConsumer$1;
            }
        });
        KafkaSystemConsumer kafkaSystemConsumer = new KafkaSystemConsumer(kafkaConsumer, systemName, config, clientId, metrics, (Clock)new SystemClock());
        this.info((Function0<Object>)new Serializable(this, systemName, config, kafkaSystemConsumer){
            public static final long serialVersionUID = 0L;
            private final String systemName$2;
            private final Config config$1;
            private final KafkaSystemConsumer kafkaSystemConsumer$1;

            public final String apply() {
                return new StringOps(Predef$.MODULE$.augmentString("Created samza system consumer for system %s, config %s: %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.systemName$2, this.config$1, this.kafkaSystemConsumer$1}));
            }
            {
                this.systemName$2 = systemName$2;
                this.config$1 = config$1;
                this.kafkaSystemConsumer$1 = kafkaSystemConsumer$1;
            }
        });
        return kafkaSystemConsumer;
    }

    public SystemProducer getProducer(String systemName, Config config, MetricsRegistry registry) {
        scala.collection.immutable.Map<String, String> injectedProps = KafkaSystemFactory$.MODULE$.getInjectedProducerProperties(systemName, config);
        String clientId = KafkaConsumerConfig.createClientId(KafkaSystemFactory$.MODULE$.CLIENTID_PRODUCER_PREFIX(), config);
        KafkaProducerConfig producerConfig = KafkaConfig$.MODULE$.Config2Kafka(config).getKafkaSystemProducerConfig(systemName, clientId, injectedProps);
        Serializable getProducer2 = new Serializable(this, producerConfig){
            public static final long serialVersionUID = 0L;
            private final KafkaProducerConfig producerConfig$1;

            public final KafkaProducer<byte[], byte[]> apply() {
                return new KafkaProducer(this.producerConfig$1.getProducerProperties());
            }
            {
                this.producerConfig$1 = producerConfig$1;
            }
        };
        KafkaSystemProducerMetrics metrics = new KafkaSystemProducerMetrics(systemName, registry);
        this.info((Function0<Object>)new Serializable(this, systemName, clientId){
            public static final long serialVersionUID = 0L;
            private final String systemName$3;
            private final String clientId$2;

            public final String apply() {
                return new StringOps(Predef$.MODULE$.augmentString("Creating kafka producer for system %s, producerClientId %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.systemName$3, this.clientId$2}));
            }
            {
                this.systemName$3 = systemName$3;
                this.clientId$2 = clientId$2;
            }
        });
        String x$6 = systemName;
        long x$3 = producerConfig.reconnectIntervalMs();
        double x$4 = ExponentialSleepStrategy$.MODULE$.$lessinit$greater$default$1();
        long x$5 = ExponentialSleepStrategy$.MODULE$.$lessinit$greater$default$3();
        ExponentialSleepStrategy x$7 = new ExponentialSleepStrategy(x$4, x$3, x$5);
        Serializable x$8 = getProducer2;
        KafkaSystemProducerMetrics x$9 = metrics;
        boolean x$10 = TaskConfig$.MODULE$.Config2Task(config).getDropProducerError();
        Function0<Object> x$11 = KafkaSystemProducer$.MODULE$.$lessinit$greater$default$5();
        return new KafkaSystemProducer(x$6, x$7, (Function0<Producer<byte[], byte[]>>)x$8, x$9, x$11, x$10);
    }

    public SystemAdmin getAdmin(String systemName, Config config) {
        String clientId = KafkaConsumerConfig.createClientId(KafkaSystemFactory$.MODULE$.CLIENTID_ADMIN_PREFIX(), config);
        KafkaConsumerConfig consumerConfig = KafkaConsumerConfig.getKafkaSystemConsumerConfig(config, systemName, clientId);
        return new KafkaSystemAdmin(systemName, config, (Consumer)KafkaSystemConsumer.createKafkaConsumerImpl(systemName, consumerConfig));
    }

    public Properties getCoordinatorTopicProperties(Config config) {
        String segmentBytes = KafkaConfig$.MODULE$.Config2Kafka(config).getCoordinatorSegmentBytes();
        Properties properties = new Properties();
        return (Properties)((TraversableOnce)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"cleanup.policy"), (Object)"compact"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"segment.bytes"), (Object)segmentBytes)}))).$div$colon((Object)properties, (Function2)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Properties apply(Properties x0$1, Tuple2<String, String> x1$1) {
                Tuple2 tuple2 = new Tuple2((Object)x0$1, x1$1);
                if (tuple2 != null) {
                    Properties props = (Properties)tuple2._1();
                    Tuple2 tuple22 = (Tuple2)tuple2._2();
                    if (tuple22 != null) {
                        String k = (String)tuple22._1();
                        String v = (String)tuple22._2();
                        props.put(k, v);
                        Properties properties = props;
                        return properties;
                    }
                }
                throw new MatchError((Object)tuple2);
            }
        });
    }

    public scala.collection.immutable.Map<String, Properties> getIntermediateStreamProperties(Config config) {
        scala.collection.immutable.Map map;
        ApplicationConfig appConfig = new ApplicationConfig(config);
        ApplicationConfig.ApplicationMode applicationMode = appConfig.getAppMode();
        ApplicationConfig.ApplicationMode applicationMode2 = ApplicationConfig.ApplicationMode.BATCH;
        if (!(applicationMode != null ? !applicationMode.equals(applicationMode2) : applicationMode2 != null)) {
            StreamConfig streamConfig = new StreamConfig(config);
            map = ((TraversableOnce)((TraversableLike)streamConfig.getStreamIds().filter((Function1)new Serializable(this, streamConfig){
                public static final long serialVersionUID = 0L;
                private final StreamConfig streamConfig$1;

                public final boolean apply(String x$2) {
                    return this.streamConfig$1.getIsIntermediateStream(x$2);
                }
                {
                    this.streamConfig$1 = streamConfig$1;
                }
            })).map((Function1)new Serializable(this, streamConfig){
                public static final long serialVersionUID = 0L;
                private final StreamConfig streamConfig$1;

                public final Tuple2<String, Properties> apply(String streamId) {
                    Properties properties = new Properties();
                    properties.putAll((Map<?, ?>)this.streamConfig$1.getStreamProperties(streamId));
                    properties.putIfAbsent("retention.ms", String.valueOf(KafkaConfig$.MODULE$.DEFAULT_RETENTION_MS_FOR_BATCH()));
                    return new Tuple2((Object)streamId, (Object)properties);
                }
                {
                    this.streamConfig$1 = streamConfig$1;
                }
            }, Iterable$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        } else {
            map = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$);
        }
        return map;
    }

    public KafkaSystemFactory() {
        Logging.class.$init$((Logging)this);
    }
}

