/*
 * Decompiled with CFR 0.152.
 */
package org.apache.samza.system.kafka;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import kafka.common.TopicAndPartition;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.common.TopicPartition;
import org.apache.samza.SamzaException;
import org.apache.samza.config.Config;
import org.apache.samza.config.KafkaConfig;
import org.apache.samza.system.IncomingMessageEnvelope;
import org.apache.samza.system.SystemConsumer;
import org.apache.samza.system.SystemStreamPartition;
import org.apache.samza.system.kafka.KafkaConsumerProxy;
import org.apache.samza.system.kafka.KafkaSystemConsumerMetrics;
import org.apache.samza.util.BlockingEnvelopeMap;
import org.apache.samza.util.Clock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Option;

public class KafkaSystemConsumer<K, V>
extends BlockingEnvelopeMap
implements SystemConsumer {
    private static final Logger LOG = LoggerFactory.getLogger(KafkaSystemConsumer.class);
    private static final long FETCH_THRESHOLD = 50000L;
    private static final long FETCH_THRESHOLD_BYTES = -1L;
    protected final Consumer<K, V> kafkaConsumer;
    protected final String systemName;
    protected final String clientId;
    private final AtomicBoolean stopped = new AtomicBoolean(false);
    private final AtomicBoolean started = new AtomicBoolean(false);
    private final Config config;
    private final boolean fetchThresholdBytesEnabled;
    private final KafkaSystemConsumerMetrics metrics;
    final KafkaConsumerMessageSink messageSink;
    private final KafkaConsumerProxy proxy;
    final Map<TopicPartition, String> topicPartitionsToOffset = new HashMap<TopicPartition, String>();
    final Map<TopicPartition, SystemStreamPartition> topicPartitionsToSSP = new HashMap<TopicPartition, SystemStreamPartition>();
    long perPartitionFetchThreshold;
    long perPartitionFetchThresholdBytes;

    public KafkaSystemConsumer(Consumer<K, V> kafkaConsumer, String systemName, Config config, String clientId, KafkaSystemConsumerMetrics metrics, Clock clock) {
        super(metrics.registry(), clock, metrics.getClass().getName());
        this.kafkaConsumer = kafkaConsumer;
        this.clientId = clientId;
        this.systemName = systemName;
        this.config = config;
        this.metrics = metrics;
        this.fetchThresholdBytesEnabled = new KafkaConfig(config).isConsumerFetchThresholdBytesEnabled(systemName);
        this.messageSink = new KafkaConsumerMessageSink();
        String metricName = String.format("%s-%s", systemName, clientId);
        this.proxy = new KafkaConsumerProxy<K, V>(kafkaConsumer, systemName, clientId, this.messageSink, metrics, metricName);
        LOG.info("{}: Created KafkaConsumerProxy {} ", (Object)this, (Object)this.proxy);
    }

    public static <K, V> KafkaConsumer<K, V> createKafkaConsumerImpl(String systemName, HashMap<String, Object> kafkaConsumerConfig) {
        LOG.info("Instantiating KafkaConsumer for systemName {} with properties {}", (Object)systemName, kafkaConsumerConfig);
        return new KafkaConsumer(kafkaConsumerConfig);
    }

    public void start() {
        if (!this.started.compareAndSet(false, true)) {
            LOG.warn("{}: Attempting to start the consumer for the second (or more) time.", (Object)this);
            return;
        }
        if (this.stopped.get()) {
            LOG.error("{}: Attempting to start a stopped consumer", (Object)this);
            return;
        }
        this.startSubscription();
        this.setFetchThresholds();
        this.startConsumer();
        LOG.info("{}: Consumer started", (Object)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startSubscription() {
        LOG.info("{}: Consumer subscribes to {}", (Object)this, this.topicPartitionsToSSP.keySet());
        try {
            Consumer<K, V> consumer = this.kafkaConsumer;
            synchronized (consumer) {
                this.kafkaConsumer.assign(this.topicPartitionsToSSP.keySet());
            }
        }
        catch (Exception e) {
            throw new SamzaException("Consumer subscription failed for " + (Object)((Object)this), (Throwable)e);
        }
    }

    void startConsumer() {
        if (this.topicPartitionsToOffset.size() <= 0) {
            LOG.error("{}: Consumer is not subscribed to any SSPs", (Object)this);
        }
        this.topicPartitionsToOffset.forEach((tp, startingOffsetString) -> {
            long startingOffset = Long.valueOf(startingOffsetString);
            try {
                Consumer<K, V> consumer = this.kafkaConsumer;
                synchronized (consumer) {
                    this.kafkaConsumer.seek(tp, startingOffset);
                }
            }
            catch (Exception e) {
                String msg = String.format("%s: Got Exception while seeking to %s for partition %s", new Object[]{this, startingOffsetString, tp});
                LOG.error(msg, (Throwable)e);
                throw new SamzaException(msg, (Throwable)e);
            }
            LOG.info("{}: Changing consumer's starting offset for tp = {} to {}", new Object[]{this, tp, startingOffsetString});
            this.proxy.addTopicPartition(this.topicPartitionsToSSP.get(tp), startingOffset);
        });
        if (this.proxy != null && !this.proxy.isRunning()) {
            LOG.info("{}: Starting proxy {}", (Object)this, (Object)this.proxy);
            this.proxy.start();
        }
    }

    private void setFetchThresholds() {
        int numPartitions;
        KafkaConfig kafkaConfig = new KafkaConfig(this.config);
        Option<String> fetchThresholdOption = kafkaConfig.getConsumerFetchThreshold(this.systemName);
        long fetchThreshold = 50000L;
        if (fetchThresholdOption.isDefined()) {
            fetchThreshold = Long.valueOf((String)fetchThresholdOption.get());
        }
        Option<String> fetchThresholdBytesOption = kafkaConfig.getConsumerFetchThresholdBytes(this.systemName);
        long fetchThresholdBytes = -1L;
        if (fetchThresholdBytesOption.isDefined()) {
            fetchThresholdBytes = Long.valueOf((String)fetchThresholdBytesOption.get());
        }
        if ((numPartitions = this.topicPartitionsToSSP.size()) != this.topicPartitionsToOffset.size()) {
            throw new SamzaException("topicPartitionsToSSP.size() doesn't match topicPartitionsToOffset.size()");
        }
        if (numPartitions > 0) {
            this.perPartitionFetchThreshold = fetchThreshold / (long)numPartitions;
            if (this.fetchThresholdBytesEnabled) {
                this.perPartitionFetchThresholdBytes = fetchThresholdBytes / 2L / (long)numPartitions;
            }
        }
        LOG.info("{}: fetchThresholdBytes = {}; fetchThreshold={}; numPartitions={}, perPartitionFetchThreshold={}, perPartitionFetchThresholdBytes(0 if disabled)={}", new Object[]{this, fetchThresholdBytes, fetchThreshold, numPartitions, this.perPartitionFetchThreshold, this.perPartitionFetchThresholdBytes});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        if (!this.stopped.compareAndSet(false, true)) {
            LOG.warn("{}: Attempting to stop stopped consumer.", (Object)this);
            return;
        }
        LOG.info("{}: Stopping Samza kafkaConsumer ", (Object)this);
        if (this.proxy != null) {
            LOG.info("{}: Stopping proxy {}", (Object)this, (Object)this.proxy);
            this.proxy.stop(TimeUnit.SECONDS.toMillis(60L));
        }
        try {
            Consumer<K, V> consumer = this.kafkaConsumer;
            synchronized (consumer) {
                LOG.info("{}: Closing kafkaSystemConsumer {}", (Object)this, this.kafkaConsumer);
                this.kafkaConsumer.close();
            }
        }
        catch (Exception e) {
            LOG.warn("{}: Failed to stop KafkaSystemConsumer.", (Object)this, (Object)e);
        }
    }

    public void register(SystemStreamPartition systemStreamPartition, String offset) {
        if (this.started.get()) {
            String msg = String.format("%s: Trying to register partition after consumer has been started. ssp=%s", new Object[]{this, systemStreamPartition});
            throw new SamzaException(msg);
        }
        if (!systemStreamPartition.getSystem().equals(this.systemName)) {
            LOG.warn("{}: ignoring SSP {}, because this consumer's system doesn't match.", (Object)this, (Object)systemStreamPartition);
            return;
        }
        LOG.info("{}: Registering ssp = {} with offset {}", new Object[]{this, systemStreamPartition, offset});
        super.register(systemStreamPartition, offset);
        TopicPartition tp = KafkaSystemConsumer.toTopicPartition(systemStreamPartition);
        this.topicPartitionsToSSP.put(tp, systemStreamPartition);
        String existingOffset = this.topicPartitionsToOffset.get(tp);
        if (existingOffset == null || KafkaSystemConsumer.compareOffsets(existingOffset, offset) > 0) {
            this.topicPartitionsToOffset.put(tp, offset);
        }
        this.metrics.registerTopicAndPartition(KafkaSystemConsumer.toTopicAndPartition(tp));
    }

    private static int compareOffsets(String offset1, String offset2) {
        return Long.valueOf(offset1).compareTo(Long.valueOf(offset2));
    }

    public String toString() {
        return String.format("%s:%s", this.systemName, this.clientId);
    }

    public Map<SystemStreamPartition, List<IncomingMessageEnvelope>> poll(Set<SystemStreamPartition> systemStreamPartitions, long timeout) throws InterruptedException {
        if (!this.proxy.isRunning()) {
            this.stop();
            String message = String.format("%s: KafkaConsumerProxy has stopped.", new Object[]{this});
            throw new SamzaException(message, this.proxy.getFailureCause());
        }
        return super.poll(systemStreamPartitions, timeout);
    }

    public static TopicAndPartition toTopicAndPartition(TopicPartition tp) {
        return new TopicAndPartition(tp.topic(), tp.partition());
    }

    public static TopicPartition toTopicPartition(SystemStreamPartition ssp) {
        return new TopicPartition(ssp.getStream(), ssp.getPartition().getPartitionId());
    }

    public String getSystemName() {
        return this.systemName;
    }

    public class KafkaConsumerMessageSink {
        public void setIsAtHighWatermark(SystemStreamPartition ssp, boolean isAtHighWatermark) {
            KafkaSystemConsumer.this.setIsAtHead(ssp, isAtHighWatermark);
        }

        boolean needsMoreMessages(SystemStreamPartition ssp) {
            LOG.debug("{}: needsMoreMessages from following SSP: {}. fetchLimitByBytes enabled={}; messagesSizeInQueue={};(limit={}); messagesNumInQueue={}(limit={};", new Object[]{this, ssp, KafkaSystemConsumer.this.fetchThresholdBytesEnabled, KafkaSystemConsumer.this.getMessagesSizeInQueue(ssp), KafkaSystemConsumer.this.perPartitionFetchThresholdBytes, KafkaSystemConsumer.this.getNumMessagesInQueue(ssp), KafkaSystemConsumer.this.perPartitionFetchThreshold});
            if (KafkaSystemConsumer.this.fetchThresholdBytesEnabled) {
                return KafkaSystemConsumer.this.getMessagesSizeInQueue(ssp) < KafkaSystemConsumer.this.perPartitionFetchThresholdBytes;
            }
            return (long)KafkaSystemConsumer.this.getNumMessagesInQueue(ssp) < KafkaSystemConsumer.this.perPartitionFetchThreshold;
        }

        void addMessage(SystemStreamPartition ssp, IncomingMessageEnvelope envelope) {
            LOG.trace("{}: Incoming message ssp = {}: envelope = {}.", new Object[]{this, ssp, envelope});
            try {
                KafkaSystemConsumer.this.put(ssp, envelope);
            }
            catch (InterruptedException e) {
                throw new SamzaException(String.format("%s: Consumer was interrupted while trying to add message with offset %s for ssp %s", this, envelope.getOffset(), ssp));
            }
        }
    }
}

