/*
 * Decompiled with CFR 0.152.
 */
package org.apache.samza.system.kafka;

import java.util.Properties;
import java.util.concurrent.Future;
import java.util.function.Supplier;
import kafka.admin.AdminClient;
import kafka.admin.AdminUtils$;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.utils.ZkUtils;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.TopicExistsException;
import org.apache.log4j.Logger;
import org.apache.samza.Partition;
import org.apache.samza.config.ApplicationConfig;
import org.apache.samza.config.Config;
import org.apache.samza.config.KafkaConfig;
import org.apache.samza.config.KafkaConfig$;
import org.apache.samza.config.StreamConfig;
import org.apache.samza.system.StreamSpec;
import org.apache.samza.system.SystemStreamMetadata;
import org.apache.samza.system.SystemStreamPartition;
import org.apache.samza.system.kafka.KafkaStreamSpec;
import org.apache.samza.system.kafka.KafkaSystemAdminUtilsScala$;
import org.apache.samza.util.ExponentialSleepStrategy;
import org.apache.samza.util.ExponentialSleepStrategy$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable$;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.Set$;
import scala.collection.immutable.StringOps;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.Null$;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public final class KafkaSystemAdminUtilsScala$
implements Logging {
    public static final KafkaSystemAdminUtilsScala$ MODULE$;
    private final int CLEAR_STREAM_RETRIES;
    private final int CREATE_STREAM_RETRIES;
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    private volatile boolean bitmap$0;

    static {
        new KafkaSystemAdminUtilsScala$();
    }

    public String loggerName() {
        return this.loggerName;
    }

    private Logger logger$lzycompute() {
        KafkaSystemAdminUtilsScala$ kafkaSystemAdminUtilsScala$ = this;
        synchronized (kafkaSystemAdminUtilsScala$) {
            if (!this.bitmap$0) {
                this.logger = Logging.class.logger((Logging)this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    public String logIdent() {
        return this.logIdent;
    }

    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    public void kafka$utils$Logging$_setter_$loggerName_$eq(String x$1) {
        this.loggerName = x$1;
    }

    public void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ x$1) {
        this.kafka$utils$Logging$$log4jController = x$1;
    }

    public void trace(Function0<String> msg) {
        Logging.class.trace((Logging)this, msg);
    }

    public Object trace(Function0<Throwable> e) {
        return Logging.class.trace((Logging)this, e);
    }

    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.trace((Logging)this, msg, e);
    }

    public void swallowTrace(Function0<BoxedUnit> action) {
        Logging.class.swallowTrace((Logging)this, action);
    }

    public boolean isDebugEnabled() {
        return Logging.class.isDebugEnabled((Logging)this);
    }

    public void debug(Function0<String> msg) {
        Logging.class.debug((Logging)this, msg);
    }

    public Object debug(Function0<Throwable> e) {
        return Logging.class.debug((Logging)this, e);
    }

    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.debug((Logging)this, msg, e);
    }

    public void swallowDebug(Function0<BoxedUnit> action) {
        Logging.class.swallowDebug((Logging)this, action);
    }

    public void info(Function0<String> msg) {
        Logging.class.info((Logging)this, msg);
    }

    public Object info(Function0<Throwable> e) {
        return Logging.class.info((Logging)this, e);
    }

    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.info((Logging)this, msg, e);
    }

    public void swallowInfo(Function0<BoxedUnit> action) {
        Logging.class.swallowInfo((Logging)this, action);
    }

    public void warn(Function0<String> msg) {
        Logging.class.warn((Logging)this, msg);
    }

    public Object warn(Function0<Throwable> e) {
        return Logging.class.warn((Logging)this, e);
    }

    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.warn((Logging)this, msg, e);
    }

    public void swallowWarn(Function0<BoxedUnit> action) {
        Logging.class.swallowWarn((Logging)this, action);
    }

    public void swallow(Function0<BoxedUnit> action) {
        Logging.class.swallow((Logging)this, action);
    }

    public void error(Function0<String> msg) {
        Logging.class.error((Logging)this, msg);
    }

    public Object error(Function0<Throwable> e) {
        return Logging.class.error((Logging)this, e);
    }

    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.error((Logging)this, msg, e);
    }

    public void swallowError(Function0<BoxedUnit> action) {
        Logging.class.swallowError((Logging)this, action);
    }

    public void fatal(Function0<String> msg) {
        Logging.class.fatal((Logging)this, msg);
    }

    public Object fatal(Function0<Throwable> e) {
        return Logging.class.fatal((Logging)this, e);
    }

    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.fatal((Logging)this, msg, e);
    }

    public int CLEAR_STREAM_RETRIES() {
        return this.CLEAR_STREAM_RETRIES;
    }

    public int CREATE_STREAM_RETRIES() {
        return this.CREATE_STREAM_RETRIES;
    }

    public void clearStream(StreamSpec spec, Supplier<ZkUtils> connectZk) {
        this.info((Function0<String>)new Serializable(spec){
            public static final long serialVersionUID = 0L;
            private final StreamSpec spec$1;

            public final String apply() {
                return new StringOps(Predef$.MODULE$.augmentString("Deleting topic %s for system %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.spec$1.getPhysicalName(), this.spec$1.getSystemName()}));
            }
            {
                this.spec$1 = spec$1;
            }
        });
        KafkaStreamSpec kSpec = KafkaStreamSpec.fromSpec(spec);
        IntRef retries = IntRef.create((int)this.CLEAR_STREAM_RETRIES());
        new ExponentialSleepStrategy().run((Function1)new Serializable(connectZk, kSpec){
            public static final long serialVersionUID = 0L;
            private final Supplier connectZk$1;
            private final KafkaStreamSpec kSpec$1;

            /*
             * WARNING - void declaration
             */
            public final void apply(ExponentialSleepStrategy.RetryLoop loop) {
                ZkUtils zkClient = (ZkUtils)this.connectZk$1.get();
                try {
                    AdminUtils$.MODULE$.deleteTopic(zkClient, this.kSpec$1.getPhysicalName());
                }
                catch (Throwable throwable) {
                    void var2_2;
                    var2_2.close();
                    throw throwable;
                }
                zkClient.close();
                loop.done();
            }
            {
                this.connectZk$1 = connectZk$1;
                this.kSpec$1 = kSpec$1;
            }
        }, (Function2)new Serializable(spec, retries){
            public static final long serialVersionUID = 0L;
            public final StreamSpec spec$1;
            private final IntRef retries$1;

            public final void apply(Exception exception, ExponentialSleepStrategy.RetryLoop loop) {
                if (this.retries$1.elem > 0) {
                    KafkaSystemAdminUtilsScala$.MODULE$.warn((Function0<String>)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ anonfun.clearStream.3 $outer;

                        public final String apply() {
                            return new StringOps(Predef$.MODULE$.augmentString("Exception while trying to delete topic %s. Retrying.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.spec$1.getPhysicalName()}));
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                        }
                    }, (Function0<Throwable>)new Serializable(this, exception){
                        public static final long serialVersionUID = 0L;
                        private final Exception exception$1;

                        public final Exception apply() {
                            return this.exception$1;
                        }
                        {
                            this.exception$1 = exception$1;
                        }
                    });
                    --this.retries$1.elem;
                    return;
                }
                KafkaSystemAdminUtilsScala$.MODULE$.warn((Function0<String>)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.clearStream.3 $outer;

                    public final String apply() {
                        return new StringOps(Predef$.MODULE$.augmentString("Fail to delete topic %s.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.spec$1.getPhysicalName()}));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                }, (Function0<Throwable>)new Serializable(this, exception){
                    public static final long serialVersionUID = 0L;
                    private final Exception exception$1;

                    public final Exception apply() {
                        return this.exception$1;
                    }
                    {
                        this.exception$1 = exception$1;
                    }
                });
                loop.done();
                throw exception;
            }
            {
                this.spec$1 = spec$1;
                this.retries$1 = retries$1;
            }
        });
    }

    public boolean createStream(KafkaStreamSpec kSpec, Supplier<ZkUtils> connectZk) {
        this.info((Function0<String>)new Serializable(kSpec){
            public static final long serialVersionUID = 0L;
            private final KafkaStreamSpec kSpec$2;

            public final String apply() {
                return new StringOps(Predef$.MODULE$.augmentString("Creating topic %s for system %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.kSpec$2.getPhysicalName(), this.kSpec$2.getSystemName()}));
            }
            {
                this.kSpec$2 = kSpec$2;
            }
        });
        BooleanRef streamCreated = BooleanRef.create((boolean)false);
        IntRef retries = IntRef.create((int)this.CREATE_STREAM_RETRIES());
        long x$4 = 500L;
        double x$5 = ExponentialSleepStrategy$.MODULE$.$lessinit$greater$default$1();
        long x$6 = ExponentialSleepStrategy$.MODULE$.$lessinit$greater$default$3();
        new ExponentialSleepStrategy(x$5, x$4, x$6).run((Function1)new Serializable(kSpec, connectZk, streamCreated){
            public static final long serialVersionUID = 0L;
            private final KafkaStreamSpec kSpec$2;
            private final Supplier connectZk$2;
            private final BooleanRef streamCreated$1;

            /*
             * WARNING - void declaration
             */
            public final void apply(ExponentialSleepStrategy.RetryLoop loop) {
                ZkUtils zkClient = (ZkUtils)this.connectZk$2.get();
                try {
                    AdminUtils$.MODULE$.createTopic(zkClient, this.kSpec$2.getPhysicalName(), this.kSpec$2.getPartitionCount(), this.kSpec$2.getReplicationFactor(), this.kSpec$2.getProperties(), AdminUtils$.MODULE$.createTopic$default$6());
                }
                catch (Throwable throwable) {
                    void var2_2;
                    var2_2.close();
                    throw throwable;
                }
                zkClient.close();
                this.streamCreated$1.elem = true;
                loop.done();
            }
            {
                this.kSpec$2 = kSpec$2;
                this.connectZk$2 = connectZk$2;
                this.streamCreated$1 = streamCreated$1;
            }
        }, (Function2)new Serializable(kSpec, streamCreated, retries){
            public static final long serialVersionUID = 0L;
            public final KafkaStreamSpec kSpec$2;
            private final BooleanRef streamCreated$1;
            private final IntRef retries$2;

            public final void apply(Exception exception, ExponentialSleepStrategy.RetryLoop loop) {
                Exception exception2;
                block4: {
                    block5: {
                        block3: {
                            block2: {
                                exception2 = exception;
                                if (!(exception2 instanceof TopicExistsException)) break block2;
                                this.streamCreated$1.elem = false;
                                loop.done();
                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                break block3;
                            }
                            if (exception2 == null) break block4;
                            if (this.retries$2.elem <= 0) break block5;
                            KafkaSystemAdminUtilsScala$.MODULE$.warn((Function0<String>)new Serializable(this){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ anonfun.createStream.3 $outer;

                                public final String apply() {
                                    return new StringOps(Predef$.MODULE$.augmentString("Failed to create topic %s. Retrying.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.kSpec$2.getPhysicalName()}));
                                }
                                {
                                    if ($outer == null) {
                                        throw null;
                                    }
                                    this.$outer = $outer;
                                }
                            }, (Function0<Throwable>)new Serializable(this, exception){
                                public static final long serialVersionUID = 0L;
                                private final Exception exception$2;

                                public final Exception apply() {
                                    return this.exception$2;
                                }
                                {
                                    this.exception$2 = exception$2;
                                }
                            });
                            --this.retries$2.elem;
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        }
                        return;
                    }
                    KafkaSystemAdminUtilsScala$.MODULE$.error((Function0<String>)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ anonfun.createStream.3 $outer;

                        public final String apply() {
                            return new StringOps(Predef$.MODULE$.augmentString("Failed to create topic %s. Bailing out.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.kSpec$2.getPhysicalName()}));
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                        }
                    }, (Function0<Throwable>)new Serializable(this, exception){
                        public static final long serialVersionUID = 0L;
                        private final Exception exception$2;

                        public final Exception apply() {
                            return this.exception$2;
                        }
                        {
                            this.exception$2 = exception$2;
                        }
                    });
                    throw exception;
                }
                throw new MatchError((Object)exception2);
            }
            {
                this.kSpec$2 = kSpec$2;
                this.streamCreated$1 = streamCreated$1;
                this.retries$2 = retries$2;
            }
        });
        return streamCreated.elem;
    }

    public scala.collection.immutable.Map<String, SystemStreamMetadata> assembleMetadata(scala.collection.immutable.Map<SystemStreamPartition, String> oldestOffsets, scala.collection.immutable.Map<SystemStreamPartition, String> newestOffsets, scala.collection.immutable.Map<SystemStreamPartition, String> upcomingOffsets) {
        scala.collection.immutable.Map allMetadata = ((scala.collection.immutable.Map)oldestOffsets.keySet().$plus$plus((GenTraversableOnce)newestOffsets.keySet()).$plus$plus((GenTraversableOnce)upcomingOffsets.keySet()).groupBy((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(SystemStreamPartition x$1) {
                return x$1.getStream();
            }
        }).map((Function1)new Serializable(oldestOffsets, newestOffsets, upcomingOffsets){
            public static final long serialVersionUID = 0L;
            public final scala.collection.immutable.Map oldestOffsets$1;
            public final scala.collection.immutable.Map newestOffsets$1;
            public final scala.collection.immutable.Map upcomingOffsets$1;

            public final Tuple2<String, SystemStreamMetadata> apply(Tuple2<String, Set<SystemStreamPartition>> x0$1) {
                Tuple2<String, Set<SystemStreamPartition>> tuple2 = x0$1;
                if (tuple2 != null) {
                    String streamName = (String)tuple2._1();
                    Set systemStreamPartitions = (Set)tuple2._2();
                    scala.collection.immutable.Map streamPartitionMetadata = ((TraversableOnce)systemStreamPartitions.map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ anonfun.2 $outer;

                        public final Tuple2<Partition, SystemStreamMetadata.SystemStreamPartitionMetadata> apply(SystemStreamPartition systemStreamPartition) {
                            SystemStreamMetadata.SystemStreamPartitionMetadata partitionMetadata = new SystemStreamMetadata.SystemStreamPartitionMetadata((String)this.$outer.oldestOffsets$1.getOrElse((Object)systemStreamPartition, (Function0)new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final Null$ apply() {
                                    return null;
                                }
                            }), (String)this.$outer.newestOffsets$1.getOrElse((Object)systemStreamPartition, (Function0)new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final Null$ apply() {
                                    return null;
                                }
                            }), (String)this.$outer.upcomingOffsets$1.apply((Object)systemStreamPartition));
                            return new Tuple2((Object)systemStreamPartition.getPartition(), (Object)partitionMetadata);
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                        }
                    }, Set$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
                    SystemStreamMetadata streamMetadata = new SystemStreamMetadata(streamName, (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)streamPartitionMetadata).asJava());
                    Tuple2 tuple22 = new Tuple2((Object)streamName, (Object)streamMetadata);
                    return tuple22;
                }
                throw new MatchError(tuple2);
            }
            {
                this.oldestOffsets$1 = oldestOffsets$1;
                this.newestOffsets$1 = newestOffsets$1;
                this.upcomingOffsets$1 = upcomingOffsets$1;
            }
        }, Map$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        this.debug((Function0<String>)new Serializable(allMetadata){
            public static final long serialVersionUID = 0L;
            private final scala.collection.immutable.Map allMetadata$1;

            public final String apply() {
                return new StringOps(Predef$.MODULE$.augmentString("Got metadata: %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.allMetadata$1}));
            }
            {
                this.allMetadata$1 = allMetadata$1;
            }
        });
        return allMetadata;
    }

    public Properties getCoordinatorTopicProperties(KafkaConfig config) {
        String segmentBytes = config.getCoordinatorSegmentBytes();
        Properties properties = new Properties();
        return (Properties)((TraversableOnce)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"cleanup.policy"), (Object)"compact"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"segment.bytes"), (Object)segmentBytes)}))).$div$colon((Object)properties, (Function2)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Properties apply(Properties x0$2, Tuple2<String, String> x1$1) {
                Tuple2 tuple2 = new Tuple2((Object)x0$2, x1$1);
                if (tuple2 != null) {
                    Properties props = (Properties)tuple2._1();
                    Tuple2 tuple22 = (Tuple2)tuple2._2();
                    if (tuple22 != null) {
                        String k = (String)tuple22._1();
                        String v = (String)tuple22._2();
                        props.put(k, v);
                        Properties properties = props;
                        return properties;
                    }
                }
                throw new MatchError((Object)tuple2);
            }
        });
    }

    public scala.collection.immutable.Map<String, Properties> getIntermediateStreamProperties(Config config) {
        scala.collection.immutable.Map map;
        ApplicationConfig appConfig = new ApplicationConfig(config);
        ApplicationConfig.ApplicationMode applicationMode = appConfig.getAppMode();
        ApplicationConfig.ApplicationMode applicationMode2 = ApplicationConfig.ApplicationMode.BATCH;
        if (!(applicationMode != null ? !applicationMode.equals(applicationMode2) : applicationMode2 != null)) {
            StreamConfig streamConfig = new StreamConfig(config);
            map = ((TraversableOnce)((TraversableLike)streamConfig.getStreamIds().filter((Function1)new Serializable(streamConfig){
                public static final long serialVersionUID = 0L;
                private final StreamConfig streamConfig$1;

                public final boolean apply(String x$3) {
                    return this.streamConfig$1.getIsIntermediateStream(x$3);
                }
                {
                    this.streamConfig$1 = streamConfig$1;
                }
            })).map((Function1)new Serializable(streamConfig){
                public static final long serialVersionUID = 0L;
                private final StreamConfig streamConfig$1;

                public final Tuple2<String, Properties> apply(String streamId) {
                    Properties properties = new Properties();
                    properties.putAll((java.util.Map<?, ?>)this.streamConfig$1.getStreamProperties(streamId));
                    properties.putIfAbsent("retention.ms", String.valueOf(KafkaConfig$.MODULE$.DEFAULT_RETENTION_MS_FOR_BATCH()));
                    return new Tuple2((Object)streamId, (Object)properties);
                }
                {
                    this.streamConfig$1 = streamConfig$1;
                }
            }, Iterable$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        } else {
            map = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$);
        }
        return map;
    }

    public Future<scala.collection.immutable.Map<TopicPartition, AdminClient.DeleteRecordsResult>> deleteMessages(AdminClient adminClient, java.util.Map<SystemStreamPartition, String> offsets) {
        scala.collection.immutable.Map nextOffsets = ((TraversableOnce)((MapLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(offsets).asScala()).toSeq().map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Tuple2<TopicPartition, Object> apply(Tuple2<SystemStreamPartition, String> x0$3) {
                Tuple2<SystemStreamPartition, String> tuple2 = x0$3;
                if (tuple2 != null) {
                    SystemStreamPartition systemStreamPartition = (SystemStreamPartition)tuple2._1();
                    String offset = (String)tuple2._2();
                    Tuple2 tuple22 = new Tuple2((Object)new TopicPartition(systemStreamPartition.getStream(), systemStreamPartition.getPartition().getPartitionId()), (Object)BoxesRunTime.boxToLong((long)(new StringOps(Predef$.MODULE$.augmentString(offset)).toLong() + 1L)));
                    return tuple22;
                }
                throw new MatchError(tuple2);
            }
        }, Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        return adminClient.deleteRecordsBefore(nextOffsets);
    }

    private KafkaSystemAdminUtilsScala$() {
        MODULE$ = this;
        Logging.class.$init$((Logging)this);
        this.CLEAR_STREAM_RETRIES = 3;
        this.CREATE_STREAM_RETRIES = 10;
    }
}

