/*
 * Decompiled with CFR 0.152.
 */
package org.apache.samza.system.kafka;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import kafka.admin.AdminClient;
import kafka.utils.ZkUtils;
import org.apache.commons.lang3.NotImplementedException;
import org.apache.commons.lang3.StringUtils;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.common.PartitionInfo;
import org.apache.kafka.common.TopicPartition;
import org.apache.samza.Partition;
import org.apache.samza.SamzaException;
import org.apache.samza.config.Config;
import org.apache.samza.config.KafkaConfig;
import org.apache.samza.config.SystemConfig;
import org.apache.samza.system.ExtendedSystemAdmin;
import org.apache.samza.system.StreamSpec;
import org.apache.samza.system.StreamValidationException;
import org.apache.samza.system.SystemStreamMetadata;
import org.apache.samza.system.SystemStreamPartition;
import org.apache.samza.system.kafka.ChangelogInfo;
import org.apache.samza.system.kafka.KafkaStreamSpec;
import org.apache.samza.system.kafka.KafkaSystemAdminUtilsScala;
import org.apache.samza.util.ExponentialSleepStrategy;
import org.apache.samza.util.ScalaJavaUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.collection.JavaConverters;
import scala.runtime.AbstractFunction0;
import scala.runtime.AbstractFunction1;
import scala.runtime.AbstractFunction2;
import scala.runtime.BoxedUnit;

public class KafkaSystemAdmin
implements ExtendedSystemAdmin {
    private static final Logger LOG = LoggerFactory.getLogger(KafkaSystemAdmin.class);
    protected static final double DEFAULT_EXPONENTIAL_SLEEP_BACK_OFF_MULTIPLIER = 2.0;
    protected static final long DEFAULT_EXPONENTIAL_SLEEP_INITIAL_DELAY_MS = 500L;
    protected static final long DEFAULT_EXPONENTIAL_SLEEP_MAX_DELAY_MS = 10000L;
    protected static final int MAX_RETRIES_ON_EXCEPTION = 5;
    protected static final int DEFAULT_REPL_FACTOR = 2;
    @VisibleForTesting
    public static volatile boolean deleteMessageCalled = false;
    protected final String systemName;
    protected final Consumer metadataConsumer;
    protected final Config config;
    protected AdminClient adminClient = null;
    private final Properties coordinatorStreamProperties;
    private final int coordinatorStreamReplicationFactor;
    private final Map<String, ChangelogInfo> changelogTopicMetaInformation;
    private final Map<String, Properties> intermediateStreamProperties;
    protected final boolean deleteCommittedMessages;
    private final AtomicBoolean stopped = new AtomicBoolean(false);

    public KafkaSystemAdmin(String systemName, Config config, Consumer metadataConsumer) {
        this.systemName = systemName;
        this.config = config;
        if (metadataConsumer == null) {
            throw new SamzaException("Cannot construct KafkaSystemAdmin for system " + systemName + " with null metadataConsumer");
        }
        this.metadataConsumer = metadataConsumer;
        KafkaConfig kafkaConfig = new KafkaConfig(config);
        this.coordinatorStreamReplicationFactor = Integer.valueOf(kafkaConfig.getCoordinatorReplicationFactor());
        this.coordinatorStreamProperties = KafkaSystemAdminUtilsScala.getCoordinatorTopicProperties(kafkaConfig);
        Map storeToChangelog = (Map)JavaConverters.mapAsJavaMapConverter(kafkaConfig.getKafkaChangelogEnabledStores()).asJava();
        this.changelogTopicMetaInformation = new HashMap<String, ChangelogInfo>();
        for (Map.Entry e : storeToChangelog.entrySet()) {
            String storeName = (String)e.getKey();
            String topicName = (String)e.getValue();
            String replicationFactorStr = kafkaConfig.getChangelogStreamReplicationFactor(storeName);
            int replicationFactor = StringUtils.isEmpty((CharSequence)replicationFactorStr) ? 2 : Integer.valueOf(replicationFactorStr);
            ChangelogInfo changelogInfo = new ChangelogInfo(replicationFactor, kafkaConfig.getChangelogKafkaProperties(storeName));
            LOG.info(String.format("Creating topic meta information for topic: %s with replication factor: %s", topicName, replicationFactor));
            this.changelogTopicMetaInformation.put(topicName, changelogInfo);
        }
        SystemConfig systemConfig = new SystemConfig(config);
        this.deleteCommittedMessages = systemConfig.deleteCommittedMessages(systemName);
        this.intermediateStreamProperties = (Map)JavaConverters.mapAsJavaMapConverter(KafkaSystemAdminUtilsScala.getIntermediateStreamProperties(config)).asJava();
        LOG.info(String.format("Created KafkaSystemAdmin for system %s", systemName));
    }

    public void start() {
        if (this.stopped.get()) {
            throw new IllegalStateException("SamzaKafkaAdmin.start() is called after stop()");
        }
    }

    public void stop() {
        if (this.stopped.compareAndSet(false, true)) {
            try {
                this.metadataConsumer.close();
            }
            catch (Exception e) {
                LOG.warn("metadataConsumer.close for system " + this.systemName + " failed with exception.", (Throwable)e);
            }
        }
        if (this.adminClient != null) {
            try {
                this.adminClient.close();
            }
            catch (Exception e) {
                LOG.warn("adminClient.close for system " + this.systemName + " failed with exception.", (Throwable)e);
            }
        }
    }

    public Map<String, SystemStreamMetadata> getSystemStreamPartitionCounts(final Set<String> streamNames, long cacheTTL) {
        final SystemStreamMetadata.SystemStreamPartitionMetadata dummySspm = new SystemStreamMetadata.SystemStreamPartitionMetadata(null, null, null){
            String msg;
            {
                this.msg = "getSystemStreamPartitionCounts does not populate SystemStreaMetadata info. Only number of partitions";
            }

            public String getOldestOffset() {
                throw new NotImplementedException(this.msg);
            }

            public String getNewestOffset() {
                throw new NotImplementedException(this.msg);
            }

            public String getUpcomingOffset() {
                throw new NotImplementedException(this.msg);
            }
        };
        ExponentialSleepStrategy strategy = new ExponentialSleepStrategy(2.0, 500L, 10000L);
        AbstractFunction1<ExponentialSleepStrategy.RetryLoop, Map<String, SystemStreamMetadata>> fetchMetadataOperation = new AbstractFunction1<ExponentialSleepStrategy.RetryLoop, Map<String, SystemStreamMetadata>>(){

            public Map<String, SystemStreamMetadata> apply(ExponentialSleepStrategy.RetryLoop loop) {
                HashMap<String, SystemStreamMetadata> allMetadata = new HashMap<String, SystemStreamMetadata>();
                streamNames.forEach(streamName -> {
                    HashMap partitionMetadata = new HashMap();
                    List partitionInfos = KafkaSystemAdmin.this.metadataConsumer.partitionsFor(streamName);
                    LOG.debug("Stream {} has partitions {}", streamName, (Object)partitionInfos);
                    partitionInfos.forEach(partitionInfo -> partitionMetadata.put(new Partition(partitionInfo.partition()), dummySspm));
                    allMetadata.put((String)streamName, new SystemStreamMetadata(streamName, partitionMetadata));
                });
                loop.done();
                return allMetadata;
            }
        };
        Map result = (Map)strategy.run((Function1)fetchMetadataOperation, (Function2)new AbstractFunction2<Exception, ExponentialSleepStrategy.RetryLoop, BoxedUnit>(){

            public BoxedUnit apply(Exception exception, ExponentialSleepStrategy.RetryLoop loop) {
                if (loop.sleepCount() >= 5) {
                    LOG.error(String.format("Fetching systemstreampartition counts for: %s threw an exception.", streamNames), (Throwable)exception);
                    loop.done();
                    throw new SamzaException((Throwable)exception);
                }
                LOG.warn(String.format("Fetching systemstreampartition counts for: %s threw an exception. Retrying.", streamNames), (Throwable)exception);
                return null;
            }
        }).get();
        LOG.info("SystemStream partition counts for system {}: {}", (Object)this.systemName, (Object)result);
        return result;
    }

    public Map<SystemStreamPartition, String> getOffsetsAfter(Map<SystemStreamPartition, String> offsets) {
        return offsets.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> String.valueOf(Long.valueOf((String)entry.getValue()) + 1L)));
    }

    public Map<String, SystemStreamMetadata> getSystemStreamMetadata(Set<String> streamNames) {
        return this.getSystemStreamMetadata(streamNames, new ExponentialSleepStrategy(2.0, 500L, 10000L));
    }

    public Map<SystemStreamPartition, SystemStreamMetadata.SystemStreamPartitionMetadata> getSSPMetadata(Set<SystemStreamPartition> ssps) {
        LOG.info("Fetching SSP metadata for: {}", ssps);
        List<TopicPartition> topicPartitions = ssps.stream().map(ssp -> new TopicPartition(ssp.getStream(), ssp.getPartition().getPartitionId())).collect(Collectors.toList());
        OffsetsMaps topicPartitionsMetadata = this.fetchTopicPartitionsMetadata(topicPartitions);
        HashMap<SystemStreamPartition, SystemStreamMetadata.SystemStreamPartitionMetadata> sspToSSPMetadata = new HashMap<SystemStreamPartition, SystemStreamMetadata.SystemStreamPartitionMetadata>();
        for (SystemStreamPartition ssp2 : ssps) {
            String oldestOffset = (String)topicPartitionsMetadata.getOldestOffsets().get(ssp2);
            String newestOffset = (String)topicPartitionsMetadata.getNewestOffsets().get(ssp2);
            String upcomingOffset = (String)topicPartitionsMetadata.getUpcomingOffsets().get(ssp2);
            sspToSSPMetadata.put(ssp2, new SystemStreamMetadata.SystemStreamPartitionMetadata(oldestOffset, newestOffset, upcomingOffset));
        }
        return sspToSSPMetadata;
    }

    public Map<String, SystemStreamMetadata> getSystemStreamMetadata(final Set<String> streamNames, ExponentialSleepStrategy retryBackoff) {
        LOG.info("Fetching system stream metadata for {} from system {}", streamNames, (Object)this.systemName);
        AbstractFunction1<ExponentialSleepStrategy.RetryLoop, Map<String, SystemStreamMetadata>> fetchMetadataOperation = new AbstractFunction1<ExponentialSleepStrategy.RetryLoop, Map<String, SystemStreamMetadata>>(){

            public Map<String, SystemStreamMetadata> apply(ExponentialSleepStrategy.RetryLoop loop) {
                Map metadata = KafkaSystemAdmin.this.fetchSystemStreamMetadata(streamNames);
                loop.done();
                return metadata;
            }
        };
        AbstractFunction2<Exception, ExponentialSleepStrategy.RetryLoop, BoxedUnit> onExceptionRetryOperation = new AbstractFunction2<Exception, ExponentialSleepStrategy.RetryLoop, BoxedUnit>(){

            public BoxedUnit apply(Exception exception, ExponentialSleepStrategy.RetryLoop loop) {
                if (loop.sleepCount() >= 5) {
                    LOG.error(String.format("Fetching system stream metadata for: %s threw an exception.", streamNames), (Throwable)exception);
                    loop.done();
                    throw new SamzaException((Throwable)exception);
                }
                LOG.warn(String.format("Fetching system stream metadata for: %s threw an exception. Retrying.", streamNames), (Throwable)exception);
                return null;
            }
        };
        AbstractFunction0<Map<String, SystemStreamMetadata>> fallbackOperation = new AbstractFunction0<Map<String, SystemStreamMetadata>>(){

            public Map<String, SystemStreamMetadata> apply() {
                throw new SamzaException("Failed to get system stream metadata");
            }
        };
        Map result = (Map)retryBackoff.run((Function1)fetchMetadataOperation, (Function2)onExceptionRetryOperation).getOrElse((Function0)fallbackOperation);
        return result;
    }

    public String getNewestOffset(final SystemStreamPartition ssp, final Integer maxRetries) {
        LOG.info("Fetching newest offset for: {}", (Object)ssp);
        ExponentialSleepStrategy strategy = new ExponentialSleepStrategy(2.0, 500L, 10000L);
        AbstractFunction1<ExponentialSleepStrategy.RetryLoop, String> fetchNewestOffset = new AbstractFunction1<ExponentialSleepStrategy.RetryLoop, String>(){

            public String apply(ExponentialSleepStrategy.RetryLoop loop) {
                String result = KafkaSystemAdmin.this.fetchNewestOffset(ssp);
                loop.done();
                return result;
            }
        };
        String offset = (String)strategy.run((Function1)fetchNewestOffset, (Function2)new AbstractFunction2<Exception, ExponentialSleepStrategy.RetryLoop, BoxedUnit>(){

            public BoxedUnit apply(Exception exception, ExponentialSleepStrategy.RetryLoop loop) {
                if (loop.sleepCount() >= maxRetries) {
                    LOG.error(String.format("Fetching newest offset for: %s threw an exception.", ssp), (Throwable)exception);
                    loop.done();
                    throw new SamzaException("Exception while trying to get newest offset", (Throwable)exception);
                }
                LOG.warn(String.format("Fetching newest offset for: %s threw an exception. Retrying.", ssp), (Throwable)exception);
                return null;
            }
        }).get();
        return offset;
    }

    private SystemStreamPartition toSystemStreamPartition(TopicPartition topicPartition) {
        String topic = topicPartition.topic();
        Partition partition = new Partition(topicPartition.partition());
        return new SystemStreamPartition(this.systemName, topic, partition);
    }

    private OffsetsMaps fetchTopicPartitionsMetadata(List<TopicPartition> topicPartitions) {
        HashMap oldestOffsets = new HashMap();
        HashMap newestOffsets = new HashMap();
        HashMap upcomingOffsets = new HashMap();
        Map oldestOffsetsWithLong = this.metadataConsumer.beginningOffsets(topicPartitions);
        LOG.debug("Kafka-fetched beginningOffsets: {}", (Object)oldestOffsetsWithLong);
        Map upcomingOffsetsWithLong = this.metadataConsumer.endOffsets(topicPartitions);
        LOG.debug("Kafka-fetched endOffsets: {}", (Object)upcomingOffsetsWithLong);
        oldestOffsetsWithLong.forEach((topicPartition, offset) -> oldestOffsets.put(this.toSystemStreamPartition((TopicPartition)topicPartition), String.valueOf(offset)));
        upcomingOffsetsWithLong.forEach((topicPartition, offset) -> {
            upcomingOffsets.put(this.toSystemStreamPartition((TopicPartition)topicPartition), String.valueOf(offset));
            if (offset <= 0L) {
                LOG.warn("Empty Kafka topic partition {} with upcoming offset {}. Skipping newest offset and setting oldest offset to 0 to consume from beginning", topicPartition, offset);
                oldestOffsets.put(this.toSystemStreamPartition((TopicPartition)topicPartition), "0");
            } else {
                newestOffsets.put(this.toSystemStreamPartition((TopicPartition)topicPartition), String.valueOf(offset - 1L));
            }
        });
        return new OffsetsMaps(oldestOffsets, newestOffsets, upcomingOffsets);
    }

    private Map<String, SystemStreamMetadata> fetchSystemStreamMetadata(Set<String> topics) {
        HashMap allOldestOffsets = new HashMap();
        HashMap allNewestOffsets = new HashMap();
        HashMap allUpcomingOffsets = new HashMap();
        LOG.info("Fetching SystemStreamMetadata for topics {} on system {}", topics, (Object)this.systemName);
        topics.forEach(topic -> {
            List partitionInfos = this.metadataConsumer.partitionsFor(topic);
            if (partitionInfos == null) {
                String msg = String.format("Partition info not(yet?) available for system %s topic %s", this.systemName, topic);
                throw new SamzaException(msg);
            }
            List<TopicPartition> topicPartitions = partitionInfos.stream().map(partitionInfo -> new TopicPartition(partitionInfo.topic(), partitionInfo.partition())).collect(Collectors.toList());
            OffsetsMaps offsetsForTopic = this.fetchTopicPartitionsMetadata(topicPartitions);
            allOldestOffsets.putAll(offsetsForTopic.getOldestOffsets());
            allNewestOffsets.putAll(offsetsForTopic.getNewestOffsets());
            allUpcomingOffsets.putAll(offsetsForTopic.getUpcomingOffsets());
        });
        scala.collection.immutable.Map<String, SystemStreamMetadata> result = KafkaSystemAdminUtilsScala.assembleMetadata((scala.collection.immutable.Map<SystemStreamPartition, String>)ScalaJavaUtil.toScalaMap(allOldestOffsets), (scala.collection.immutable.Map<SystemStreamPartition, String>)ScalaJavaUtil.toScalaMap(allNewestOffsets), (scala.collection.immutable.Map<SystemStreamPartition, String>)ScalaJavaUtil.toScalaMap(allUpcomingOffsets));
        LOG.debug("assembled SystemStreamMetadata is: {}", result);
        return (Map)JavaConverters.mapAsJavaMapConverter(result).asJava();
    }

    private String fetchNewestOffset(SystemStreamPartition ssp) {
        String newestOffset;
        LOG.debug("Fetching newest offset for {}", (Object)ssp);
        TopicPartition topicPartition = new TopicPartition(ssp.getStream(), ssp.getPartition().getPartitionId());
        Long upcomingOffset = (Long)this.metadataConsumer.endOffsets(Collections.singletonList(topicPartition)).get(topicPartition);
        if (upcomingOffset <= 0L) {
            LOG.debug("Stripping newest offsets for {} because the topic appears empty.", (Object)topicPartition);
            newestOffset = null;
        } else {
            newestOffset = String.valueOf(upcomingOffset - 1L);
        }
        LOG.info("Newest offset for ssp {} is: {}", (Object)ssp, (Object)newestOffset);
        return newestOffset;
    }

    public Integer offsetComparator(String offset1, String offset2) {
        if (offset1 == null || offset2 == null) {
            return -1;
        }
        return Long.valueOf(offset1).compareTo(Long.valueOf(offset2));
    }

    public boolean createStream(StreamSpec streamSpec) {
        LOG.info("Creating Kafka topic: {} on system: {}", (Object)streamSpec.getPhysicalName(), (Object)streamSpec.getSystemName());
        return KafkaSystemAdminUtilsScala.createStream(this.toKafkaSpec(streamSpec), this.getZkConnection());
    }

    public boolean clearStream(StreamSpec streamSpec) {
        LOG.info("Creating Kafka topic: {} on system: {}", (Object)streamSpec.getPhysicalName(), (Object)streamSpec.getSystemName());
        KafkaSystemAdminUtilsScala.clearStream(streamSpec, this.getZkConnection());
        Map<String, List<PartitionInfo>> topicsMetadata = this.getTopicMetadata((Set<String>)ImmutableSet.of((Object)streamSpec.getPhysicalName()));
        return topicsMetadata.get(streamSpec.getPhysicalName()).isEmpty();
    }

    public KafkaStreamSpec toKafkaSpec(StreamSpec spec) {
        KafkaStreamSpec kafkaSpec;
        if (spec.isChangeLogStream()) {
            String topicName = spec.getPhysicalName();
            ChangelogInfo topicMeta = this.changelogTopicMetaInformation.get(topicName);
            if (topicMeta == null) {
                throw new StreamValidationException("Unable to find topic information for topic " + topicName);
            }
            kafkaSpec = new KafkaStreamSpec(spec.getId(), topicName, this.systemName, spec.getPartitionCount(), topicMeta.replicationFactor(), topicMeta.kafkaProps());
        } else {
            kafkaSpec = spec.isCoordinatorStream() ? new KafkaStreamSpec(spec.getId(), spec.getPhysicalName(), this.systemName, 1, this.coordinatorStreamReplicationFactor, this.coordinatorStreamProperties) : (this.intermediateStreamProperties.containsKey(spec.getId()) ? KafkaStreamSpec.fromSpec(spec).copyWithProperties(this.intermediateStreamProperties.get(spec.getId())) : KafkaStreamSpec.fromSpec(spec));
        }
        return kafkaSpec;
    }

    public void validateStream(StreamSpec streamSpec) throws StreamValidationException {
        LOG.info("About to validate stream = " + streamSpec);
        String streamName = streamSpec.getPhysicalName();
        SystemStreamMetadata systemStreamMetadata = this.getSystemStreamMetadata(Collections.singleton(streamName)).get(streamName);
        if (systemStreamMetadata == null) {
            throw new StreamValidationException("Failed to obtain metadata for stream " + streamName + ". Validation failed.");
        }
        int actualPartitionCounter = systemStreamMetadata.getSystemStreamPartitionMetadata().size();
        int expectedPartitionCounter = streamSpec.getPartitionCount();
        LOG.info("actualCount=" + actualPartitionCounter + "; expectedCount=" + expectedPartitionCounter);
        if (actualPartitionCounter != expectedPartitionCounter) {
            throw new StreamValidationException(String.format("Mismatch of partitions for stream %s. Expected %d, got %d. Validation failed.", streamName, expectedPartitionCounter, actualPartitionCounter));
        }
    }

    Map<String, List<PartitionInfo>> getTopicMetadata(Set<String> topics) {
        HashMap<String, List<PartitionInfo>> streamToPartitionsInfo = new HashMap<String, List<PartitionInfo>>();
        for (String topic : topics) {
            List partitionInfoList = this.metadataConsumer.partitionsFor(topic);
            streamToPartitionsInfo.put(topic, partitionInfoList);
        }
        return streamToPartitionsInfo;
    }

    public void deleteMessages(Map<SystemStreamPartition, String> offsets) {
        if (this.deleteCommittedMessages) {
            if (this.adminClient == null) {
                this.adminClient = AdminClient.create((Properties)this.createAdminClientProperties());
            }
            KafkaSystemAdminUtilsScala.deleteMessages(this.adminClient, offsets);
            deleteMessageCalled = true;
        }
    }

    protected Properties createAdminClientProperties() {
        Properties props = new Properties();
        props.putAll((Map<?, ?>)this.config.subset(String.format("systems.%s.consumer.", this.systemName), true));
        String brokerList = (String)this.config.get((Object)String.format(KafkaConfig.CONSUMER_CONFIGS_CONFIG_KEY(), this.systemName, "bootstrap.servers"));
        if (brokerList == null) {
            brokerList = (String)this.config.get((Object)String.format(KafkaConfig.PRODUCER_CONFIGS_CONFIG_KEY(), this.systemName, "bootstrap.servers"));
        }
        if (brokerList == null) {
            throw new SamzaException("bootstrap.servers is required for systemAdmin for system " + this.systemName);
        }
        props.put("bootstrap.servers", brokerList);
        String zkConnect = (String)this.config.get((Object)String.format(KafkaConfig.CONSUMER_CONFIGS_CONFIG_KEY(), this.systemName, "zookeeper.connect"));
        if (StringUtils.isBlank((CharSequence)zkConnect)) {
            throw new SamzaException("Missing zookeeper.connect config for admin for system " + this.systemName);
        }
        props.put("zookeeper.connect", zkConnect);
        return props;
    }

    private Supplier<ZkUtils> getZkConnection() {
        String zkConnect = (String)this.config.get((Object)String.format(KafkaConfig.CONSUMER_CONFIGS_CONFIG_KEY(), this.systemName, "zookeeper.connect"));
        if (StringUtils.isBlank((CharSequence)zkConnect)) {
            throw new SamzaException("Missing zookeeper.connect config for admin for system " + this.systemName);
        }
        return () -> ZkUtils.apply((String)zkConnect, (int)6000, (int)6000, (boolean)false);
    }

    private static class OffsetsMaps {
        private final Map<SystemStreamPartition, String> oldestOffsets;
        private final Map<SystemStreamPartition, String> newestOffsets;
        private final Map<SystemStreamPartition, String> upcomingOffsets;

        private OffsetsMaps(Map<SystemStreamPartition, String> oldestOffsets, Map<SystemStreamPartition, String> newestOffsets, Map<SystemStreamPartition, String> upcomingOffsets) {
            this.oldestOffsets = oldestOffsets;
            this.newestOffsets = newestOffsets;
            this.upcomingOffsets = upcomingOffsets;
        }

        private Map<SystemStreamPartition, String> getOldestOffsets() {
            return this.oldestOffsets;
        }

        private Map<SystemStreamPartition, String> getNewestOffsets() {
            return this.newestOffsets;
        }

        private Map<SystemStreamPartition, String> getUpcomingOffsets() {
            return this.upcomingOffsets;
        }
    }
}

