/*
 * Decompiled with CFR 0.152.
 */
package org.apache.samza.system.kafka;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import kafka.log.LogConfig;
import org.apache.samza.config.KafkaConfig;
import org.apache.samza.system.StreamSpec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KafkaStreamSpec
extends StreamSpec {
    private static Logger LOG = LoggerFactory.getLogger(KafkaStreamSpec.class);
    private static final int DEFAULT_REPLICATION_FACTOR = 2;
    private final int replicationFactor;

    private static Properties mapToProperties(Map<String, String> map) {
        Properties props = new Properties();
        props.putAll(map);
        return props;
    }

    private static Map<String, String> propertiesToMap(Properties properties) {
        HashMap<String, String> map = new HashMap<String, String>();
        for (String name : properties.stringPropertyNames()) {
            map.put(name, properties.getProperty(name));
        }
        return map;
    }

    private static Map<String, String> filterUnsupportedProperties(Map<String, String> originalConfig) {
        HashMap<String, String> filteredConfig = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : originalConfig.entrySet()) {
            if (KafkaConfig.TOPIC_REPLICATION_FACTOR().equals(entry.getKey())) continue;
            if (LogConfig.configNames().contains((Object)entry.getKey())) {
                filteredConfig.put(entry.getKey(), entry.getValue());
                continue;
            }
            LOG.warn("Property '{}' is not a valid Kafka topic config. It will be ignored.", (Object)entry.getKey());
        }
        return filteredConfig;
    }

    public static KafkaStreamSpec fromSpec(StreamSpec originalSpec) {
        if (originalSpec instanceof KafkaStreamSpec) {
            return (KafkaStreamSpec)originalSpec;
        }
        int replicationFactor = Integer.parseInt(originalSpec.getOrDefault(KafkaConfig.TOPIC_REPLICATION_FACTOR(), KafkaConfig.TOPIC_DEFAULT_REPLICATION_FACTOR()));
        return new KafkaStreamSpec(originalSpec.getId(), originalSpec.getPhysicalName(), originalSpec.getSystemName(), originalSpec.getPartitionCount(), replicationFactor, KafkaStreamSpec.mapToProperties(KafkaStreamSpec.filterUnsupportedProperties(originalSpec.getConfig())));
    }

    public KafkaStreamSpec(String id, String topicName, String systemName, int partitionCount) {
        this(id, topicName, systemName, partitionCount, 2, new Properties());
    }

    public KafkaStreamSpec(String id, String topicName, String systemName, int partitionCount, int replicationFactor, Properties properties) {
        super(id, topicName, systemName, partitionCount, KafkaStreamSpec.propertiesToMap(properties));
        if (partitionCount < 1) {
            throw new IllegalArgumentException("Parameter 'partitionCount' must be > 0");
        }
        if (replicationFactor <= 0) {
            throw new IllegalArgumentException(String.format("Replication factor %d must be greater than 0.", replicationFactor));
        }
        this.replicationFactor = replicationFactor;
    }

    public StreamSpec copyWithPartitionCount(int partitionCount) {
        return new KafkaStreamSpec(this.getId(), this.getPhysicalName(), this.getSystemName(), partitionCount, this.getReplicationFactor(), this.getProperties());
    }

    public KafkaStreamSpec copyWithReplicationFactor(int replicationFactor) {
        return new KafkaStreamSpec(this.getId(), this.getPhysicalName(), this.getSystemName(), this.getPartitionCount(), replicationFactor, this.getProperties());
    }

    public KafkaStreamSpec copyWithProperties(Properties properties) {
        return new KafkaStreamSpec(this.getId(), this.getPhysicalName(), this.getSystemName(), this.getPartitionCount(), this.getReplicationFactor(), properties);
    }

    public int getReplicationFactor() {
        return this.replicationFactor;
    }

    public Properties getProperties() {
        return KafkaStreamSpec.mapToProperties(this.getConfig());
    }
}

