/*
 * Decompiled with CFR 0.152.
 */
package org.apache.samza.config;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.kafka.clients.consumer.RangeAssignor;
import org.apache.kafka.common.serialization.ByteArrayDeserializer;
import org.apache.samza.SamzaException;
import org.apache.samza.config.Config;
import org.apache.samza.config.ConfigException;
import org.apache.samza.config.JobConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Option;

public class KafkaConsumerConfig
extends HashMap<String, Object> {
    public static final Logger LOG = LoggerFactory.getLogger(KafkaConsumerConfig.class);
    public static final String ZOOKEEPER_CONNECT = "zookeeper.connect";
    private final String systemName;
    static final String DEFAULT_KAFKA_CONSUMER_MAX_POLL_RECORDS = "100";

    private KafkaConsumerConfig(Map<String, Object> props, String systemName) {
        super(props);
        this.systemName = systemName;
    }

    public static KafkaConsumerConfig getKafkaSystemConsumerConfig(Config config, String systemName, String clientId) {
        Config subConf = config.subset(String.format("systems.%s.consumer.", systemName), true);
        String groupId = KafkaConsumerConfig.createConsumerGroupId(config);
        HashMap<String, Object> consumerProps = new HashMap<String, Object>();
        consumerProps.putAll((Map<String, Object>)subConf);
        consumerProps.put("group.id", groupId);
        consumerProps.put("client.id", clientId);
        consumerProps.put("enable.auto.commit", "false");
        consumerProps.put("auto.offset.reset", KafkaConsumerConfig.getAutoOffsetResetValue((String)consumerProps.get("auto.offset.reset")));
        if (!subConf.containsKey((Object)"bootstrap.servers")) {
            String bootstrapServers = (String)config.get((Object)String.format("systems.%s.producer.%s", systemName, "bootstrap.servers"));
            if (StringUtils.isEmpty((CharSequence)bootstrapServers)) {
                throw new SamzaException("Missing bootstrap.servers config  for " + systemName);
            }
            consumerProps.put("bootstrap.servers", bootstrapServers);
        }
        consumerProps.put("partition.assignment.strategy", RangeAssignor.class.getName());
        if (!consumerProps.containsKey("key.deserializer")) {
            LOG.info("setting key serialization for the consumer(for system {}) to ByteArrayDeserializer", (Object)systemName);
            consumerProps.put("key.deserializer", ByteArrayDeserializer.class.getName());
        }
        if (!consumerProps.containsKey("value.deserializer")) {
            LOG.info("setting value serialization for the consumer(for system {}) to ByteArrayDeserializer", (Object)systemName);
            consumerProps.put("value.deserializer", ByteArrayDeserializer.class.getName());
        }
        consumerProps.computeIfAbsent("max.poll.records", k -> DEFAULT_KAFKA_CONSUMER_MAX_POLL_RECORDS);
        return new KafkaConsumerConfig(consumerProps, systemName);
    }

    public String getClientId() {
        String clientId = (String)this.get("client.id");
        if (StringUtils.isBlank((CharSequence)clientId)) {
            throw new SamzaException("client Id is not set for consumer for system=" + this.systemName);
        }
        return clientId;
    }

    static String createConsumerGroupId(Config config) {
        Pair<String, String> jobNameId = KafkaConsumerConfig.getJobNameAndId(config);
        return String.format("%s-%s", jobNameId.getLeft(), jobNameId.getRight());
    }

    public static String createClientId(String prefix, Config config) {
        Pair<String, String> jobNameId = KafkaConsumerConfig.getJobNameAndId(config);
        String jobName = (String)jobNameId.getLeft();
        String jobId = (String)jobNameId.getRight();
        return String.format("%s-%s-%s", prefix.replaceAll("\\W", "_"), jobName.replaceAll("\\W", "_"), jobId.replaceAll("\\W", "_"));
    }

    public static Pair<String, String> getJobNameAndId(Config config) {
        JobConfig jobConfig = new JobConfig(config);
        Option jobNameOption = jobConfig.getName();
        if (jobNameOption.isEmpty()) {
            throw new ConfigException("Missing job name");
        }
        String jobName = (String)jobNameOption.get();
        return new ImmutablePair((Object)jobName, (Object)jobConfig.getJobId());
    }

    static String getAutoOffsetResetValue(String autoOffsetReset) {
        String newAutoOffsetReset;
        String SAMZA_OFFSET_LARGEST = "largest";
        String SAMZA_OFFSET_SMALLEST = "smallest";
        String KAFKA_OFFSET_LATEST = "latest";
        String KAFKA_OFFSET_EARLIEST = "earliest";
        String KAFKA_OFFSET_NONE = "none";
        if (autoOffsetReset == null) {
            return "latest";
        }
        if (autoOffsetReset.equals("earliest") || autoOffsetReset.equals("latest") || autoOffsetReset.equals("none")) {
            return autoOffsetReset;
        }
        switch (autoOffsetReset) {
            case "largest": {
                newAutoOffsetReset = "latest";
                break;
            }
            case "smallest": {
                newAutoOffsetReset = "earliest";
                break;
            }
            default: {
                newAutoOffsetReset = "latest";
            }
        }
        LOG.info("AutoOffsetReset value converted from {} to {}", (Object)autoOffsetReset, (Object)newAutoOffsetReset);
        return newAutoOffsetReset;
    }
}

