/*
 * Decompiled with CFR 0.152.
 */
package org.apache.samza.checkpoint.kafka;

import org.apache.samza.SamzaException;
import org.apache.samza.checkpoint.CheckpointManager;
import org.apache.samza.checkpoint.CheckpointManagerFactory;
import org.apache.samza.checkpoint.kafka.KafkaCheckpointManager;
import org.apache.samza.checkpoint.kafka.KafkaCheckpointManager$;
import org.apache.samza.config.Config;
import org.apache.samza.config.JobConfig$;
import org.apache.samza.config.KafkaConfig;
import org.apache.samza.config.SystemConfig;
import org.apache.samza.config.SystemConfig$;
import org.apache.samza.metrics.MetricsRegistry;
import org.apache.samza.system.StreamSpec;
import org.apache.samza.system.SystemFactory;
import org.apache.samza.system.kafka.KafkaStreamSpec;
import org.apache.samza.util.KafkaUtil$;
import org.apache.samza.util.Logging;
import org.apache.samza.util.NoOpMetricsRegistry;
import org.apache.samza.util.Util$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.Nothing$;

@ScalaSignature(bytes="\u0006\u0001i2A!\u0001\u0002\u0001\u001b\ti2*\u00194lC\u000eCWmY6q_&tG/T1oC\u001e,'OR1di>\u0014\u0018P\u0003\u0002\u0004\t\u0005)1.\u00194lC*\u0011QAB\u0001\u000bG\",7m\u001b9pS:$(BA\u0004\t\u0003\u0015\u0019\u0018-\u001c>b\u0015\tI!\"\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u0017\u0005\u0019qN]4\u0004\u0001M!\u0001A\u0004\f\u001b!\tyA#D\u0001\u0011\u0015\t\t\"#\u0001\u0003mC:<'\"A\n\u0002\t)\fg/Y\u0005\u0003+A\u0011aa\u00142kK\u000e$\bCA\f\u0019\u001b\u0005!\u0011BA\r\u0005\u0005a\u0019\u0005.Z2la>Lg\u000e^'b]\u0006<WM\u001d$bGR|'/\u001f\t\u00037yi\u0011\u0001\b\u0006\u0003;\u0019\tA!\u001e;jY&\u0011q\u0004\b\u0002\b\u0019><w-\u001b8h\u0011\u0015\t\u0003\u0001\"\u0001#\u0003\u0019a\u0014N\\5u}Q\t1\u0005\u0005\u0002%\u00015\t!\u0001C\u0003'\u0001\u0011\u0005q%\u0001\u000bhKR\u001c\u0005.Z2la>Lg\u000e^'b]\u0006<WM\u001d\u000b\u0004Q-\u0012\u0004CA\f*\u0013\tQCAA\tDQ\u0016\u001c7\u000e]8j]Rl\u0015M\\1hKJDQ\u0001L\u0013A\u00025\naaY8oM&<\u0007C\u0001\u00181\u001b\u0005y#B\u0001\u0017\u0007\u0013\t\ttF\u0001\u0004D_:4\u0017n\u001a\u0005\u0006g\u0015\u0002\r\u0001N\u0001\te\u0016<\u0017n\u001d;ssB\u0011Q\u0007O\u0007\u0002m)\u0011qGB\u0001\b[\u0016$(/[2t\u0013\tIdGA\bNKR\u0014\u0018nY:SK\u001eL7\u000f\u001e:z\u0001")
public class KafkaCheckpointManagerFactory
implements CheckpointManagerFactory,
Logging {
    private final String loggerName;
    private final Logger logger;
    private final String startupLoggerName;
    private final Logger startupLogger;
    private volatile byte bitmap$0;

    public String loggerName() {
        return this.loggerName;
    }

    private Logger logger$lzycompute() {
        KafkaCheckpointManagerFactory kafkaCheckpointManagerFactory = this;
        synchronized (kafkaCheckpointManagerFactory) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.logger = Logging.class.logger((Logging)this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.logger$lzycompute() : this.logger;
    }

    public String startupLoggerName() {
        return this.startupLoggerName;
    }

    private Logger startupLogger$lzycompute() {
        KafkaCheckpointManagerFactory kafkaCheckpointManagerFactory = this;
        synchronized (kafkaCheckpointManagerFactory) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.startupLogger = Logging.class.startupLogger((Logging)this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
            return this.startupLogger;
        }
    }

    public Logger startupLogger() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.startupLogger$lzycompute() : this.startupLogger;
    }

    public void org$apache$samza$util$Logging$_setter_$loggerName_$eq(String x$1) {
        this.loggerName = x$1;
    }

    public void org$apache$samza$util$Logging$_setter_$startupLoggerName_$eq(String x$1) {
        this.startupLoggerName = x$1;
    }

    public void startupLog(Function0<Object> message) {
        Logging.class.startupLog((Logging)this, message);
    }

    public void trace(Function0<Object> message) {
        Logging.class.trace((Logging)this, message);
    }

    public void trace(Function0<Object> message, Function0<Throwable> e) {
        Logging.class.trace((Logging)this, message, e);
    }

    public void debug(Function0<Object> message) {
        Logging.class.debug((Logging)this, message);
    }

    public void debug(Function0<Object> message, Function0<Throwable> e) {
        Logging.class.debug((Logging)this, message, e);
    }

    public void info(Function0<Object> message) {
        Logging.class.info((Logging)this, message);
    }

    public void info(Function0<Object> message, Function0<Throwable> e) {
        Logging.class.info((Logging)this, message, e);
    }

    public void warn(Function0<Object> message) {
        Logging.class.warn((Logging)this, message);
    }

    public void warn(Function0<Object> message, Function0<Throwable> e) {
        Logging.class.warn((Logging)this, message, e);
    }

    public void error(Function0<Object> message) {
        Logging.class.error((Logging)this, message);
    }

    public void error(Function0<Object> message, Function0<Throwable> e) {
        Logging.class.error((Logging)this, message, e);
    }

    public void putMDC(Function0<String> key, Function0<String> value) {
        Logging.class.putMDC((Logging)this, key, value);
    }

    public String getMDC(Function0<String> key) {
        return Logging.class.getMDC((Logging)this, key);
    }

    public void removeMDC(Function0<String> key) {
        Logging.class.removeMDC((Logging)this, key);
    }

    public void clearMDC() {
        Logging.class.clearMDC((Logging)this);
    }

    public CheckpointManager getCheckpointManager(Config config, MetricsRegistry registry) {
        String jobName = (String)JobConfig$.MODULE$.Config2Job(config).getName().getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Nothing$ apply() {
                throw new SamzaException("Missing job name in configs");
            }
        });
        String jobId = JobConfig$.MODULE$.Config2Job(config).getJobId();
        KafkaConfig kafkaConfig = new KafkaConfig(config);
        String checkpointSystemName = (String)kafkaConfig.getCheckpointSystem().getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Nothing$ apply() {
                throw new SamzaException("No system defined for Kafka's checkpoint manager.");
            }
        });
        String checkpointSystemFactoryName = (String)new SystemConfig(config).getSystemFactory(checkpointSystemName).getOrElse((Function0)new Serializable(this, checkpointSystemName){
            public static final long serialVersionUID = 0L;
            private final String checkpointSystemName$1;

            public final Nothing$ apply() {
                throw new SamzaException(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder().append((Object)"Missing configuration: ").append((Object)SystemConfig$.MODULE$.SYSTEM_FACTORY()).toString())).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.checkpointSystemName$1})));
            }
            {
                this.checkpointSystemName$1 = checkpointSystemName$1;
            }
        });
        SystemFactory checkpointSystemFactory = (SystemFactory)Util$.MODULE$.getObj(checkpointSystemFactoryName, SystemFactory.class);
        String checkpointTopic = KafkaUtil$.MODULE$.getCheckpointTopic(jobName, jobId, config);
        this.info((Function0<Object>)new Serializable(this, checkpointTopic){
            public static final long serialVersionUID = 0L;
            private final String checkpointTopic$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Creating a KafkaCheckpointManager to consume from ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.checkpointTopic$1}));
            }
            {
                this.checkpointTopic$1 = checkpointTopic$1;
            }
        });
        KafkaStreamSpec checkpointSpec = KafkaStreamSpec.fromSpec(StreamSpec.createCheckpointStreamSpec((String)checkpointTopic, (String)checkpointSystemName)).copyWithReplicationFactor(new StringOps(Predef$.MODULE$.augmentString((String)kafkaConfig.getCheckpointReplicationFactor().get())).toInt()).copyWithProperties(kafkaConfig.getCheckpointTopicProperties());
        return new KafkaCheckpointManager(checkpointSpec, checkpointSystemFactory, JobConfig$.MODULE$.Config2Job(config).failOnCheckpointValidation(), config, (MetricsRegistry)new NoOpMetricsRegistry(), KafkaCheckpointManager$.MODULE$.$lessinit$greater$default$6(), KafkaCheckpointManager$.MODULE$.$lessinit$greater$default$7());
    }

    public KafkaCheckpointManagerFactory() {
        Logging.class.$init$((Logging)this);
    }
}

