/*
 * Decompiled with CFR 0.152.
 */
package org.apache.samza.checkpoint.kafka;

import com.google.common.base.Preconditions;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.samza.Partition;
import org.apache.samza.SamzaException;
import org.apache.samza.checkpoint.Checkpoint;
import org.apache.samza.checkpoint.CheckpointManager;
import org.apache.samza.checkpoint.kafka.KafkaCheckpointLogKey;
import org.apache.samza.checkpoint.kafka.KafkaCheckpointManager$;
import org.apache.samza.config.Config;
import org.apache.samza.config.JobConfig;
import org.apache.samza.container.TaskName;
import org.apache.samza.metrics.MetricsRegistry;
import org.apache.samza.serializers.Serde;
import org.apache.samza.system.OutgoingMessageEnvelope;
import org.apache.samza.system.StreamSpec;
import org.apache.samza.system.SystemAdmin;
import org.apache.samza.system.SystemConsumer;
import org.apache.samza.system.SystemFactory;
import org.apache.samza.system.SystemProducer;
import org.apache.samza.system.SystemStream;
import org.apache.samza.system.SystemStreamMetadata;
import org.apache.samza.system.SystemStreamPartition;
import org.apache.samza.system.SystemStreamPartitionIterator;
import org.apache.samza.system.kafka.KafkaStreamSpec;
import org.apache.samza.util.ExponentialSleepStrategy;
import org.apache.samza.util.Logging;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Map$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.Null$;

@ScalaSignature(bytes="\u0006\u0001\t%a\u0001B\u0001\u0003\u00015\u0011acS1gW\u0006\u001c\u0005.Z2la>Lg\u000e^'b]\u0006<WM\u001d\u0006\u0003\u0007\u0011\tQa[1gW\u0006T!!\u0002\u0004\u0002\u0015\rDWmY6q_&tGO\u0003\u0002\b\u0011\u0005)1/Y7{C*\u0011\u0011BC\u0001\u0007CB\f7\r[3\u000b\u0003-\t1a\u001c:h\u0007\u0001\u0019B\u0001\u0001\b\u00175A\u0011q\u0002F\u0007\u0002!)\u0011\u0011CE\u0001\u0005Y\u0006twMC\u0001\u0014\u0003\u0011Q\u0017M^1\n\u0005U\u0001\"AB(cU\u0016\u001cG\u000f\u0005\u0002\u001815\tA!\u0003\u0002\u001a\t\t\t2\t[3dWB|\u0017N\u001c;NC:\fw-\u001a:\u0011\u0005mqR\"\u0001\u000f\u000b\u0005u1\u0011\u0001B;uS2L!a\b\u000f\u0003\u000f1{wmZ5oO\"A\u0011\u0005\u0001B\u0001B\u0003%!%\u0001\bdQ\u0016\u001c7\u000e]8j]R\u001c\u0006/Z2\u0011\u0005\r:S\"\u0001\u0013\u000b\u0005\r)#B\u0001\u0014\u0007\u0003\u0019\u0019\u0018p\u001d;f[&\u0011\u0001\u0006\n\u0002\u0010\u0017\u000647.Y*ue\u0016\fWn\u00159fG\"A!\u0006\u0001B\u0001B\u0003%1&A\u0007tsN$X-\u001c$bGR|'/\u001f\t\u0003Y5j\u0011!J\u0005\u0003]\u0015\u0012QbU=ti\u0016lg)Y2u_JL\b\u0002\u0003\u0019\u0001\u0005\u0003\u0005\u000b\u0011B\u0019\u0002%Y\fG.\u001b3bi\u0016\u001c\u0005.Z2la>Lg\u000e\u001e\t\u0003eUj\u0011a\r\u0006\u0002i\u0005)1oY1mC&\u0011ag\r\u0002\b\u0005>|G.Z1o\u0011!A\u0004A!A!\u0002\u0013I\u0014AB2p]\u001aLw\r\u0005\u0002;y5\t1H\u0003\u00029\r%\u0011Qh\u000f\u0002\u0007\u0007>tg-[4\t\u0011}\u0002!\u0011!Q\u0001\n\u0001\u000bq\"\\3ue&\u001c7OU3hSN$(/\u001f\t\u0003\u0003\u0012k\u0011A\u0011\u0006\u0003\u0007\u001a\tq!\\3ue&\u001c7/\u0003\u0002F\u0005\nyQ*\u001a;sS\u000e\u001c(+Z4jgR\u0014\u0018\u0010\u0003\u0005H\u0001\t\u0005\t\u0015!\u0003I\u0003I\u0019\u0007.Z2la>Lg\u000e^'tON+'\u000fZ3\u0011\u0007%ce*D\u0001K\u0015\tYe!A\u0006tKJL\u0017\r\\5{KJ\u001c\u0018BA'K\u0005\u0015\u0019VM\u001d3f!\t9r*\u0003\u0002Q\t\tQ1\t[3dWB|\u0017N\u001c;\t\u0011I\u0003!\u0011!Q\u0001\nM\u000b!c\u00195fG.\u0004x.\u001b8u\u0017\u0016L8+\u001a:eKB\u0019\u0011\n\u0014+\u0011\u0005U3V\"\u0001\u0002\n\u0005]\u0013!!F&bM.\f7\t[3dWB|\u0017N\u001c;M_\u001e\\U-\u001f\u0005\u00063\u0002!\tAW\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0011mcVLX0aC\n\u0004\"!\u0016\u0001\t\u000b\u0005B\u0006\u0019\u0001\u0012\t\u000b)B\u0006\u0019A\u0016\t\u000bAB\u0006\u0019A\u0019\t\u000baB\u0006\u0019A\u001d\t\u000b}B\u0006\u0019\u0001!\t\u000f\u001dC\u0006\u0013!a\u0001\u0011\"9!\u000b\u0017I\u0001\u0002\u0004\u0019\u0006b\u00023\u0001\u0001\u0004%\t!Z\u0001\u0013\u001b\u0006D(+\u001a;ss\u0012+(/\u0019;j_:l5/F\u0001g!\t\u0011t-\u0003\u0002ig\t!Aj\u001c8h\u0011\u001dQ\u0007\u00011A\u0005\u0002-\fa#T1y%\u0016$(/\u001f#ve\u0006$\u0018n\u001c8Ng~#S-\u001d\u000b\u0003Y>\u0004\"AM7\n\u00059\u001c$\u0001B+oSRDq\u0001]5\u0002\u0002\u0003\u0007a-A\u0002yIEBaA\u001d\u0001!B\u00131\u0017aE'bqJ+GO]=EkJ\fG/[8o\u001bN\u0004\u0003b\u0002;\u0001\u0005\u0004%\t!^\u0001\u0011G\",7m\u001b9pS:$8+_:uK6,\u0012A\u001e\t\u0003ojt!A\r=\n\u0005e\u001c\u0014A\u0002)sK\u0012,g-\u0003\u0002|y\n11\u000b\u001e:j]\u001eT!!_\u001a\t\ry\u0004\u0001\u0015!\u0003w\u0003E\u0019\u0007.Z2la>Lg\u000e^*zgR,W\u000e\t\u0005\t\u0003\u0003\u0001!\u0019!C\u0001k\u0006y1\r[3dWB|\u0017N\u001c;U_BL7\rC\u0004\u0002\u0006\u0001\u0001\u000b\u0011\u0002<\u0002!\rDWmY6q_&tG\u000fV8qS\u000e\u0004\u0003\"CA\u0005\u0001\t\u0007I\u0011AA\u0006\u00035\u0019\u0007.Z2la>Lg\u000e^*taV\u0011\u0011Q\u0002\t\u0004Y\u0005=\u0011bAA\tK\t)2+_:uK6\u001cFO]3b[B\u000b'\u000f^5uS>t\u0007\u0002CA\u000b\u0001\u0001\u0006I!!\u0004\u0002\u001d\rDWmY6q_&tGoU:qA!A\u0011\u0011\u0004\u0001C\u0002\u0013\u0005Q/\u0001\ffqB,7\r^3e\u000fJ|W\u000f]3s\r\u0006\u001cGo\u001c:z\u0011\u001d\ti\u0002\u0001Q\u0001\nY\fq#\u001a=qK\u000e$X\rZ$s_V\u0004XM\u001d$bGR|'/\u001f\u0011\t\u0013\u0005\u0005\u0002A1A\u0005\u0002\u0005\r\u0012AD:zgR,W\u000e\u0015:pIV\u001cWM]\u000b\u0003\u0003K\u00012\u0001LA\u0014\u0013\r\tI#\n\u0002\u000f'f\u001cH/Z7Qe>$WoY3s\u0011!\ti\u0003\u0001Q\u0001\n\u0005\u0015\u0012aD:zgR,W\u000e\u0015:pIV\u001cWM\u001d\u0011\t\u0013\u0005E\u0002A1A\u0005\u0002\u0005M\u0012AD:zgR,WnQ8ogVlWM]\u000b\u0003\u0003k\u00012\u0001LA\u001c\u0013\r\tI$\n\u0002\u000f'f\u001cH/Z7D_:\u001cX/\\3s\u0011!\ti\u0004\u0001Q\u0001\n\u0005U\u0012aD:zgR,WnQ8ogVlWM\u001d\u0011\t\u0013\u0005\u0005\u0003A1A\u0005\u0002\u0005\r\u0013aC:zgR,W.\u00113nS:,\"!!\u0012\u0011\u00071\n9%C\u0002\u0002J\u0015\u00121bU=ti\u0016l\u0017\tZ7j]\"A\u0011Q\n\u0001!\u0002\u0013\t)%\u0001\u0007tsN$X-\\!e[&t\u0007\u0005C\u0005\u0002R\u0001\u0001\r\u0011\"\u0001\u0002T\u0005IA/Y:l\u001d\u0006lWm]\u000b\u0003\u0003+\u0002b!a\u0016\u0002b\u0005\u0015TBAA-\u0015\u0011\tY&!\u0018\u0002\u0013%lW.\u001e;bE2,'bAA0g\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\u0005\r\u0014\u0011\f\u0002\u0004'\u0016$\b\u0003BA4\u0003[j!!!\u001b\u000b\u0007\u0005-d!A\u0005d_:$\u0018-\u001b8fe&!\u0011qNA5\u0005!!\u0016m]6OC6,\u0007\"CA:\u0001\u0001\u0007I\u0011AA;\u00035!\u0018m]6OC6,7o\u0018\u0013fcR\u0019A.a\u001e\t\u0013A\f\t(!AA\u0002\u0005U\u0003\u0002CA>\u0001\u0001\u0006K!!\u0016\u0002\u0015Q\f7o\u001b(b[\u0016\u001c\b\u0005C\u0005\u0002\u0000\u0001\u0001\r\u0011\"\u0001\u0002\u0002\u00061B/Y:l\u001d\u0006lWm\u001d+p\u0007\",7m\u001b9pS:$8/\u0006\u0002\u0002\u0004B1q/!\"\u0002f9K1!a\"}\u0005\ri\u0015\r\u001d\u0005\n\u0003\u0017\u0003\u0001\u0019!C\u0001\u0003\u001b\u000b!\u0004^1tW:\u000bW.Z:U_\u000eCWmY6q_&tGo]0%KF$2\u0001\\AH\u0011%\u0001\u0018\u0011RA\u0001\u0002\u0004\t\u0019\t\u0003\u0005\u0002\u0014\u0002\u0001\u000b\u0015BAB\u0003]!\u0018m]6OC6,7\u000fV8DQ\u0016\u001c7\u000e]8j]R\u001c\b\u0005C\u0004\u0002\u0018\u0002!\t%!'\u0002\u001f\r\u0014X-\u0019;f%\u0016\u001cx.\u001e:dKN$\u0012\u0001\u001c\u0005\b\u0003;\u0003A\u0011IAM\u0003\u0015\u0019H/\u0019:u\u0011\u001d\t\t\u000b\u0001C!\u0003G\u000b\u0001B]3hSN$XM\u001d\u000b\u0004Y\u0006\u0015\u0006\u0002CAT\u0003?\u0003\r!!\u001a\u0002\u0011Q\f7o\u001b(b[\u0016Dq!a+\u0001\t\u0003\ni+\u0001\nsK\u0006$G*Y:u\u0007\",7m\u001b9pS:$Hc\u0001(\u00020\"A\u0011qUAU\u0001\u0004\t)\u0007C\u0004\u00024\u0002!\t%!.\u0002\u001f]\u0014\u0018\u000e^3DQ\u0016\u001c7\u000e]8j]R$R\u0001\\A\\\u0003sC\u0001\"a*\u00022\u0002\u0007\u0011Q\r\u0005\u0007\u000b\u0005E\u0006\u0019\u0001(\t\u000f\u0005u\u0006\u0001\"\u0011\u0002\u001a\u0006\u00012\r\\3be\u000eCWmY6q_&tGo\u001d\u0005\b\u0003\u0003\u0004A\u0011IAM\u0003\u0011\u0019Ho\u001c9\t\u000f\u0005\u0015\u0007\u0001\"\u0003\u0002H\u0006y!/Z1e\u0007\",7m\u001b9pS:$8\u000f\u0006\u0002\u0002\u0004\"9\u00111\u001a\u0001\u0005\n\u00055\u0017aD4fi>cG-Z:u\u001f\u001a47/\u001a;\u0015\u0007Y\fy\r\u0003\u0005\u0002R\u0006%\u0007\u0019AA\u0007\u0003\r\u00198\u000f]\u0004\n\u0003+\u0014\u0011\u0011!E\u0001\u0003/\facS1gW\u0006\u001c\u0005.Z2la>Lg\u000e^'b]\u0006<WM\u001d\t\u0004+\u0006eg\u0001C\u0001\u0003\u0003\u0003E\t!a7\u0014\t\u0005e\u0017Q\u001c\t\u0004e\u0005}\u0017bAAqg\t1\u0011I\\=SK\u001aDq!WAm\t\u0003\t)\u000f\u0006\u0002\u0002X\"Q\u0011\u0011^Am#\u0003%\t!a;\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00137+\t\tiOK\u0002I\u0003_\\#!!=\u0011\t\u0005M\u0018Q`\u0007\u0003\u0003kTA!a>\u0002z\u0006IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003w\u001c\u0014AC1o]>$\u0018\r^5p]&!\u0011q`A{\u0005E)hn\u00195fG.,GMV1sS\u0006t7-\u001a\u0005\u000b\u0005\u0007\tI.%A\u0005\u0002\t\u0015\u0011a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$s'\u0006\u0002\u0003\b)\u001a1+a<")
public class KafkaCheckpointManager
implements CheckpointManager,
Logging {
    public final KafkaStreamSpec org$apache$samza$checkpoint$kafka$KafkaCheckpointManager$$checkpointSpec;
    public final boolean org$apache$samza$checkpoint$kafka$KafkaCheckpointManager$$validateCheckpoint;
    private final Serde<Checkpoint> checkpointMsgSerde;
    private final Serde<KafkaCheckpointLogKey> checkpointKeySerde;
    private long MaxRetryDurationMs;
    private final String checkpointSystem;
    private final String checkpointTopic;
    private final SystemStreamPartition checkpointSsp;
    private final String expectedGrouperFactory;
    private final SystemProducer systemProducer;
    private final SystemConsumer systemConsumer;
    private final SystemAdmin systemAdmin;
    private Set<TaskName> taskNames;
    private scala.collection.immutable.Map<TaskName, Checkpoint> taskNamesToCheckpoints;
    private final String loggerName;
    private final Logger logger;
    private final String startupLoggerName;
    private final Logger startupLogger;
    private volatile byte bitmap$0;

    public static Serde<KafkaCheckpointLogKey> $lessinit$greater$default$7() {
        return KafkaCheckpointManager$.MODULE$.$lessinit$greater$default$7();
    }

    public static Serde<Checkpoint> $lessinit$greater$default$6() {
        return KafkaCheckpointManager$.MODULE$.$lessinit$greater$default$6();
    }

    public String loggerName() {
        return this.loggerName;
    }

    private Logger logger$lzycompute() {
        KafkaCheckpointManager kafkaCheckpointManager = this;
        synchronized (kafkaCheckpointManager) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.logger = Logging.class.logger((Logging)this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.logger$lzycompute() : this.logger;
    }

    public String startupLoggerName() {
        return this.startupLoggerName;
    }

    private Logger startupLogger$lzycompute() {
        KafkaCheckpointManager kafkaCheckpointManager = this;
        synchronized (kafkaCheckpointManager) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.startupLogger = Logging.class.startupLogger((Logging)this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
            return this.startupLogger;
        }
    }

    public Logger startupLogger() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.startupLogger$lzycompute() : this.startupLogger;
    }

    public void org$apache$samza$util$Logging$_setter_$loggerName_$eq(String x$1) {
        this.loggerName = x$1;
    }

    public void org$apache$samza$util$Logging$_setter_$startupLoggerName_$eq(String x$1) {
        this.startupLoggerName = x$1;
    }

    public void startupLog(Function0<Object> message) {
        Logging.class.startupLog((Logging)this, message);
    }

    public void trace(Function0<Object> message) {
        Logging.class.trace((Logging)this, message);
    }

    public void trace(Function0<Object> message, Function0<Throwable> e) {
        Logging.class.trace((Logging)this, message, e);
    }

    public void debug(Function0<Object> message) {
        Logging.class.debug((Logging)this, message);
    }

    public void debug(Function0<Object> message, Function0<Throwable> e) {
        Logging.class.debug((Logging)this, message, e);
    }

    public void info(Function0<Object> message) {
        Logging.class.info((Logging)this, message);
    }

    public void info(Function0<Object> message, Function0<Throwable> e) {
        Logging.class.info((Logging)this, message, e);
    }

    public void warn(Function0<Object> message) {
        Logging.class.warn((Logging)this, message);
    }

    public void warn(Function0<Object> message, Function0<Throwable> e) {
        Logging.class.warn((Logging)this, message, e);
    }

    public void error(Function0<Object> message) {
        Logging.class.error((Logging)this, message);
    }

    public void error(Function0<Object> message, Function0<Throwable> e) {
        Logging.class.error((Logging)this, message, e);
    }

    public void putMDC(Function0<String> key, Function0<String> value) {
        Logging.class.putMDC((Logging)this, key, value);
    }

    public String getMDC(Function0<String> key) {
        return Logging.class.getMDC((Logging)this, key);
    }

    public void removeMDC(Function0<String> key) {
        Logging.class.removeMDC((Logging)this, key);
    }

    public void clearMDC() {
        Logging.class.clearMDC((Logging)this);
    }

    public long MaxRetryDurationMs() {
        return this.MaxRetryDurationMs;
    }

    public void MaxRetryDurationMs_$eq(long x$1) {
        this.MaxRetryDurationMs = x$1;
    }

    public String checkpointSystem() {
        return this.checkpointSystem;
    }

    public String checkpointTopic() {
        return this.checkpointTopic;
    }

    public SystemStreamPartition checkpointSsp() {
        return this.checkpointSsp;
    }

    public String expectedGrouperFactory() {
        return this.expectedGrouperFactory;
    }

    public SystemProducer systemProducer() {
        return this.systemProducer;
    }

    public SystemConsumer systemConsumer() {
        return this.systemConsumer;
    }

    public SystemAdmin systemAdmin() {
        return this.systemAdmin;
    }

    public Set<TaskName> taskNames() {
        return this.taskNames;
    }

    public void taskNames_$eq(Set<TaskName> x$1) {
        this.taskNames = x$1;
    }

    public scala.collection.immutable.Map<TaskName, Checkpoint> taskNamesToCheckpoints() {
        return this.taskNamesToCheckpoints;
    }

    public void taskNamesToCheckpoints_$eq(scala.collection.immutable.Map<TaskName, Checkpoint> x$1) {
        this.taskNamesToCheckpoints = x$1;
    }

    public void createResources() {
        Preconditions.checkNotNull((Object)this.systemAdmin());
        this.systemAdmin().start();
        this.info((Function0<Object>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ KafkaCheckpointManager $outer;

            public final String apply() {
                return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Creating checkpoint stream: ", " with "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.org$apache$samza$checkpoint$kafka$KafkaCheckpointManager$$checkpointSpec.getPhysicalName()}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"partition count: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.$outer.org$apache$samza$checkpoint$kafka$KafkaCheckpointManager$$checkpointSpec.getPartitionCount())}))).toString();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.systemAdmin().createStream((StreamSpec)this.org$apache$samza$checkpoint$kafka$KafkaCheckpointManager$$checkpointSpec);
        if (this.org$apache$samza$checkpoint$kafka$KafkaCheckpointManager$$validateCheckpoint) {
            this.info((Function0<Object>)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Validating checkpoint stream"})).s((Seq)Nil$.MODULE$);
                }
            });
            this.systemAdmin().validateStream((StreamSpec)this.org$apache$samza$checkpoint$kafka$KafkaCheckpointManager$$checkpointSpec);
        }
    }

    public void start() {
        Preconditions.checkNotNull((Object)this.systemProducer());
        Preconditions.checkNotNull((Object)this.systemConsumer());
        this.systemProducer().start();
        String oldestOffset = this.getOldestOffset(this.checkpointSsp());
        this.info((Function0<Object>)new Serializable(this, oldestOffset){
            public static final long serialVersionUID = 0L;
            private final String oldestOffset$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Starting checkpoint SystemConsumer from oldest offset ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.oldestOffset$1}));
            }
            {
                this.oldestOffset$1 = oldestOffset$1;
            }
        });
        this.systemConsumer().register(this.checkpointSsp(), oldestOffset);
        this.systemConsumer().start();
    }

    public void register(TaskName taskName) {
        this.debug((Function0<Object>)new Serializable(this, taskName){
            public static final long serialVersionUID = 0L;
            private final TaskName taskName$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Registering taskName: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.taskName$1}));
            }
            {
                this.taskName$1 = taskName$1;
            }
        });
        this.systemProducer().register(taskName.getTaskName());
        this.taskNames_$eq((Set<TaskName>)((Set)this.taskNames().$plus((Object)taskName)));
    }

    /*
     * WARNING - void declaration
     */
    public Checkpoint readLastCheckpoint(TaskName taskName) {
        if (this.taskNames().contains((Object)taskName)) {
            void var2_2;
            this.info((Function0<Object>)new Serializable(this, taskName){
                public static final long serialVersionUID = 0L;
                private final TaskName taskName$2;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Reading checkpoint for taskName ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.taskName$2}));
                }
                {
                    this.taskName$2 = taskName$2;
                }
            });
            if (this.taskNamesToCheckpoints() == null) {
                this.debug((Function0<Object>)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "Reading checkpoints for the first time";
                    }
                });
                this.taskNamesToCheckpoints_$eq(this.readCheckpoints());
            } else {
                this.debug((Function0<Object>)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "Updating existing checkpoint mappings";
                    }
                });
                this.taskNamesToCheckpoints_$eq((scala.collection.immutable.Map<TaskName, Checkpoint>)this.taskNamesToCheckpoints().$plus$plus(this.readCheckpoints()));
            }
            Checkpoint checkpoint = (Checkpoint)this.taskNamesToCheckpoints().getOrElse((Object)taskName, (Function0)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final Null$ apply() {
                    return null;
                }
            });
            this.info((Function0<Object>)new Serializable(this, taskName, checkpoint){
                public static final long serialVersionUID = 0L;
                private final TaskName taskName$2;
                private final Checkpoint checkpoint$1;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Got checkpoint state for taskName - ", ": ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.taskName$2, this.checkpoint$1}));
                }
                {
                    this.taskName$2 = taskName$2;
                    this.checkpoint$1 = checkpoint$1;
                }
            });
            return var2_2;
        }
        throw new SamzaException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Task: ", " is not registered with this CheckpointManager"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{taskName})));
    }

    public void writeCheckpoint(TaskName taskName, Checkpoint checkpoint) {
        byte[] msgBytes;
        byte[] keyBytes;
        KafkaCheckpointLogKey key = new KafkaCheckpointLogKey("checkpoint", taskName, this.expectedGrouperFactory());
        try {
            keyBytes = this.checkpointKeySerde.toBytes((Object)key);
        }
        catch (Exception exception) {
            throw new SamzaException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Exception when writing checkpoint-key for ", ": ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{taskName, checkpoint})), (Throwable)exception);
        }
        try {
            msgBytes = this.checkpointMsgSerde.toBytes((Object)checkpoint);
        }
        catch (Exception exception) {
            throw new SamzaException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Exception when writing checkpoint for ", ": ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{taskName, checkpoint})), (Throwable)exception);
        }
        OutgoingMessageEnvelope envelope = new OutgoingMessageEnvelope((SystemStream)this.checkpointSsp(), (Object)keyBytes, (Object)msgBytes);
        ExponentialSleepStrategy retryBackoff = new ExponentialSleepStrategy();
        long startTime = System.currentTimeMillis();
        retryBackoff.run((Function1)new Serializable(this, taskName, checkpoint, envelope){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ KafkaCheckpointManager $outer;
            public final TaskName taskName$3;
            public final Checkpoint checkpoint$2;
            private final OutgoingMessageEnvelope envelope$1;

            public final void apply(ExponentialSleepStrategy.RetryLoop loop) {
                this.$outer.systemProducer().send(this.taskName$3.getTaskName(), this.envelope$1);
                this.$outer.systemProducer().flush(this.taskName$3.getTaskName());
                this.$outer.debug((Function0<Object>)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$writeCheckpoint$1 $outer;

                    public final String apply() {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Wrote checkpoint: ", " for task: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.checkpoint$2, this.$outer.taskName$3}));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
                loop.done();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.taskName$3 = taskName$3;
                this.checkpoint$2 = checkpoint$2;
                this.envelope$1 = envelope$1;
            }
        }, (Function2)new Serializable(this, taskName, checkpoint, key, startTime){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ KafkaCheckpointManager $outer;
            public final TaskName taskName$3;
            public final Checkpoint checkpoint$2;
            public final KafkaCheckpointLogKey key$1;
            private final long startTime$1;

            public final void apply(Exception exception, ExponentialSleepStrategy.RetryLoop loop) {
                if (System.currentTimeMillis() - this.startTime$1 >= this.$outer.MaxRetryDurationMs()) {
                    this.$outer.error((Function0<Object>)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anonfun$writeCheckpoint$2 $outer;

                        public final String apply() {
                            return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Exhausted ", " milliseconds when writing checkpoint: ", " for task: ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.$outer.org$apache$samza$checkpoint$kafka$KafkaCheckpointManager$$anonfun$$$outer().MaxRetryDurationMs()), this.$outer.checkpoint$2, this.$outer.taskName$3}));
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                        }
                    });
                    throw new SamzaException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Exception when writing checkpoint: ", " for task: ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.checkpoint$2, this.taskName$3})), (Throwable)exception);
                }
                this.$outer.warn((Function0<Object>)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$writeCheckpoint$2 $outer;

                    public final String apply() {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Retrying failed checkpoint write to key: ", ", checkpoint: ", " for task: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.key$1, this.$outer.checkpoint$2, this.$outer.taskName$3}));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                }, (Function0<Throwable>)new Serializable(this, exception){
                    public static final long serialVersionUID = 0L;
                    private final Exception exception$1;

                    public final Exception apply() {
                        return this.exception$1;
                    }
                    {
                        this.exception$1 = exception$1;
                    }
                });
            }

            public /* synthetic */ KafkaCheckpointManager org$apache$samza$checkpoint$kafka$KafkaCheckpointManager$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.taskName$3 = taskName$3;
                this.checkpoint$2 = checkpoint$2;
                this.key$1 = key$1;
                this.startTime$1 = startTime$1;
            }
        });
    }

    public void clearCheckpoints() {
        this.info((Function0<Object>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ KafkaCheckpointManager $outer;

            public final String apply() {
                return new StringOps(Predef$.MODULE$.augmentString("Clear checkpoint stream %s in system %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.checkpointTopic(), this.$outer.checkpointSystem()}));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.systemAdmin().clearStream((StreamSpec)this.org$apache$samza$checkpoint$kafka$KafkaCheckpointManager$$checkpointSpec);
    }

    public void stop() {
        this.systemAdmin().stop();
        if (this.systemProducer() == null) {
            this.error((Function0<Object>)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Checkpoint SystemProducer should not be null";
                }
            });
        } else {
            this.systemProducer().stop();
        }
        if (this.systemConsumer() == null) {
            this.error((Function0<Object>)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Checkpoint SystemConsumer should not be null";
                }
            });
        } else {
            this.systemConsumer().stop();
        }
        this.info((Function0<Object>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "CheckpointManager stopped.";
            }
        });
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private scala.collection.immutable.Map<TaskName, Checkpoint> readCheckpoints() {
        checkpoints = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        iterator = new SystemStreamPartitionIterator(this.systemConsumer(), this.checkpointSsp());
        numMessagesRead = IntRef.create((int)0);
        if (true) ** GOTO lbl21
        {
            while (true) {
                if ((checkpointKey = v0) == null) {
                    v1 = BoxedUnit.UNIT;
                } else {
                    actualGrouperFactory = checkpointKey.getGrouperFactoryClassName();
                    if (!this.expectedGrouperFactory().equals(actualGrouperFactory)) {
                        this.warn((Function0<Object>)new Serializable(this, actualGrouperFactory){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ KafkaCheckpointManager $outer;
                            private final String actualGrouperFactory$1;

                            public final String apply() {
                                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Grouper mismatch. Configured: ", " Actual: ", " "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.expectedGrouperFactory(), this.actualGrouperFactory$1}));
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                                this.actualGrouperFactory$1 = actualGrouperFactory$1;
                            }
                        });
                        if (this.org$apache$samza$checkpoint$kafka$KafkaCheckpointManager$$validateCheckpoint) {
                            throw new SamzaException(new StringBuilder().append((Object)"SSPGrouperFactory in the checkpoint topic does not match the configured value").append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Configured value: ", "; Actual value: ", " Offset: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.expectedGrouperFactory(), actualGrouperFactory, var5_5}))).toString());
                        }
                    }
                    if ("checkpoint".equals(checkpointKey.getType())) {
                        checkpointBytes = (byte[])var4_4.getMessage();
                        checkpoint = (Checkpoint)this.checkpointMsgSerde.fromBytes(checkpointBytes);
                        v1 = checkpoints.put((Object)checkpointKey.getTaskName(), (Object)checkpoint);
                    } else {
                        v1 = BoxedUnit.UNIT;
                    }
                }
lbl21:
                // 4 sources

                if (!iterator.hasNext()) {
                    this.info((Function0<Object>)new Serializable(this, numMessagesRead){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ KafkaCheckpointManager $outer;
                        private final IntRef numMessagesRead$1;

                        public final String apply() {
                            return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Read ", " messages from system:", " topic:", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.numMessagesRead$1.elem), this.$outer.checkpointSystem(), this.$outer.checkpointTopic()}));
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.numMessagesRead$1 = numMessagesRead$1;
                        }
                    });
                    return checkpoints.toMap(Predef$.MODULE$.$conforms());
                }
                checkpointEnvelope = iterator.next();
                offset = checkpointEnvelope.getOffset();
                ++numMessagesRead.elem;
                if (numMessagesRead.elem % 1000 == 0) {
                    this.info((Function0<Object>)new Serializable(this, numMessagesRead, offset){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ KafkaCheckpointManager $outer;
                        private final IntRef numMessagesRead$1;
                        private final String offset$1;

                        public final String apply() {
                            return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Read ", " from topic: ", ". Current offset: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.numMessagesRead$1.elem), this.$outer.checkpointTopic(), this.offset$1}));
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.numMessagesRead$1 = numMessagesRead$1;
                            this.offset$1 = offset$1;
                        }
                    });
                }
                if ((keyBytes = (byte[])checkpointEnvelope.getKey()) != null) ** GOTO lbl-1000
                throw new SamzaException(new StringBuilder().append((Object)"Encountered a checkpoint message with null key. Topic:$checkpointTopic ").append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Offset:", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{offset}))).toString());
lbl-1000:
                // 1 sources

                {
                    v0 = (KafkaCheckpointLogKey)this.checkpointKeySerde.fromBytes(keyBytes);
                    continue;
                }
                break;
            }
            catch (Exception var12_12) {
                throw new SamzaException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Exception while serializing checkpoint-message. "})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Topic: ", " Offset: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.checkpointTopic(), offset}))).toString(), (Throwable)var12_12);
            }
        }
    }

    private String getOldestOffset(SystemStreamPartition ssp) {
        String topic = ssp.getSystemStream().getStream();
        Partition partition = ssp.getPartition();
        Map metaDataMap = this.systemAdmin().getSystemStreamMetadata(Collections.singleton(topic));
        SystemStreamMetadata checkpointMetadata = (SystemStreamMetadata)metaDataMap.get(topic);
        if (checkpointMetadata == null) {
            throw new SamzaException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Got null metadata for system:", ", topic:", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.checkpointSystem(), topic})));
        }
        SystemStreamMetadata.SystemStreamPartitionMetadata partitionMetaData = (SystemStreamMetadata.SystemStreamPartitionMetadata)checkpointMetadata.getSystemStreamPartitionMetadata().get(partition);
        if (partitionMetaData == null) {
            throw new SamzaException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Got a null partition metadata for system:", ", topic:", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.checkpointSystem(), topic})));
        }
        return partitionMetaData.getOldestOffset();
    }

    public KafkaCheckpointManager(KafkaStreamSpec checkpointSpec, SystemFactory systemFactory, boolean validateCheckpoint, Config config, MetricsRegistry metricsRegistry, Serde<Checkpoint> checkpointMsgSerde, Serde<KafkaCheckpointLogKey> checkpointKeySerde) {
        this.org$apache$samza$checkpoint$kafka$KafkaCheckpointManager$$checkpointSpec = checkpointSpec;
        this.org$apache$samza$checkpoint$kafka$KafkaCheckpointManager$$validateCheckpoint = validateCheckpoint;
        this.checkpointMsgSerde = checkpointMsgSerde;
        this.checkpointKeySerde = checkpointKeySerde;
        Logging.class.$init$((Logging)this);
        this.MaxRetryDurationMs = TimeUnit.MINUTES.toMillis(15L);
        this.info((Function0<Object>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ KafkaCheckpointManager $outer;

            public final String apply() {
                return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Creating KafkaCheckpointManager for checkpointTopic:", ", systemName:", " "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.checkpointTopic(), this.$outer.checkpointSystem()}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"validateCheckpoints:", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToBoolean((boolean)this.$outer.org$apache$samza$checkpoint$kafka$KafkaCheckpointManager$$validateCheckpoint)}))).toString();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.checkpointSystem = checkpointSpec.getSystemName();
        this.checkpointTopic = checkpointSpec.getPhysicalName();
        this.checkpointSsp = new SystemStreamPartition(this.checkpointSystem(), this.checkpointTopic(), new Partition(0));
        this.expectedGrouperFactory = new JobConfig(config).getSystemStreamPartitionGrouperFactory();
        this.systemProducer = systemFactory.getProducer(this.checkpointSystem(), config, metricsRegistry);
        this.systemConsumer = systemFactory.getConsumer(this.checkpointSystem(), config, metricsRegistry);
        this.systemAdmin = systemFactory.getAdmin(this.checkpointSystem(), config);
        this.taskNames = (Set)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$);
        this.taskNamesToCheckpoints = null;
    }
}

