/*
 * Decompiled with CFR 0.152.
 */
package org.apache.samza.checkpoint.kafka;

import com.google.common.collect.ImmutableMap;
import java.util.Arrays;
import java.util.LinkedHashMap;
import org.apache.samza.SamzaException;
import org.apache.samza.checkpoint.kafka.KafkaCheckpointLogKey;
import org.apache.samza.container.TaskName;
import org.apache.samza.serializers.Serde;
import org.codehaus.jackson.map.ObjectMapper;

public class KafkaCheckpointLogKeySerde
implements Serde<KafkaCheckpointLogKey> {
    private static final String SSP_GROUPER_FACTORY_FIELD = "systemstreampartition-grouper-factory";
    private static final String TASK_NAME_FIELD = "taskName";
    private static final String TYPE_FIELD = "type";
    private static final ObjectMapper mapper = new ObjectMapper();

    public byte[] toBytes(KafkaCheckpointLogKey key) {
        try {
            return mapper.writeValueAsBytes((Object)ImmutableMap.of((Object)SSP_GROUPER_FACTORY_FIELD, (Object)key.getGrouperFactoryClassName(), (Object)TASK_NAME_FIELD, (Object)key.getTaskName().toString(), (Object)TYPE_FIELD, (Object)key.getType()));
        }
        catch (Exception e) {
            throw new SamzaException(String.format("Exception in serializing: %s", key), (Throwable)e);
        }
    }

    public KafkaCheckpointLogKey fromBytes(byte[] bytes) {
        try {
            LinkedHashMap deserializedKey = (LinkedHashMap)mapper.readValue(bytes, LinkedHashMap.class);
            if (!"checkpoint".equals(deserializedKey.get(TYPE_FIELD))) {
                throw new IllegalArgumentException(String.format("Invalid key detected. Type of the key is %s", deserializedKey.get(TYPE_FIELD)));
            }
            return new KafkaCheckpointLogKey((String)deserializedKey.get(TYPE_FIELD), new TaskName((String)deserializedKey.get(TASK_NAME_FIELD)), (String)deserializedKey.get(SSP_GROUPER_FACTORY_FIELD));
        }
        catch (Exception e) {
            throw new SamzaException(String.format("Exception in de-serializing checkpoint bytes: %s", Arrays.toString(bytes)), (Throwable)e);
        }
    }
}

