/*
 * Decompiled with CFR 0.152.
 */
package org.apache.samza.checkpoint.kafka;

import com.google.common.base.Preconditions;
import org.apache.samza.container.TaskName;

public class KafkaCheckpointLogKey {
    public static final String CHECKPOINT_KEY_TYPE = "checkpoint";
    private final String grouperFactoryClassName;
    private final TaskName taskName;
    private final String type;

    public KafkaCheckpointLogKey(String type, TaskName taskName, String grouperFactoryClassName) {
        Preconditions.checkNotNull((Object)grouperFactoryClassName);
        Preconditions.checkNotNull((Object)taskName);
        Preconditions.checkNotNull((Object)type);
        Preconditions.checkState((!grouperFactoryClassName.isEmpty() ? 1 : 0) != 0, (Object)"Empty grouper factory class provided");
        Preconditions.checkState((boolean)type.equals(CHECKPOINT_KEY_TYPE), (Object)String.format("Invalid type provided for checkpoint key. Expected: (%s) Actual: (%s)", CHECKPOINT_KEY_TYPE, type));
        this.grouperFactoryClassName = grouperFactoryClassName;
        this.taskName = taskName;
        this.type = type;
    }

    public String getGrouperFactoryClassName() {
        return this.grouperFactoryClassName;
    }

    public TaskName getTaskName() {
        return this.taskName;
    }

    public String getType() {
        return this.type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        KafkaCheckpointLogKey that = (KafkaCheckpointLogKey)o;
        if (!this.grouperFactoryClassName.equals(that.grouperFactoryClassName)) {
            return false;
        }
        if (!this.taskName.equals((Object)that.taskName)) {
            return false;
        }
        return this.type.equals(that.type);
    }

    public int hashCode() {
        int result = this.grouperFactoryClassName.hashCode();
        result = 31 * result + this.taskName.hashCode();
        result = 31 * result + this.type.hashCode();
        return result;
    }

    public String toString() {
        return String.format("KafkaCheckpointLogKey[factoryClass: %s, taskName: %s, type: %s]", this.grouperFactoryClassName, this.taskName, this.type);
    }
}

