/*
 * Decompiled with CFR 0.152.
 */
package org.apache.samza.storage.kv.descriptors;

import com.google.common.base.Preconditions;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.samza.SamzaException;
import org.apache.samza.config.Config;
import org.apache.samza.config.JavaTableConfig;
import org.apache.samza.config.JobConfig;
import org.apache.samza.config.MapConfig;
import org.apache.samza.config.StorageConfig;
import org.apache.samza.context.Context;
import org.apache.samza.storage.kv.KeyValueStore;
import org.apache.samza.storage.kv.LocalStoreBackedReadWriteTable;
import org.apache.samza.table.Table;
import org.apache.samza.table.TableSpec;
import org.apache.samza.table.utils.SerdeUtils;
import org.apache.samza.table.utils.descriptors.BaseTableProvider;

public abstract class BaseLocalStoreBackedTableProvider
extends BaseTableProvider {
    public static final Pattern SYSTEM_STREAM_NAME_PATTERN = Pattern.compile("[\\d\\w-_.]+");
    protected KeyValueStore kvStore;

    public BaseLocalStoreBackedTableProvider(TableSpec tableSpec) {
        super(tableSpec);
    }

    public void init(Context context) {
        super.init(context);
        Preconditions.checkNotNull((Object)this.context, (Object)"Must specify context for local tables.");
        this.kvStore = this.context.getTaskContext().getStore(this.tableSpec.getId());
        if (this.kvStore == null) {
            throw new SamzaException(String.format("Backing store for table %s was not injected by SamzaContainer", this.tableSpec.getId()));
        }
        this.logger.info("Initialized backing store for table " + this.tableSpec.getId());
    }

    public Table getTable() {
        if (this.kvStore == null) {
            throw new SamzaException("Store not initialized for table " + this.tableSpec.getId());
        }
        LocalStoreBackedReadWriteTable table = new LocalStoreBackedReadWriteTable(this.tableSpec.getId(), this.kvStore);
        table.init(this.context);
        return table;
    }

    protected Map<String, String> generateCommonStoreConfig(Config jobConfig, Map<String, String> generatedConfig) {
        Boolean enableChangelog;
        HashMap<String, String> storeConfig = new HashMap<String, String>();
        HashMap<String, String> mergedConfigMap = new HashMap<String, String>((Map<String, String>)jobConfig);
        mergedConfigMap.putAll(generatedConfig);
        JobConfig mergedJobConfig = new JobConfig((Config)new MapConfig(mergedConfigMap));
        JavaTableConfig tableConfig = new JavaTableConfig((Config)mergedJobConfig);
        String keySerde = tableConfig.getKeySerde(this.tableSpec.getId());
        storeConfig.put(String.format(StorageConfig.KEY_SERDE(), this.tableSpec.getId()), keySerde);
        String valueSerde = tableConfig.getValueSerde(this.tableSpec.getId());
        storeConfig.put(String.format(StorageConfig.MSG_SERDE(), this.tableSpec.getId()), valueSerde);
        List sideInputs = this.tableSpec.getSideInputs();
        if (sideInputs != null && !sideInputs.isEmpty()) {
            sideInputs.forEach(si -> Preconditions.checkState((boolean)this.isValidSystemStreamName((String)si), (Object)String.format("Side input stream %s doesn't confirm to pattern %s", si, SYSTEM_STREAM_NAME_PATTERN)));
            String formattedSideInputs = String.join((CharSequence)",", sideInputs);
            storeConfig.put(String.format("stores.%s.side.inputs", this.tableSpec.getId()), formattedSideInputs);
            storeConfig.put(String.format("stores.%s.side.inputs.processor.serialized.instance", this.tableSpec.getId()), SerdeUtils.serialize((String)"Side Inputs Processor", (Object)this.tableSpec.getSideInputsProcessor()));
        }
        if ((enableChangelog = Boolean.valueOf((String)this.tableSpec.getConfig().get("internal.enable.changelog"))).booleanValue()) {
            String changelogStream = (String)this.tableSpec.getConfig().get("internal.changelog.stream");
            if (StringUtils.isEmpty((CharSequence)changelogStream)) {
                changelogStream = String.format("%s-%s-table-%s", mergedJobConfig.getName().get(), mergedJobConfig.getJobId(), this.tableSpec.getId());
            }
            Preconditions.checkState((boolean)this.isValidSystemStreamName(changelogStream), (Object)String.format("Changelog stream %s doesn't confirm to pattern %s", changelogStream, SYSTEM_STREAM_NAME_PATTERN));
            storeConfig.put(String.format(StorageConfig.CHANGELOG_STREAM(), this.tableSpec.getId()), changelogStream);
            String changelogReplicationFactor = (String)this.tableSpec.getConfig().get("internal.changelog.replication.factor");
            if (changelogReplicationFactor != null) {
                storeConfig.put(String.format(StorageConfig.CHANGELOG_REPLICATION_FACTOR(), this.tableSpec.getId()), changelogReplicationFactor);
            }
        }
        return storeConfig;
    }

    public void close() {
        this.logger.info("Shutting down table provider for table " + this.tableSpec.getId());
    }

    private boolean isValidSystemStreamName(String name) {
        return StringUtils.isNotBlank((CharSequence)name) && SYSTEM_STREAM_NAME_PATTERN.matcher(name).matches();
    }
}

