/*
 * Decompiled with CFR 0.152.
 */
package org.apache.samza.storage.kv.descriptors;

import com.google.common.base.Preconditions;
import java.util.List;
import java.util.Map;
import org.apache.samza.serializers.KVSerde;
import org.apache.samza.storage.SideInputsProcessor;
import org.apache.samza.table.descriptors.BaseTableDescriptor;

public abstract class BaseLocalStoreBackedTableDescriptor<K, V, D extends BaseLocalStoreBackedTableDescriptor<K, V, D>>
extends BaseTableDescriptor<K, V, D> {
    public static final String INTERNAL_ENABLE_CHANGELOG = "internal.enable.changelog";
    public static final String INTERNAL_CHANGELOG_STREAM = "internal.changelog.stream";
    public static final String INTERNAL_CHANGELOG_REPLICATION_FACTOR = "internal.changelog.replication.factor";
    protected List<String> sideInputs;
    protected SideInputsProcessor sideInputsProcessor;
    protected boolean enableChangelog;
    protected String changelogStream;
    protected Integer changelogReplicationFactor;

    public BaseLocalStoreBackedTableDescriptor(String tableId) {
        super(tableId);
    }

    public BaseLocalStoreBackedTableDescriptor(String tableId, KVSerde<K, V> serde) {
        super(tableId, serde);
    }

    public D withSideInputs(List<String> sideInputs) {
        this.sideInputs = sideInputs;
        this.enableChangelog = false;
        this.changelogStream = null;
        this.changelogReplicationFactor = null;
        return (D)((Object)this);
    }

    public D withSideInputsProcessor(SideInputsProcessor sideInputsProcessor) {
        this.sideInputsProcessor = sideInputsProcessor;
        return (D)((Object)this);
    }

    public D withChangelogEnabled() {
        this.enableChangelog = true;
        return (D)((Object)this);
    }

    public D withChangelogStream(String changelogStream) {
        this.enableChangelog = true;
        this.changelogStream = changelogStream;
        return (D)((Object)this);
    }

    public D withChangelogReplicationFactor(int replicationFactor) {
        this.enableChangelog = true;
        this.changelogReplicationFactor = replicationFactor;
        return (D)((Object)this);
    }

    protected void generateTableSpecConfig(Map<String, String> tableSpecConfig) {
        super.generateTableSpecConfig(tableSpecConfig);
        tableSpecConfig.put(INTERNAL_ENABLE_CHANGELOG, String.valueOf(this.enableChangelog));
        if (this.enableChangelog) {
            if (this.changelogStream != null) {
                tableSpecConfig.put(INTERNAL_CHANGELOG_STREAM, this.changelogStream);
            }
            if (this.changelogReplicationFactor != null) {
                tableSpecConfig.put(INTERNAL_CHANGELOG_REPLICATION_FACTOR, String.valueOf(this.changelogReplicationFactor));
            }
        }
    }

    protected void validate() {
        super.validate();
        if (this.sideInputs != null || this.sideInputsProcessor != null) {
            Preconditions.checkArgument((this.sideInputs != null && !this.sideInputs.isEmpty() && this.sideInputsProcessor != null ? 1 : 0) != 0, (Object)String.format("Invalid side input configuration for table: %s. Both side inputs and the processor must be provided", this.tableId));
        }
        if (!this.enableChangelog) {
            Preconditions.checkState((this.changelogStream == null ? 1 : 0) != 0, (Object)String.format("Invalid changelog configuration for table: %s. Changelog must be enabled, when changelog stream name is provided", this.tableId));
            Preconditions.checkState((this.changelogReplicationFactor == null ? 1 : 0) != 0, (Object)String.format("Invalid changelog configuration for table: %s. Changelog must be enabled, when changelog replication factor is provided", this.tableId));
        }
    }
}

