/*
 * Decompiled with CFR 0.152.
 */
package org.apache.samza.storage.kv;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.samza.storage.kv.Entry;
import org.apache.samza.storage.kv.KeyValueIterator;
import org.apache.samza.storage.kv.KeyValueSnapshot;
import org.apache.samza.storage.kv.KeyValueStore;
import org.apache.samza.storage.kv.LoggedStore$;
import org.apache.samza.storage.kv.LoggedStoreMetrics;
import org.apache.samza.system.OutgoingMessageEnvelope;
import org.apache.samza.system.SystemStream;
import org.apache.samza.system.SystemStreamPartition;
import org.apache.samza.task.MessageCollector;
import org.apache.samza.util.Logging;
import org.slf4j.Logger;
import scala.Function0;
import scala.Serializable;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005me\u0001B\u0001\u0003\u00015\u00111\u0002T8hO\u0016$7\u000b^8sK*\u00111\u0001B\u0001\u0003WZT!!\u0002\u0004\u0002\u000fM$xN]1hK*\u0011q\u0001C\u0001\u0006g\u0006l'0\u0019\u0006\u0003\u0013)\ta!\u00199bG\",'\"A\u0006\u0002\u0007=\u0014xm\u0001\u0001\u0016\u00079i\"f\u0005\u0003\u0001\u001f]a\u0003C\u0001\t\u0016\u001b\u0005\t\"B\u0001\n\u0014\u0003\u0011a\u0017M\\4\u000b\u0003Q\tAA[1wC&\u0011a#\u0005\u0002\u0007\u001f\nTWm\u0019;\u0011\taI2$K\u0007\u0002\u0005%\u0011!D\u0001\u0002\u000e\u0017\u0016Lh+\u00197vKN#xN]3\u0011\u0005qiB\u0002\u0001\u0003\u0006=\u0001\u0011\ra\b\u0002\u0002\u0017F\u0011\u0001E\n\t\u0003C\u0011j\u0011A\t\u0006\u0002G\u0005)1oY1mC&\u0011QE\t\u0002\b\u001d>$\b.\u001b8h!\t\ts%\u0003\u0002)E\t\u0019\u0011I\\=\u0011\u0005qQC!B\u0016\u0001\u0005\u0004y\"!\u0001,\u0011\u00055\u0002T\"\u0001\u0018\u000b\u0005=2\u0011\u0001B;uS2L!!\r\u0018\u0003\u000f1{wmZ5oO\"A1\u0007\u0001BC\u0002\u0013\u0005A'A\u0003ti>\u0014X-F\u0001\u0018\u0011!1\u0004A!A!\u0002\u00139\u0012AB:u_J,\u0007\u0005\u0003\u00059\u0001\t\u0015\r\u0011\"\u0001:\u0003U\u0019\u0018p\u001d;f[N#(/Z1n!\u0006\u0014H/\u001b;j_:,\u0012A\u000f\t\u0003wyj\u0011\u0001\u0010\u0006\u0003{\u0019\taa]=ti\u0016l\u0017BA =\u0005U\u0019\u0016p\u001d;f[N#(/Z1n!\u0006\u0014H/\u001b;j_:D\u0001\"\u0011\u0001\u0003\u0002\u0003\u0006IAO\u0001\u0017gf\u001cH/Z7TiJ,\u0017-\u001c)beRLG/[8oA!A1\t\u0001BC\u0002\u0013\u0005A)A\u0005d_2dWm\u0019;peV\tQ\t\u0005\u0002G\u00136\tqI\u0003\u0002I\r\u0005!A/Y:l\u0013\tQuI\u0001\tNKN\u001c\u0018mZ3D_2dWm\u0019;pe\"AA\n\u0001B\u0001B\u0003%Q)\u0001\u0006d_2dWm\u0019;pe\u0002B\u0001B\u0014\u0001\u0003\u0006\u0004%\taT\u0001\b[\u0016$(/[2t+\u0005\u0001\u0006C\u0001\rR\u0013\t\u0011&A\u0001\nM_\u001e<W\rZ*u_J,W*\u001a;sS\u000e\u001c\b\u0002\u0003+\u0001\u0005\u0003\u0005\u000b\u0011\u0002)\u0002\u00115,GO]5dg\u0002BQA\u0016\u0001\u0005\u0002]\u000ba\u0001P5oSRtD#\u0002-Z5nc\u0006\u0003\u0002\r\u00017%BQaM+A\u0002]AQ\u0001O+A\u0002iBQaQ+A\u0002\u0015CqAT+\u0011\u0002\u0003\u0007\u0001\u000bC\u0004_\u0001\t\u0007I\u0011A0\u0002\u0019ML8\u000f^3n'R\u0014X-Y7\u0016\u0003\u0001\u0004\"aO1\n\u0005\td$\u0001D*zgR,Wn\u0015;sK\u0006l\u0007B\u00023\u0001A\u0003%\u0001-A\u0007tsN$X-\\*ue\u0016\fW\u000e\t\u0005\bM\u0002\u0011\r\u0011\"\u0001h\u0003-\u0001\u0018M\u001d;ji&|g.\u00133\u0016\u0003!\u0004\"!I5\n\u0005)\u0014#aA%oi\"1A\u000e\u0001Q\u0001\n!\fA\u0002]1si&$\u0018n\u001c8JI\u0002BQA\u001c\u0001\u0005\u0002=\f1aZ3u)\tI\u0003\u000fC\u0003r[\u0002\u00071$A\u0002lKfDQa\u001d\u0001\u0005BQ\faaZ3u\u00032dGCA;{!\u00111\bpG\u0015\u000e\u0003]T!aL\n\n\u0005e<(aA'ba\")1P\u001da\u0001y\u0006!1.Z=t!\r1XpG\u0005\u0003}^\u0014A\u0001T5ti\"9\u0011\u0011\u0001\u0001\u0005\u0002\u0005\r\u0011!\u0002:b]\u001e,GCBA\u0003\u0003\u0017\ty\u0001E\u0003\u0019\u0003\u000fY\u0012&C\u0002\u0002\n\t\u0011\u0001cS3z-\u0006dW/Z%uKJ\fGo\u001c:\t\r\u00055q\u00101\u0001\u001c\u0003\u00111'o\\7\t\r\u0005Eq\u00101\u0001\u001c\u0003\t!x\u000eC\u0004\u0002\u0016\u0001!\t!a\u0006\u0002\u0007\u0005dG\u000e\u0006\u0002\u0002\u0006!9\u00111\u0004\u0001\u0005\u0002\u0005u\u0011a\u00019viR1\u0011qDA\u0013\u0003O\u00012!IA\u0011\u0013\r\t\u0019C\t\u0002\u0005+:LG\u000f\u0003\u0004r\u00033\u0001\ra\u0007\u0005\b\u0003S\tI\u00021\u0001*\u0003\u00151\u0018\r\\;f\u0011\u001d\ti\u0003\u0001C\u0001\u0003_\ta\u0001];u\u00032dG\u0003BA\u0010\u0003cA\u0001\"a\r\u0002,\u0001\u0007\u0011QG\u0001\bK:$(/[3t!\u00111X0a\u000e\u0011\u000ba\tIdG\u0015\n\u0007\u0005m\"AA\u0003F]R\u0014\u0018\u0010C\u0004\u0002@\u0001!\t!!\u0011\u0002\r\u0011,G.\u001a;f)\u0011\ty\"a\u0011\t\rE\fi\u00041\u0001\u001c\u0011\u001d\t9\u0005\u0001C!\u0003\u0013\n\u0011\u0002Z3mKR,\u0017\t\u001c7\u0015\t\u0005}\u00111\n\u0005\u0007w\u0006\u0015\u0003\u0019\u0001?\t\u000f\u0005=\u0003\u0001\"\u0001\u0002R\u0005)a\r\\;tQR\u0011\u0011q\u0004\u0005\b\u0003+\u0002A\u0011AA)\u0003\u0015\u0019Gn\\:f\u0011\u001d\tI\u0006\u0001C!\u00037\n\u0001b\u001d8baNDw\u000e\u001e\u000b\u0007\u0003;\n\u0019'!\u001a\u0011\u000ba\tyfG\u0015\n\u0007\u0005\u0005$A\u0001\tLKf4\u0016\r\\;f':\f\u0007o\u001d5pi\"9\u0011QBA,\u0001\u0004Y\u0002bBA\t\u0003/\u0002\raG\u0004\n\u0003S\u0012\u0011\u0011!E\u0001\u0003W\n1\u0002T8hO\u0016$7\u000b^8sKB\u0019\u0001$!\u001c\u0007\u0011\u0005\u0011\u0011\u0011!E\u0001\u0003_\u001aB!!\u001c\u0002rA\u0019\u0011%a\u001d\n\u0007\u0005U$E\u0001\u0004B]f\u0014VM\u001a\u0005\b-\u00065D\u0011AA=)\t\tY\u0007\u0003\u0006\u0002~\u00055\u0014\u0013!C\u0001\u0003\u007f\n1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012\"TCBAA\u0003/\u000bI*\u0006\u0002\u0002\u0004*\u001a\u0001+!\",\u0005\u0005\u001d\u0005\u0003BAE\u0003'k!!a#\u000b\t\u00055\u0015qR\u0001\nk:\u001c\u0007.Z2lK\u0012T1!!%#\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003+\u000bYIA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016$aAHA>\u0005\u0004yBAB\u0016\u0002|\t\u0007q\u0004")
public class LoggedStore<K, V>
implements KeyValueStore<K, V>,
Logging {
    private final KeyValueStore<K, V> store;
    private final SystemStreamPartition systemStreamPartition;
    private final MessageCollector collector;
    private final LoggedStoreMetrics metrics;
    private final SystemStream systemStream;
    private final int partitionId;
    private final String loggerName;
    private final Logger logger;
    private final String startupLoggerName;
    private final Logger startupLogger;
    private volatile byte bitmap$0;

    public static <K, V> LoggedStoreMetrics $lessinit$greater$default$4() {
        return LoggedStore$.MODULE$.$lessinit$greater$default$4();
    }

    public String loggerName() {
        return this.loggerName;
    }

    private Logger logger$lzycompute() {
        LoggedStore loggedStore = this;
        synchronized (loggedStore) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.logger = Logging.class.logger((Logging)this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.logger$lzycompute() : this.logger;
    }

    public String startupLoggerName() {
        return this.startupLoggerName;
    }

    private Logger startupLogger$lzycompute() {
        LoggedStore loggedStore = this;
        synchronized (loggedStore) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.startupLogger = Logging.class.startupLogger((Logging)this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
            return this.startupLogger;
        }
    }

    public Logger startupLogger() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.startupLogger$lzycompute() : this.startupLogger;
    }

    public void org$apache$samza$util$Logging$_setter_$loggerName_$eq(String x$1) {
        this.loggerName = x$1;
    }

    public void org$apache$samza$util$Logging$_setter_$startupLoggerName_$eq(String x$1) {
        this.startupLoggerName = x$1;
    }

    public void startupLog(Function0<Object> message) {
        Logging.class.startupLog((Logging)this, message);
    }

    public void trace(Function0<Object> message) {
        Logging.class.trace((Logging)this, message);
    }

    public void trace(Function0<Object> message, Function0<Throwable> e) {
        Logging.class.trace((Logging)this, message, e);
    }

    public void debug(Function0<Object> message) {
        Logging.class.debug((Logging)this, message);
    }

    public void debug(Function0<Object> message, Function0<Throwable> e) {
        Logging.class.debug((Logging)this, message, e);
    }

    public void info(Function0<Object> message) {
        Logging.class.info((Logging)this, message);
    }

    public void info(Function0<Object> message, Function0<Throwable> e) {
        Logging.class.info((Logging)this, message, e);
    }

    public void warn(Function0<Object> message) {
        Logging.class.warn((Logging)this, message);
    }

    public void warn(Function0<Object> message, Function0<Throwable> e) {
        Logging.class.warn((Logging)this, message, e);
    }

    public void error(Function0<Object> message) {
        Logging.class.error((Logging)this, message);
    }

    public void error(Function0<Object> message, Function0<Throwable> e) {
        Logging.class.error((Logging)this, message, e);
    }

    public void putMDC(Function0<String> key, Function0<String> value) {
        Logging.class.putMDC((Logging)this, key, value);
    }

    public String getMDC(Function0<String> key) {
        return Logging.class.getMDC((Logging)this, key);
    }

    public void removeMDC(Function0<String> key) {
        Logging.class.removeMDC((Logging)this, key);
    }

    public void clearMDC() {
        Logging.class.clearMDC((Logging)this);
    }

    public KeyValueStore<K, V> store() {
        return this.store;
    }

    public SystemStreamPartition systemStreamPartition() {
        return this.systemStreamPartition;
    }

    public MessageCollector collector() {
        return this.collector;
    }

    public LoggedStoreMetrics metrics() {
        return this.metrics;
    }

    public SystemStream systemStream() {
        return this.systemStream;
    }

    public int partitionId() {
        return this.partitionId;
    }

    public V get(K key) {
        this.metrics().gets().inc();
        return (V)this.store().get(key);
    }

    public Map<K, V> getAll(List<K> keys) {
        this.metrics().gets().inc((long)keys.size());
        return this.store().getAll(keys);
    }

    public KeyValueIterator<K, V> range(K from, K to) {
        this.metrics().ranges().inc();
        return this.store().range(from, to);
    }

    public KeyValueIterator<K, V> all() {
        this.metrics().alls().inc();
        return this.store().all();
    }

    public void put(K key, V value) {
        this.metrics().puts().inc();
        this.collector().send(new OutgoingMessageEnvelope(this.systemStream(), (Object)BoxesRunTime.boxToInteger((int)this.partitionId()), key, value));
        this.store().put(key, value);
    }

    public void putAll(List<Entry<K, V>> entries) {
        this.metrics().puts().inc((long)entries.size());
        for (Entry<K, V> curr : entries) {
            this.collector().send(new OutgoingMessageEnvelope(this.systemStream(), (Object)BoxesRunTime.boxToInteger((int)this.partitionId()), curr.getKey(), curr.getValue()));
        }
        this.store().putAll(entries);
    }

    public void delete(K key) {
        this.metrics().deletes().inc();
        this.collector().send(new OutgoingMessageEnvelope(this.systemStream(), (Object)BoxesRunTime.boxToInteger((int)this.partitionId()), key, null));
        this.store().delete(key);
    }

    public void deleteAll(List<K> keys) {
        this.metrics().deletes().inc((long)keys.size());
        Iterator<K> keysIterator = keys.iterator();
        while (keysIterator.hasNext()) {
            this.collector().send(new OutgoingMessageEnvelope(this.systemStream(), (Object)BoxesRunTime.boxToInteger((int)this.partitionId()), keysIterator.next(), null));
        }
        this.store().deleteAll(keys);
    }

    public void flush() {
        this.trace((Function0<Object>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Flushing store.";
            }
        });
        this.metrics().flushes().inc();
        this.store().flush();
        this.trace((Function0<Object>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Flushed store.";
            }
        });
    }

    public void close() {
        this.trace((Function0<Object>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Closing.";
            }
        });
        this.store().close();
    }

    public KeyValueSnapshot<K, V> snapshot(K from, K to) {
        return this.store().snapshot(from, to);
    }

    public LoggedStore(KeyValueStore<K, V> store, SystemStreamPartition systemStreamPartition, MessageCollector collector, LoggedStoreMetrics metrics) {
        this.store = store;
        this.systemStreamPartition = systemStreamPartition;
        this.collector = collector;
        this.metrics = metrics;
        Logging.class.$init$((Logging)this);
        this.systemStream = systemStreamPartition.getSystemStream();
        this.partitionId = systemStreamPartition.getPartition().getPartitionId();
    }
}

