/*
 * Decompiled with CFR 0.152.
 */
package org.apache.samza.storage.kv;

import com.google.common.base.Preconditions;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.apache.samza.context.Context;
import org.apache.samza.storage.kv.KeyValueStore;
import org.apache.samza.table.ReadableTable;
import org.apache.samza.table.Table;
import org.apache.samza.table.utils.DefaultTableReadMetrics;

public class LocalStoreBackedReadableTable<K, V>
implements ReadableTable<K, V> {
    protected final KeyValueStore<K, V> kvStore;
    protected final String tableId;
    protected DefaultTableReadMetrics readMetrics;

    public LocalStoreBackedReadableTable(String tableId, KeyValueStore<K, V> kvStore) {
        Preconditions.checkArgument((boolean)(tableId != null & !tableId.isEmpty()), (Object)"invalid tableId");
        Preconditions.checkNotNull(kvStore, (Object)"null KeyValueStore");
        this.tableId = tableId;
        this.kvStore = kvStore;
    }

    public void init(Context context) {
        this.readMetrics = new DefaultTableReadMetrics(context, (Table)this, this.tableId);
    }

    public V get(K key) {
        this.readMetrics.numGets.inc();
        long startNs = System.nanoTime();
        Object result = this.kvStore.get(key);
        this.readMetrics.getNs.update(System.nanoTime() - startNs);
        return (V)result;
    }

    public CompletableFuture<V> getAsync(K key) {
        CompletableFuture<V> future = new CompletableFuture<V>();
        try {
            future.complete(this.get(key));
        }
        catch (Exception e) {
            future.completeExceptionally(e);
        }
        return future;
    }

    public Map<K, V> getAll(List<K> keys) {
        this.readMetrics.numGetAlls.inc();
        long startNs = System.nanoTime();
        Map result = this.kvStore.getAll(keys);
        this.readMetrics.getAllNs.update(System.nanoTime() - startNs);
        return result;
    }

    public CompletableFuture<Map<K, V>> getAllAsync(List<K> keys) {
        CompletableFuture<Map<K, V>> future = new CompletableFuture<Map<K, V>>();
        try {
            future.complete(this.getAll(keys));
        }
        catch (Exception e) {
            future.completeExceptionally(e);
        }
        return future;
    }

    public void close() {
    }
}

