/*
 * Decompiled with CFR 0.152.
 */
package org.apache.samza.storage.kv;

import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.apache.samza.context.Context;
import org.apache.samza.storage.kv.Entry;
import org.apache.samza.storage.kv.KeyValueStore;
import org.apache.samza.storage.kv.LocalStoreBackedReadableTable;
import org.apache.samza.table.ReadWriteTable;
import org.apache.samza.table.Table;
import org.apache.samza.table.utils.DefaultTableWriteMetrics;

public class LocalStoreBackedReadWriteTable<K, V>
extends LocalStoreBackedReadableTable<K, V>
implements ReadWriteTable<K, V> {
    protected DefaultTableWriteMetrics writeMetrics;

    public LocalStoreBackedReadWriteTable(String tableId, KeyValueStore kvStore) {
        super(tableId, kvStore);
    }

    @Override
    public void init(Context context) {
        super.init(context);
        this.writeMetrics = new DefaultTableWriteMetrics(context, (Table)this, this.tableId);
    }

    public void put(K key, V value) {
        if (value != null) {
            this.writeMetrics.numPuts.inc();
            long startNs = System.nanoTime();
            this.kvStore.put(key, value);
            this.writeMetrics.putNs.update(System.nanoTime() - startNs);
        } else {
            this.delete(key);
        }
    }

    public CompletableFuture<Void> putAsync(K key, V value) {
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        try {
            this.put(key, value);
            future.complete(null);
        }
        catch (Exception e) {
            future.completeExceptionally(e);
        }
        return future;
    }

    public void putAll(List<Entry<K, V>> entries) {
        this.writeMetrics.numPutAlls.inc();
        long startNs = System.nanoTime();
        this.kvStore.putAll(entries);
        this.writeMetrics.putAllNs.update(System.nanoTime() - startNs);
    }

    public CompletableFuture<Void> putAllAsync(List<Entry<K, V>> entries) {
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        try {
            this.putAll(entries);
            future.complete(null);
        }
        catch (Exception e) {
            future.completeExceptionally(e);
        }
        return future;
    }

    public void delete(K key) {
        this.writeMetrics.numDeletes.inc();
        long startNs = System.nanoTime();
        this.kvStore.delete(key);
        this.writeMetrics.deleteNs.update(System.nanoTime() - startNs);
    }

    public CompletableFuture<Void> deleteAsync(K key) {
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        try {
            this.delete(key);
            future.complete(null);
        }
        catch (Exception e) {
            future.completeExceptionally(e);
        }
        return future;
    }

    public void deleteAll(List<K> keys) {
        this.writeMetrics.numDeleteAlls.inc();
        long startNs = System.nanoTime();
        this.kvStore.deleteAll(keys);
        this.writeMetrics.deleteAllNs.update(System.nanoTime() - startNs);
    }

    public CompletableFuture<Void> deleteAllAsync(List<K> keys) {
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        try {
            this.deleteAll(keys);
            future.complete(null);
        }
        catch (Exception e) {
            future.completeExceptionally(e);
        }
        return future;
    }

    public void flush() {
        this.writeMetrics.numFlushes.inc();
        long startNs = System.nanoTime();
        this.kvStore.flush();
        this.writeMetrics.flushNs.update(System.nanoTime() - startNs);
    }
}

