/*
 * Decompiled with CFR 0.152.
 */
package org.apache.samza.storage.kv;

import java.io.File;
import org.apache.samza.SamzaException;
import org.apache.samza.config.Config;
import org.apache.samza.config.MetricsConfig$;
import org.apache.samza.config.StorageConfig$;
import org.apache.samza.context.ContainerContext;
import org.apache.samza.context.JobContext;
import org.apache.samza.metrics.MetricsRegistry;
import org.apache.samza.serializers.Serde;
import org.apache.samza.storage.StorageEngine;
import org.apache.samza.storage.StoreProperties;
import org.apache.samza.storage.kv.AccessLoggedStore;
import org.apache.samza.storage.kv.BaseKeyValueStorageEngineFactory;
import org.apache.samza.storage.kv.CachedStore;
import org.apache.samza.storage.kv.CachedStoreMetrics;
import org.apache.samza.storage.kv.KeyValueStorageEngine;
import org.apache.samza.storage.kv.KeyValueStorageEngineMetrics;
import org.apache.samza.storage.kv.KeyValueStore;
import org.apache.samza.storage.kv.LoggedStore;
import org.apache.samza.storage.kv.LoggedStoreMetrics;
import org.apache.samza.storage.kv.NullSafeKeyValueStore;
import org.apache.samza.storage.kv.SerializedKeyValueStore;
import org.apache.samza.storage.kv.SerializedKeyValueStoreMetrics;
import org.apache.samza.system.SystemStreamPartition;
import org.apache.samza.task.MessageCollector;
import org.apache.samza.util.HighResolutionClock;
import scala.Function0;
import scala.Serializable;
import scala.collection.mutable.StringBuilder;
import scala.math.package$;

public abstract class BaseKeyValueStorageEngineFactory$class {
    public static StorageEngine getStorageEngine(BaseKeyValueStorageEngineFactory $this, String storeName, File storeDir, Serde keySerde, Serde msgSerde, MessageCollector collector, MetricsRegistry registry, SystemStreamPartition changeLogSystemStreamPartition, JobContext jobContext, ContainerContext containerContext) {
        Object object;
        LoggedStore<byte[], byte[]> loggedStore;
        int batchSize;
        int cacheSize;
        boolean enableCache;
        Config storageConfig = jobContext.getConfig().subset(new StringBuilder().append((Object)"stores.").append((Object)storeName).append((Object)".").toString(), true);
        String storeFactory = (String)storageConfig.get((Object)"factory");
        StoreProperties.StorePropertiesBuilder storePropertiesBuilder = new StoreProperties.StorePropertiesBuilder();
        boolean accessLog = storageConfig.getBoolean("accesslog.enabled", false);
        if (storeFactory == null) {
            throw new SamzaException("Store factory not defined. Cannot proceed with KV store creation!");
        }
        if (!storeFactory.equals($this.org$apache$samza$storage$kv$BaseKeyValueStorageEngineFactory$$INMEMORY_KV_STORAGE_ENGINE_FACTORY())) {
            storePropertiesBuilder = storePropertiesBuilder.setPersistedToDisk(true);
        }
        boolean bl = enableCache = (cacheSize = storageConfig.getInt("object.cache.size", package$.MODULE$.max(batchSize = storageConfig.getInt("write.batch.size", 500), 1000))) > 0;
        if (cacheSize > 0 && cacheSize < batchSize) {
            throw new SamzaException("A store's cache.size cannot be less than batch.size as batched values reside in cache.");
        }
        if (keySerde == null) {
            throw new SamzaException("Must define a key serde when using key value storage.");
        }
        if (msgSerde == null) {
            throw new SamzaException("Must define a message serde when using key value storage.");
        }
        LoggedStore<byte[], byte[]> rawStore = $this.getKVStore(storeName, storeDir, registry, changeLogSystemStreamPartition, jobContext, containerContext);
        if (changeLogSystemStreamPartition == null) {
            loggedStore = rawStore;
        } else {
            LoggedStoreMetrics loggedStoreMetrics = new LoggedStoreMetrics(storeName, registry);
            storePropertiesBuilder = storePropertiesBuilder.setLoggedStore(true);
            loggedStore = new LoggedStore<byte[], byte[]>(rawStore, changeLogSystemStreamPartition, collector, loggedStoreMetrics);
        }
        LoggedStore<byte[], byte[]> maybeLoggedStore = loggedStore;
        SerializedKeyValueStoreMetrics serializedMetrics = new SerializedKeyValueStoreMetrics(storeName, registry);
        SerializedKeyValueStore serialized = new SerializedKeyValueStore((KeyValueStore<byte[], byte[]>)maybeLoggedStore, keySerde, msgSerde, serializedMetrics);
        if (enableCache) {
            CachedStoreMetrics cachedStoreMetrics = new CachedStoreMetrics(storeName, registry);
            object = new CachedStore(serialized, cacheSize, batchSize, cachedStoreMetrics);
        } else {
            object = serialized;
        }
        SerializedKeyValueStore maybeCachedStore = object;
        Object maybeAccessLoggedStore = accessLog ? new AccessLoggedStore(maybeCachedStore, collector, changeLogSystemStreamPartition, StorageConfig$.MODULE$.Config2Storage(storageConfig), storeName, keySerde) : maybeCachedStore;
        NullSafeKeyValueStore nullSafeStore = new NullSafeKeyValueStore(maybeAccessLoggedStore);
        KeyValueStorageEngineMetrics keyValueStorageEngineMetrics = new KeyValueStorageEngineMetrics(storeName, registry);
        Object clock = MetricsConfig$.MODULE$.Config2Metrics(jobContext.getConfig()).getMetricsTimerEnabled() ? new HighResolutionClock($this){

            public long nanoTime() {
                return System.nanoTime();
            }
        } : new HighResolutionClock($this){

            public long nanoTime() {
                return 0L;
            }
        };
        return new KeyValueStorageEngine(storeName, storeDir, storePropertiesBuilder.build(), nullSafeStore, rawStore, keyValueStorageEngineMetrics, batchSize, (Function0<Object>)new Serializable($this, clock){
            public static final long serialVersionUID = 0L;
            private final HighResolutionClock clock$1;

            public final long apply() {
                return this.apply$mcJ$sp();
            }

            public long apply$mcJ$sp() {
                return this.clock$1.nanoTime();
            }
            {
                this.clock$1 = clock$1;
            }
        });
    }

    public static void $init$(BaseKeyValueStorageEngineFactory $this) {
        $this.org$apache$samza$storage$kv$BaseKeyValueStorageEngineFactory$_setter_$org$apache$samza$storage$kv$BaseKeyValueStorageEngineFactory$$INMEMORY_KV_STORAGE_ENGINE_FACTORY_$eq("org.apache.samza.storage.kv.inmemory.InMemoryKeyValueStorageEngineFactory");
    }
}

