/*
 * Decompiled with CFR 0.152.
 */
package org.apache.samza.zk;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.samza.coordinator.Latch;
import org.apache.samza.zk.ZkKeyBuilder;
import org.apache.samza.zk.ZkUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZkProcessorLatch
implements Latch {
    private static final Logger LOG = LoggerFactory.getLogger(ZkProcessorLatch.class);
    private final ZkUtils zkUtils;
    private final String participantId;
    private final String latchPath;
    private final String targetPath;
    public static final String LATCH_PATH = "latch";

    public ZkProcessorLatch(int size, String latchId, String participantId, ZkUtils zkUtils) {
        this.zkUtils = zkUtils;
        this.participantId = participantId;
        ZkKeyBuilder keyBuilder = this.zkUtils.getKeyBuilder();
        this.latchPath = String.format("%s/%s", keyBuilder.getRootPath(), "latch_" + latchId);
        zkUtils.validatePaths(new String[]{this.latchPath});
        this.targetPath = String.format("%s/%010d", this.latchPath, size - 1);
        LOG.debug("ZkProcessorLatch targetPath " + this.targetPath);
    }

    @Override
    public void await(long timeout, TimeUnit timeUnit) throws TimeoutException {
        boolean targetPathExists = this.zkUtils.getZkClient().waitUntilExists(this.targetPath, timeUnit, timeout);
        if (!targetPathExists) {
            throw new TimeoutException("Timed out waiting for the targetPath");
        }
    }

    @Override
    public void countDown() {
        String path = this.zkUtils.getZkClient().createPersistentSequential(this.latchPath + "/", (Object)this.participantId);
        LOG.debug("ZKProcessorLatch countDown created " + path);
    }
}

