/*
 * Decompiled with CFR 0.152.
 */
package org.apache.samza.zk;

import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.I0Itec.zkclient.ZkClient;
import org.I0Itec.zkclient.serialize.BytesPushThroughSerializer;
import org.I0Itec.zkclient.serialize.ZkSerializer;
import org.apache.samza.SamzaException;
import org.apache.samza.config.Config;
import org.apache.samza.config.ZkConfig;
import org.apache.samza.metadatastore.MetadataStore;
import org.apache.samza.metrics.MetricsRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZkMetadataStore
implements MetadataStore {
    private static final Logger LOG = LoggerFactory.getLogger(ZkMetadataStore.class);
    private final ZkClient zkClient;
    private final ZkConfig zkConfig;
    private final String zkBaseDir;

    public ZkMetadataStore(String zkBaseDir, Config config, MetricsRegistry metricsRegistry) {
        this.zkConfig = new ZkConfig(config);
        this.zkClient = new ZkClient(this.zkConfig.getZkConnect(), this.zkConfig.getZkSessionTimeoutMs(), this.zkConfig.getZkConnectionTimeoutMs(), (ZkSerializer)new BytesPushThroughSerializer());
        this.zkBaseDir = zkBaseDir;
        this.zkClient.createPersistent(zkBaseDir, true);
    }

    public void init() {
        this.zkClient.waitUntilConnected((long)this.zkConfig.getZkConnectionTimeoutMs(), TimeUnit.MILLISECONDS);
    }

    public byte[] get(byte[] key) {
        return (byte[])this.zkClient.readData(this.getZkPathForKey(key), true);
    }

    public void put(byte[] key, byte[] value) {
        String zkPath = this.getZkPathForKey(key);
        this.zkClient.createPersistent(zkPath, true);
        this.zkClient.writeData(zkPath, (Object)value);
    }

    public void delete(byte[] key) {
        this.zkClient.delete(this.getZkPathForKey(key));
    }

    public Map<byte[], byte[]> all() {
        try {
            List zkSubDirectories = this.zkClient.getChildren(this.zkBaseDir);
            HashMap<byte[], byte[]> result = new HashMap<byte[], byte[]>();
            for (String zkSubDir : zkSubDirectories) {
                String completeZkPath = String.format("%s/%s", this.zkBaseDir, zkSubDir);
                byte[] value = (byte[])this.zkClient.readData(completeZkPath, true);
                if (value == null) continue;
                result.put(completeZkPath.getBytes("UTF-8"), value);
            }
            return result;
        }
        catch (Exception e) {
            String errorMsg = String.format("Error reading path: %s from zookeeper.", this.zkBaseDir);
            LOG.error(errorMsg, (Throwable)e);
            throw new SamzaException(errorMsg, (Throwable)e);
        }
    }

    public void flush() {
    }

    public void close() {
        this.zkClient.close();
    }

    private String getZkPathForKey(byte[] key) {
        return String.format("%s/%s", this.zkBaseDir, new String(key, Charset.forName("UTF-8")));
    }
}

