/*
 * Decompiled with CFR 0.152.
 */
package org.apache.samza.zk;

import com.google.common.annotations.VisibleForTesting;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import java.util.concurrent.atomic.AtomicBoolean;
import org.I0Itec.zkclient.IZkDataListener;
import org.apache.samza.SamzaException;
import org.apache.samza.coordinator.LeaderElector;
import org.apache.samza.coordinator.LeaderElectorListener;
import org.apache.samza.zk.ProcessorData;
import org.apache.samza.zk.ZkKeyBuilder;
import org.apache.samza.zk.ZkUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZkLeaderElector
implements LeaderElector {
    public static final Logger LOG = LoggerFactory.getLogger(ZkLeaderElector.class);
    private final ZkUtils zkUtils;
    private final String processorIdStr;
    private final ZkKeyBuilder keyBuilder;
    private final String hostName;
    private AtomicBoolean isLeader = new AtomicBoolean(false);
    private IZkDataListener previousProcessorChangeListener;
    private LeaderElectorListener leaderElectorListener = null;
    private String currentSubscription = null;
    private final Random random = new Random();

    public ZkLeaderElector(String processorIdStr, ZkUtils zkUtils) {
        this.processorIdStr = processorIdStr;
        this.zkUtils = zkUtils;
        this.keyBuilder = zkUtils.getKeyBuilder();
        this.hostName = this.getHostName();
        this.previousProcessorChangeListener = new PreviousProcessorChangeListener(zkUtils);
        zkUtils.validatePaths(new String[]{this.keyBuilder.getProcessorsPath()});
    }

    @VisibleForTesting
    public ZkLeaderElector(String processorIdStr, ZkUtils zkUtils, IZkDataListener previousProcessorChangeListener) {
        this.processorIdStr = processorIdStr;
        this.zkUtils = zkUtils;
        this.keyBuilder = zkUtils.getKeyBuilder();
        this.hostName = this.getHostName();
        this.previousProcessorChangeListener = previousProcessorChangeListener;
    }

    private String getHostName() {
        try {
            return InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            LOG.error("Failed to fetch hostname of the processor", (Throwable)e);
            throw new SamzaException((Throwable)e);
        }
    }

    @Override
    public void setLeaderElectorListener(LeaderElectorListener listener) {
        this.leaderElectorListener = listener;
    }

    @Override
    public void tryBecomeLeader() {
        boolean predecessorExists;
        String currentPath = this.zkUtils.registerProcessorAndGetId(new ProcessorData(this.hostName, this.processorIdStr));
        List<String> children = this.zkUtils.getSortedActiveProcessorsZnodes();
        LOG.debug(this.zLog("Current active processors - " + children));
        int index = children.indexOf(ZkKeyBuilder.parseIdFromPath(currentPath));
        LOG.info("tryBecomeLeader: index = " + index + " for path=" + currentPath + " out of " + Arrays.toString(children.toArray()));
        if (children.size() == 0 || index == -1) {
            throw new SamzaException("Looks like we are no longer connected to Zk. Need to reconnect!");
        }
        if (index == 0) {
            this.isLeader.getAndSet(true);
            LOG.info(this.zLog("Eligible to become the leader!"));
            if (this.leaderElectorListener != null) {
                this.leaderElectorListener.onBecomingLeader();
            }
            return;
        }
        this.isLeader.getAndSet(false);
        LOG.info("Index = " + index + " Not eligible to be a leader yet!");
        String predecessor = children.get(index - 1);
        if (!predecessor.equals(this.currentSubscription)) {
            if (this.currentSubscription != null) {
                LOG.debug(this.zLog("Unsubscribing data change for " + this.currentSubscription));
                this.zkUtils.unsubscribeDataChanges(this.keyBuilder.getProcessorsPath() + "/" + this.currentSubscription, this.previousProcessorChangeListener);
                this.previousProcessorChangeListener = new PreviousProcessorChangeListener(this.zkUtils);
            }
            this.currentSubscription = predecessor;
            LOG.info(this.zLog("Subscribing data change for " + predecessor));
            this.zkUtils.subscribeDataChanges(this.keyBuilder.getProcessorsPath() + "/" + this.currentSubscription, this.previousProcessorChangeListener);
        }
        if (predecessorExists = this.zkUtils.exists(this.keyBuilder.getProcessorsPath() + "/" + this.currentSubscription)) {
            LOG.info(this.zLog("Predecessor still exists. Current subscription is valid. Continuing as non-leader."));
        } else {
            try {
                Thread.sleep(this.random.nextInt(1000));
            }
            catch (InterruptedException e) {
                Thread.interrupted();
            }
            LOG.info(this.zLog("Predecessor doesn't exist anymore. Trying to become leader again..."));
            this.tryBecomeLeader();
        }
    }

    @Override
    public void resignLeadership() {
        this.isLeader.compareAndSet(true, false);
    }

    @Override
    public boolean amILeader() {
        return this.isLeader.get();
    }

    private String zLog(String logMessage) {
        return String.format("[Processor-%s] %s", this.processorIdStr, logMessage);
    }

    class PreviousProcessorChangeListener
    extends ZkUtils.GenerationAwareZkDataListener {
        public PreviousProcessorChangeListener(ZkUtils zkUtils) {
            super(zkUtils, "PreviousProcessorChangeListener");
        }

        @Override
        public void doHandleDataChange(String dataPath, Object data) {
            LOG.info("Data change on path: {} for data: {}", (Object)dataPath, data);
        }

        @Override
        public void doHandleDataDeleted(String dataPath) {
            LOG.info(ZkLeaderElector.this.zLog("Data deleted on path " + dataPath + ". Predecessor went away. So, trying to become leader."));
            ZkLeaderElector.this.tryBecomeLeader();
        }
    }
}

