/*
 * Decompiled with CFR 0.152.
 */
package org.apache.samza.zk;

import com.google.common.base.Strings;

public class ZkKeyBuilder {
    static final String PROCESSORS_PATH = "processors";
    static final String JOBMODEL_GENERATION_PATH = "jobModelGeneration";
    static final String JOB_MODEL_UPGRADE_BARRIER_PATH = "jobModelUpgradeBarrier";
    private static final String TASK_LOCALITY_PATH = "taskLocality";
    private final String pathPrefix;

    public ZkKeyBuilder(String pathPrefix) {
        if (pathPrefix == null || pathPrefix.trim().isEmpty()) {
            throw new IllegalArgumentException("Zk PathPrefix cannot be null or empty!");
        }
        this.pathPrefix = pathPrefix.trim();
    }

    String getRootPath() {
        return "/" + this.pathPrefix;
    }

    String getProcessorsPath() {
        return String.format("/%s/%s", this.pathPrefix, PROCESSORS_PATH);
    }

    static String parseIdFromPath(String path) {
        if (!Strings.isNullOrEmpty((String)path)) {
            return path.substring(path.lastIndexOf("/") + 1);
        }
        return null;
    }

    String getJobModelVersionPath() {
        return String.format("%s/%s/jobModelVersion", this.getRootPath(), JOBMODEL_GENERATION_PATH);
    }

    String getJobModelPathPrefix() {
        return String.format("%s/%s/jobModels", this.getRootPath(), JOBMODEL_GENERATION_PATH);
    }

    String getJobModelPath(String jobModelVersion) {
        return String.format("%s/%s", this.getJobModelPathPrefix(), jobModelVersion);
    }

    String getJobModelVersionBarrierPrefix() {
        return String.format("%s/%s/%s/versionBarriers", this.getRootPath(), JOBMODEL_GENERATION_PATH, JOB_MODEL_UPGRADE_BARRIER_PATH);
    }

    String getTaskLocalityPath() {
        return String.format("%s/%s", this.getRootPath(), TASK_LOCALITY_PATH);
    }
}

