/*
 * Decompiled with CFR 0.152.
 */
package org.apache.samza.zk;

import org.I0Itec.zkclient.ZkClient;
import org.apache.samza.config.ApplicationConfig;
import org.apache.samza.config.Config;
import org.apache.samza.config.JobConfig;
import org.apache.samza.config.ZkConfig;
import org.apache.samza.coordinator.JobCoordinator;
import org.apache.samza.coordinator.JobCoordinatorFactory;
import org.apache.samza.metrics.MetricsRegistry;
import org.apache.samza.metrics.MetricsRegistryMap;
import org.apache.samza.zk.ZkCoordinationUtilsFactory;
import org.apache.samza.zk.ZkJobCoordinator;
import org.apache.samza.zk.ZkKeyBuilder;
import org.apache.samza.zk.ZkUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZkJobCoordinatorFactory
implements JobCoordinatorFactory {
    private static final Logger LOG = LoggerFactory.getLogger(ZkJobCoordinatorFactory.class);
    private static final String JOB_COORDINATOR_ZK_PATH_FORMAT = "%s/%s-%s-coordinationData";
    private static final String DEFAULT_JOB_NAME = "defaultJob";

    @Override
    public JobCoordinator getJobCoordinator(Config config) {
        MetricsRegistryMap metricsRegistry = new MetricsRegistryMap();
        String jobCoordinatorZkBasePath = ZkJobCoordinatorFactory.getJobCoordinationZkPath(config);
        ZkUtils zkUtils = this.getZkUtils(config, (MetricsRegistry)metricsRegistry, jobCoordinatorZkBasePath);
        LOG.debug("Creating ZkJobCoordinator with config: {}.", (Object)config);
        return new ZkJobCoordinator(config, (MetricsRegistry)metricsRegistry, zkUtils);
    }

    private ZkUtils getZkUtils(Config config, MetricsRegistry metricsRegistry, String coordinatorZkBasePath) {
        ZkConfig zkConfig = new ZkConfig(config);
        ZkKeyBuilder keyBuilder = new ZkKeyBuilder(coordinatorZkBasePath);
        ZkClient zkClient = ZkCoordinationUtilsFactory.createZkClient(zkConfig.getZkConnect(), zkConfig.getZkSessionTimeoutMs(), zkConfig.getZkConnectionTimeoutMs());
        return new ZkUtils(keyBuilder, zkClient, zkConfig.getZkConnectionTimeoutMs(), zkConfig.getZkSessionTimeoutMs(), metricsRegistry);
    }

    public static String getJobCoordinationZkPath(Config config) {
        JobConfig jobConfig = new JobConfig(config);
        String appId = new ApplicationConfig(config).getGlobalAppId();
        String jobName = jobConfig.getName().isDefined() ? (String)jobConfig.getName().get() : DEFAULT_JOB_NAME;
        String jobId = jobConfig.getJobId();
        return String.format(JOB_COORDINATOR_ZK_PATH_FORMAT, appId, jobName, jobId);
    }
}

