/*
 * Decompiled with CFR 0.152.
 */
package org.apache.samza.zk;

import java.util.List;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.samza.SamzaException;
import org.apache.samza.coordinator.DistributedLockWithState;
import org.apache.samza.zk.ZkKeyBuilder;
import org.apache.samza.zk.ZkUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZkDistributedLock
implements DistributedLockWithState {
    public static final Logger LOG = LoggerFactory.getLogger(ZkDistributedLock.class);
    private static final String STATE_INITED = "sate_initialized";
    private final ZkUtils zkUtils;
    private final String lockPath;
    private final String participantId;
    private final ZkKeyBuilder keyBuilder;
    private final Random random = new Random();
    private String nodePath = null;
    private final String statePath;

    public ZkDistributedLock(String participantId, ZkUtils zkUtils, String lockId) {
        this.zkUtils = zkUtils;
        this.participantId = participantId;
        this.keyBuilder = zkUtils.getKeyBuilder();
        this.lockPath = String.format("%s/stateLock_%s", this.keyBuilder.getRootPath(), lockId);
        this.statePath = String.format("%s/%s_%s", this.lockPath, STATE_INITED, lockId);
        zkUtils.validatePaths(new String[]{this.lockPath});
    }

    @Override
    public boolean lockIfNotSet(long timeout, TimeUnit unit) throws TimeoutException {
        this.nodePath = this.zkUtils.getZkClient().createEphemeralSequential(this.lockPath + "/", (Object)this.participantId);
        long startTime = System.currentTimeMillis();
        long lockTimeout = TimeUnit.MILLISECONDS.convert(timeout, unit);
        while (System.currentTimeMillis() - startTime < lockTimeout) {
            if (this.zkUtils.getZkClient().exists(this.statePath)) {
                return false;
            }
            List children = this.zkUtils.getZkClient().getChildren(this.lockPath);
            int index = children.indexOf(ZkKeyBuilder.parseIdFromPath(this.nodePath));
            if (children.size() == 0 || index == -1) {
                throw new SamzaException("Looks like we are no longer connected to Zk. Need to reconnect!");
            }
            if (index == 0) {
                LOG.info("Acquired lock for participant id: {}", (Object)this.participantId);
                return true;
            }
            try {
                Thread.sleep(this.random.nextInt(1000));
            }
            catch (InterruptedException e) {
                Thread.interrupted();
            }
            LOG.info("Trying to acquire lock again...");
        }
        throw new TimeoutException("could not acquire lock for " + timeout + " " + unit.toString());
    }

    @Override
    public void unlockAndSet() {
        this.zkUtils.getZkClient().createPersistent(this.statePath, true);
        if (this.nodePath != null) {
            this.zkUtils.getZkClient().delete(this.nodePath);
            this.nodePath = null;
            LOG.info("Ephemeral lock node deleted. Unlocked!");
        } else {
            LOG.warn("Ephemeral lock node you want to delete doesn't exist");
        }
    }
}

