/*
 * Decompiled with CFR 0.152.
 */
package org.apache.samza.zk;

import com.google.common.base.Strings;
import org.I0Itec.zkclient.ZkClient;
import org.I0Itec.zkclient.serialize.SerializableSerializer;
import org.I0Itec.zkclient.serialize.ZkSerializer;
import org.apache.samza.SamzaException;
import org.apache.samza.config.Config;
import org.apache.samza.config.ZkConfig;
import org.apache.samza.coordinator.CoordinationUtils;
import org.apache.samza.coordinator.CoordinationUtilsFactory;
import org.apache.samza.metrics.MetricsRegistry;
import org.apache.samza.util.NoOpMetricsRegistry;
import org.apache.samza.zk.ZkCoordinationUtils;
import org.apache.samza.zk.ZkKeyBuilder;
import org.apache.samza.zk.ZkUtils;
import org.apache.zookeeper.client.ConnectStringParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZkCoordinationUtilsFactory
implements CoordinationUtilsFactory {
    private static final Logger LOG = LoggerFactory.getLogger(ZkCoordinationUtilsFactory.class);

    @Override
    public CoordinationUtils getCoordinationUtils(String groupId, String participantId, Config config) {
        ZkConfig zkConfig = new ZkConfig(config);
        ZkClient zkClient = ZkCoordinationUtilsFactory.createZkClient(zkConfig.getZkConnect(), zkConfig.getZkSessionTimeoutMs(), zkConfig.getZkConnectionTimeoutMs());
        ZkUtils zkUtils = new ZkUtils(new ZkKeyBuilder(groupId), zkClient, zkConfig.getZkConnectionTimeoutMs(), zkConfig.getZkSessionTimeoutMs(), (MetricsRegistry)new NoOpMetricsRegistry());
        return new ZkCoordinationUtils(participantId, zkConfig, zkUtils);
    }

    public static ZkClient createZkClient(String connectString, int sessionTimeoutMS, int connectionTimeoutMs) {
        ZkClient zkClient;
        try {
            zkClient = new ZkClient(connectString, sessionTimeoutMS, connectionTimeoutMs, (ZkSerializer)new SerializableSerializer(), (long)connectionTimeoutMs);
        }
        catch (Exception e) {
            throw new SamzaException("zkClient failed to connect to ZK at :" + connectString, (Throwable)e);
        }
        ZkCoordinationUtilsFactory.validateZkNameSpace(connectString, zkClient);
        return zkClient;
    }

    public static void validateZkNameSpace(String zkConnect, ZkClient zkClient) {
        ConnectStringParser parser = new ConnectStringParser(zkConnect);
        String path = parser.getChrootPath();
        if (Strings.isNullOrEmpty((String)path)) {
            return;
        }
        LOG.info("connectString = " + zkConnect + "; path =" + path);
        if (!zkClient.exists("/")) {
            throw new SamzaException("Zookeeper namespace: " + path + " does not exist for zk at " + zkConnect);
        }
    }
}

