/*
 * Decompiled with CFR 0.152.
 */
package org.apache.samza.zk;

import org.I0Itec.zkclient.exception.ZkInterruptedException;
import org.apache.samza.config.ZkConfig;
import org.apache.samza.coordinator.CoordinationUtils;
import org.apache.samza.coordinator.DistributedLockWithState;
import org.apache.samza.coordinator.Latch;
import org.apache.samza.coordinator.LeaderElector;
import org.apache.samza.zk.ZkDistributedLock;
import org.apache.samza.zk.ZkLeaderElector;
import org.apache.samza.zk.ZkProcessorLatch;
import org.apache.samza.zk.ZkUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZkCoordinationUtils
implements CoordinationUtils {
    private static final Logger LOG = LoggerFactory.getLogger(ZkCoordinationUtils.class);
    public final ZkConfig zkConfig;
    public final ZkUtils zkUtils;
    public final String processorIdStr;

    public ZkCoordinationUtils(String processorId, ZkConfig zkConfig, ZkUtils zkUtils) {
        this.zkConfig = zkConfig;
        this.zkUtils = zkUtils;
        this.processorIdStr = processorId;
    }

    @Override
    public LeaderElector getLeaderElector() {
        return new ZkLeaderElector(this.processorIdStr, this.zkUtils);
    }

    @Override
    public Latch getLatch(int size, String latchId) {
        return new ZkProcessorLatch(size, latchId, this.processorIdStr, this.zkUtils);
    }

    @Override
    public DistributedLockWithState getLockWithState(String lockId) {
        return new ZkDistributedLock(this.processorIdStr, this.zkUtils, lockId);
    }

    @Override
    public void close() {
        try {
            if (this.zkUtils != null) {
                this.zkUtils.close();
            }
        }
        catch (ZkInterruptedException ex) {
            LOG.error("Exception in close(): ", (Throwable)ex);
        }
    }

    public ZkUtils getZkUtils() {
        return this.zkUtils;
    }
}

