/*
 * Decompiled with CFR 0.152.
 */
package org.apache.samza.zk;

import java.util.Objects;
import org.apache.samza.SamzaException;
import org.apache.samza.runtime.LocationId;

public class ProcessorData {
    private final String processorId;
    private final String locationId;

    public ProcessorData(String locationId, String processorId) {
        this.processorId = processorId;
        this.locationId = locationId;
    }

    public ProcessorData(String data) {
        String[] splt = data.split(" ");
        if (splt.length != 2) {
            throw new SamzaException("incorrect processor data format = " + data);
        }
        this.locationId = splt[0];
        this.processorId = splt[1];
    }

    public String toString() {
        return this.locationId + " " + this.processorId;
    }

    public LocationId getLocationId() {
        return new LocationId(this.locationId);
    }

    public String getProcessorId() {
        return this.processorId;
    }

    public int hashCode() {
        return Objects.hash(this.processorId, this.locationId);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ProcessorData other = (ProcessorData)obj;
        return Objects.equals(this.processorId, other.processorId) && Objects.equals(this.locationId, other.locationId);
    }
}

