/*
 * Decompiled with CFR 0.152.
 */
package org.apache.samza.util;

import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.Random;
import org.apache.samza.SamzaException;
import org.apache.samza.config.Config;
import org.apache.samza.config.ConfigRewriter;
import org.apache.samza.config.JobConfig$;
import org.apache.samza.util.Logging;
import org.apache.samza.util.Logging$class;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.Nothing$;

public final class Util$
implements Logging {
    public static final Util$ MODULE$;
    private final Random Random;
    private final ThreadMXBean ThreadMxBean;
    private final String loggerName;
    private final Logger logger;
    private final String startupLoggerName;
    private final Logger startupLogger;
    private volatile byte bitmap$0;

    static {
        new Util$();
    }

    @Override
    public String loggerName() {
        return this.loggerName;
    }

    private Logger logger$lzycompute() {
        Util$ util$ = this;
        synchronized (util$) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
            return this.logger;
        }
    }

    @Override
    public Logger logger() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.logger$lzycompute() : this.logger;
    }

    @Override
    public String startupLoggerName() {
        return this.startupLoggerName;
    }

    private Logger startupLogger$lzycompute() {
        Util$ util$ = this;
        synchronized (util$) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.startupLogger = Logging$class.startupLogger(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
            return this.startupLogger;
        }
    }

    @Override
    public Logger startupLogger() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.startupLogger$lzycompute() : this.startupLogger;
    }

    @Override
    public void org$apache$samza$util$Logging$_setter_$loggerName_$eq(String x$1) {
        this.loggerName = x$1;
    }

    @Override
    public void org$apache$samza$util$Logging$_setter_$startupLoggerName_$eq(String x$1) {
        this.startupLoggerName = x$1;
    }

    @Override
    public void startupLog(Function0<Object> message) {
        Logging$class.startupLog(this, message);
    }

    @Override
    public void trace(Function0<Object> message) {
        Logging$class.trace(this, message);
    }

    @Override
    public void trace(Function0<Object> message, Function0<Throwable> e) {
        Logging$class.trace(this, message, e);
    }

    @Override
    public void debug(Function0<Object> message) {
        Logging$class.debug(this, message);
    }

    @Override
    public void debug(Function0<Object> message, Function0<Throwable> e) {
        Logging$class.debug(this, message, e);
    }

    @Override
    public void info(Function0<Object> message) {
        Logging$class.info(this, message);
    }

    @Override
    public void info(Function0<Object> message, Function0<Throwable> e) {
        Logging$class.info(this, message, e);
    }

    @Override
    public void warn(Function0<Object> message) {
        Logging$class.warn(this, message);
    }

    @Override
    public void warn(Function0<Object> message, Function0<Throwable> e) {
        Logging$class.warn(this, message, e);
    }

    @Override
    public void error(Function0<Object> message) {
        Logging$class.error(this, message);
    }

    @Override
    public void error(Function0<Object> message, Function0<Throwable> e) {
        Logging$class.error(this, message, e);
    }

    @Override
    public void putMDC(Function0<String> key, Function0<String> value) {
        Logging$class.putMDC(this, key, value);
    }

    @Override
    public String getMDC(Function0<String> key) {
        return Logging$class.getMDC(this, key);
    }

    @Override
    public void removeMDC(Function0<String> key) {
        Logging$class.removeMDC(this, key);
    }

    @Override
    public void clearMDC() {
        Logging$class.clearMDC(this);
    }

    public Random Random() {
        return this.Random;
    }

    public ThreadMXBean ThreadMxBean() {
        return this.ThreadMxBean;
    }

    public String envVarEscape(String str) {
        return str.replace("\"", "\\\"").replace("'", "\\'");
    }

    public int randomBetween(int startInclusive, int endExclusive) {
        return startInclusive + this.Random().nextInt(endExclusive - startInclusive);
    }

    public <T> T getObj(String className, Class<T> clazz) {
        try {
            return (T)Class.forName(className).newInstance();
        }
        catch (Throwable throwable) {
            this.error((Function0<Object>)new Serializable(className){
                public static final long serialVersionUID = 0L;
                private final String className$1;

                public final String apply() {
                    return new StringOps(Predef$.MODULE$.augmentString("Unable to create an instance for class %s.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.className$1}));
                }
                {
                    this.className$1 = className$1;
                }
            }, (Function0<Throwable>)new Serializable(throwable){
                public static final long serialVersionUID = 0L;
                private final Throwable e$1;

                public final Throwable apply() {
                    return this.e$1;
                }
                {
                    this.e$1 = e$1;
                }
            });
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public InetAddress getLocalHost() {
        NonLocalReturnControl nonLocalReturnControl2;
        block3: {
            InetAddress inetAddress;
            Object object = new Object();
            try {
                void var3_2;
                InetAddress localHost = InetAddress.getLocalHost();
                if (localHost.isLoopbackAddress()) {
                    this.debug((Function0<Object>)new Serializable(localHost){
                        public static final long serialVersionUID = 0L;
                        private final InetAddress localHost$1;

                        public final String apply() {
                            return new StringOps(Predef$.MODULE$.augmentString("Hostname %s resolves to a loopback address, trying to resolve an external IP address.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.localHost$1.getHostName()}));
                        }
                        {
                            this.localHost$1 = localHost$1;
                        }
                    });
                    List networkInterfaces = System.getProperty("os.name").startsWith("Windows") ? ((TraversableOnce)JavaConverters$.MODULE$.enumerationAsScalaIteratorConverter(NetworkInterface.getNetworkInterfaces()).asScala()).toList() : ((TraversableOnce)JavaConverters$.MODULE$.enumerationAsScalaIteratorConverter(NetworkInterface.getNetworkInterfaces()).asScala()).toList().reverse();
                    networkInterfaces.foreach((Function1)new Serializable(object){
                        public static final long serialVersionUID = 0L;
                        private final Object nonLocalReturnKey1$1;

                        public final void apply(NetworkInterface networkInterface) {
                            List addresses = (List)((TraversableOnce)JavaConverters$.MODULE$.enumerationAsScalaIteratorConverter(networkInterface.getInetAddresses()).asScala()).toList().filterNot((Function1)new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final boolean apply(InetAddress address) {
                                    return address.isLinkLocalAddress() || address.isLoopbackAddress();
                                }
                            });
                            if (addresses.nonEmpty()) {
                                InetAddress address = (InetAddress)addresses.find((Function1)new Serializable(this){
                                    public static final long serialVersionUID = 0L;

                                    public final boolean apply(InetAddress x$1) {
                                        return x$1 instanceof Inet4Address;
                                    }
                                }).getOrElse((Function0)new Serializable(this, addresses){
                                    public static final long serialVersionUID = 0L;
                                    private final List addresses$1;

                                    public final InetAddress apply() {
                                        return (InetAddress)this.addresses$1.head();
                                    }
                                    {
                                        this.addresses$1 = addresses$1;
                                    }
                                });
                                Util$.MODULE$.debug((Function0<Object>)new Serializable(this, address){
                                    public static final long serialVersionUID = 0L;
                                    private final InetAddress address$1;

                                    public final String apply() {
                                        return new StringOps(Predef$.MODULE$.augmentString("Found an external IP address %s which represents the localhost.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.address$1.getHostAddress()}));
                                    }
                                    {
                                        this.address$1 = address$1;
                                    }
                                });
                                throw new NonLocalReturnControl(this.nonLocalReturnKey1$1, (Object)InetAddress.getByAddress(address.getAddress()));
                            }
                        }
                        {
                            this.nonLocalReturnKey1$1 = nonLocalReturnKey1$1;
                        }
                    });
                }
                inetAddress = var3_2;
            }
            catch (NonLocalReturnControl nonLocalReturnControl2) {
                if (nonLocalReturnControl2.key() != object) break block3;
                inetAddress = (InetAddress)nonLocalReturnControl2.value();
            }
            return inetAddress;
        }
        throw nonLocalReturnControl2;
    }

    public Config rewriteConfig(Config config) {
        Config config2;
        Option<String> option = JobConfig$.MODULE$.Config2Job(config).getConfigRewriters();
        if (option instanceof Some) {
            Some some = (Some)option;
            String rewriters = (String)some.x();
            config2 = (Config)Predef$.MODULE$.refArrayOps((Object[])rewriters.split(",")).foldLeft((Object)config, (Function2)new Serializable(config){
                public static final long serialVersionUID = 0L;
                private final Config config$1;

                public final Config apply(Config x$2, String x$3) {
                    return Util$.MODULE$.org$apache$samza$util$Util$$rewrite$1(x$2, x$3, this.config$1);
                }
                {
                    this.config$1 = config$1;
                }
            });
        } else {
            config2 = config;
        }
        return config2;
    }

    public void logThreadDump(String message) {
        try {
            ThreadInfo[] threadInfo = this.ThreadMxBean().dumpAllThreads(true, true);
            StringBuilder sb = new StringBuilder();
            sb.append(message).append("\n");
            Predef$.MODULE$.refArrayOps((Object[])threadInfo).foreach((Function1)new Serializable(sb){
                public static final long serialVersionUID = 0L;
                private final StringBuilder sb$1;

                public final StringBuilder apply(ThreadInfo ti) {
                    return this.sb$1.append(ti.toString()).append("\n");
                }
                {
                    this.sb$1 = sb$1;
                }
            });
            this.info((Function0<Object>)new Serializable(sb){
                public static final long serialVersionUID = 0L;
                private final StringBuilder sb$1;

                public final StringBuilder apply() {
                    return this.sb$1;
                }
                {
                    this.sb$1 = sb$1;
                }
            });
        }
        catch (Exception exception) {
            this.info((Function0<Object>)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Could not get and log a thread dump";
                }
            }, (Function0<Throwable>)new Serializable(exception){
                public static final long serialVersionUID = 0L;
                private final Exception e$2;

                public final Exception apply() {
                    return this.e$2;
                }
                {
                    this.e$2 = e$2;
                }
            });
        }
    }

    public final Config org$apache$samza$util$Util$$rewrite$1(Config c, String rewriterName, Config config$1) {
        String rewriterClassName = (String)JobConfig$.MODULE$.Config2Job(config$1).getConfigRewriterClass(rewriterName).getOrElse((Function0)new Serializable(rewriterName){
            public static final long serialVersionUID = 0L;
            private final String rewriterName$1;

            public final Nothing$ apply() {
                throw new SamzaException(new StringOps(Predef$.MODULE$.augmentString("Unable to find class config for config rewriter %s.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.rewriterName$1})));
            }
            {
                this.rewriterName$1 = rewriterName$1;
            }
        });
        ConfigRewriter rewriter = this.getObj(rewriterClassName, ConfigRewriter.class);
        this.info((Function0<Object>)new Serializable(rewriter){
            public static final long serialVersionUID = 0L;
            private final ConfigRewriter rewriter$1;

            public final String apply() {
                return new StringBuilder().append((Object)"Re-writing config with ").append((Object)this.rewriter$1).toString();
            }
            {
                this.rewriter$1 = rewriter$1;
            }
        });
        return rewriter.rewrite(rewriterName, c);
    }

    private Util$() {
        MODULE$ = this;
        Logging$class.$init$(this);
        this.Random = new Random();
        this.ThreadMxBean = ManagementFactory.getThreadMXBean();
    }
}

