/*
 * Decompiled with CFR 0.152.
 */
package org.apache.samza.util;

import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.samza.util.HighResolutionClock;
import org.apache.samza.util.MathUtil;
import org.apache.samza.util.SystemHighResolutionClock;
import org.apache.samza.util.Throttleable;

public class ThrottlingScheduler
implements Throttleable {
    private final long maxDelayNanos;
    private final ScheduledExecutorService scheduledExecutorService;
    private final HighResolutionClock clock;
    private final AtomicLong pendingNanos = new AtomicLong();
    private volatile double workToIdleFactor;

    public ThrottlingScheduler(long maxDelayMillis) {
        this.maxDelayNanos = TimeUnit.MILLISECONDS.toNanos(maxDelayMillis);
        this.scheduledExecutorService = Executors.newSingleThreadScheduledExecutor();
        this.clock = new SystemHighResolutionClock();
    }

    ThrottlingScheduler(long maxDelayMillis, ScheduledExecutorService scheduledExecutorService, HighResolutionClock clock) {
        this.maxDelayNanos = TimeUnit.MILLISECONDS.toNanos(maxDelayMillis);
        this.scheduledExecutorService = scheduledExecutorService;
        this.clock = clock;
    }

    public void schedule(final Runnable callback, long workDurationNs) {
        double currentWorkToIdleFactor = this.workToIdleFactor;
        if (currentWorkToIdleFactor == 0.0) {
            callback.run();
        } else {
            long delay = Math.min(this.maxDelayNanos, (long)((double)workDurationNs * currentWorkToIdleFactor));
            this.addToPendingNanos(delay);
            if (this.pendingNanos.get() < 0L) {
                callback.run();
            } else {
                final long startTimeNs = this.clock.nanoTime();
                this.scheduledExecutorService.schedule(new Runnable(){

                    @Override
                    public void run() {
                        long actualDelay = ThrottlingScheduler.this.clock.nanoTime() - startTimeNs;
                        ThrottlingScheduler.this.addToPendingNanos(-actualDelay);
                        callback.run();
                    }
                }, delay, TimeUnit.NANOSECONDS);
            }
        }
    }

    private void addToPendingNanos(long amount) {
        long newValue;
        long currentValue;
        while (!this.pendingNanos.compareAndSet(currentValue = this.pendingNanos.get(), newValue = MathUtil.clampAdd(currentValue, amount))) {
        }
    }

    @Override
    public void setWorkFactor(double workFactor) {
        if (workFactor < 0.001) {
            throw new IllegalArgumentException("Work factor must be >= 0.001");
        }
        if (workFactor > 1.0) {
            throw new IllegalArgumentException("Work factor must be <= 1.0");
        }
        this.workToIdleFactor = (1.0 - workFactor) / workFactor;
    }

    @Override
    public double getWorkFactor() {
        return 1.0 / (this.workToIdleFactor + 1.0);
    }

    public void shutdown() {
        this.scheduledExecutorService.shutdown();
    }

    long getPendingNanos() {
        return this.pendingNanos.get();
    }

    void setPendingNanos(long pendingNanos) {
        this.pendingNanos.set(pendingNanos);
    }
}

