/*
 * Decompiled with CFR 0.152.
 */
package org.apache.samza.util;

import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import org.apache.samza.util.HighResolutionClock;
import org.apache.samza.util.MathUtil;
import org.apache.samza.util.SystemHighResolutionClock;
import org.apache.samza.util.Throttleable;

public class ThrottlingExecutor
implements Throttleable,
Executor {
    private final long maxDelayNanos;
    private final HighResolutionClock clock;
    private volatile double workToIdleFactor;
    private long pendingNanos;

    public ThrottlingExecutor(long maxDelayMillis) {
        this(maxDelayMillis, new SystemHighResolutionClock());
    }

    ThrottlingExecutor(long maxDelayMillis, HighResolutionClock clock) {
        this.maxDelayNanos = TimeUnit.MILLISECONDS.toNanos(maxDelayMillis);
        this.clock = clock;
    }

    @Override
    public void execute(Runnable command) {
        double currentWorkToIdleFactor = this.workToIdleFactor;
        if (currentWorkToIdleFactor == 0.0) {
            command.run();
        } else {
            long startWorkNanos = this.clock.nanoTime();
            command.run();
            long workNanos = this.clock.nanoTime() - startWorkNanos;
            this.pendingNanos = Math.min(this.maxDelayNanos, MathUtil.clampAdd(this.pendingNanos, (long)((double)workNanos * currentWorkToIdleFactor)));
            if (this.pendingNanos > 0L) {
                try {
                    this.pendingNanos = this.sleep(this.pendingNanos);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
        }
    }

    @Override
    public void setWorkFactor(double workFactor) {
        if (workFactor < 0.001) {
            throw new IllegalArgumentException("Work factor must be >= 0.001");
        }
        if (workFactor > 1.0) {
            throw new IllegalArgumentException("Work factor must be <= 1.0");
        }
        this.workToIdleFactor = (1.0 - workFactor) / workFactor;
    }

    @Override
    public double getWorkFactor() {
        return 1.0 / (this.workToIdleFactor + 1.0);
    }

    long getPendingNanos() {
        return this.pendingNanos;
    }

    void setPendingNanos(long pendingNanos) {
        this.pendingNanos = pendingNanos;
    }

    long sleep(long nanos) throws InterruptedException {
        if (nanos <= 0L) {
            return nanos;
        }
        long start2 = System.nanoTime();
        TimeUnit.NANOSECONDS.sleep(nanos);
        return MathUtil.clampAdd(nanos, -(System.nanoTime() - start2));
    }
}

