/*
 * Decompiled with CFR 0.152.
 */
package org.apache.samza.util;

import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.samza.SamzaException;
import org.apache.samza.config.Config;
import org.apache.samza.config.MapConfig;
import org.apache.samza.config.StreamConfig;
import org.apache.samza.system.StreamSpec;
import org.apache.samza.system.SystemStream;

public class StreamUtil {
    public static SystemStream getSystemStreamFromNameOrId(Config config, String stream) {
        String[] parts = stream.split("\\.");
        if (parts.length == 0 || parts.length > 2) {
            throw new SamzaException(String.format("Invalid stream %s. Expected to be of the format streamId or systemName.streamName", stream));
        }
        if (parts.length == 1) {
            return new StreamConfig(config).streamIdToSystemStream(stream);
        }
        return new SystemStream(parts[0], parts[1]);
    }

    public static SystemStream getSystemStreamFromNames(String systemStreamName) {
        int idx = systemStreamName.indexOf(46);
        if (idx < 0) {
            throw new IllegalArgumentException("No '.' in stream name '" + systemStreamName + "'. Stream names should be in the form 'system.stream'");
        }
        return new SystemStream(systemStreamName.substring(0, idx), systemStreamName.substring(idx + 1, systemStreamName.length()));
    }

    public static String getNameFromSystemStream(SystemStream systemStream) {
        return systemStream.getSystem() + "." + systemStream.getStream();
    }

    public static Set<StreamSpec> getStreamSpecs(Set<String> streamIds, StreamConfig streamConfig) {
        return streamIds.stream().map(streamId -> StreamUtil.getStreamSpec(streamId, streamConfig)).collect(Collectors.toSet());
    }

    public static StreamSpec getStreamSpec(String streamId, StreamConfig streamConfig) {
        String physicalName = streamConfig.getPhysicalName(streamId);
        String system = streamConfig.getSystem(streamId);
        MapConfig streamProperties = streamConfig.getStreamProperties(streamId);
        return new StreamSpec(streamId, physicalName, system, (Map)streamProperties);
    }
}

