/*
 * Decompiled with CFR 0.152.
 */
package org.apache.samza.util;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.apache.samza.util.Util;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShutdownUtil {
    private static final Logger LOG = LoggerFactory.getLogger(ShutdownUtil.class);

    public static boolean boundedShutdown(List<Runnable> shutdownTasks, String message, long timeoutMs) {
        ExecutorService shutdownExecutorService = Executors.newCachedThreadPool(new ThreadFactoryBuilder().setNameFormat(message + "-%d").setDaemon(true).build());
        shutdownTasks.forEach(shutdownExecutorService::submit);
        shutdownExecutorService.shutdown();
        try {
            shutdownExecutorService.awaitTermination(timeoutMs, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            LOG.error("Shutdown was interrupted for " + message, (Throwable)e);
        }
        if (shutdownExecutorService.isTerminated()) {
            LOG.info("Shutdown complete for {}", (Object)message);
            return true;
        }
        LOG.error("Shutdown function for {} remains unfinished after timeout({}ms) or interruption", (Object)message, (Object)timeoutMs);
        Util.logThreadDump(message);
        shutdownExecutorService.shutdownNow();
        return false;
    }
}

