/*
 * Decompiled with CFR 0.152.
 */
package org.apache.samza.util;

import org.apache.samza.util.Util;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SamzaUncaughtExceptionHandler
implements Thread.UncaughtExceptionHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(SamzaUncaughtExceptionHandler.class);
    private final Runnable runnable;

    public SamzaUncaughtExceptionHandler(Runnable runnable) {
        this.runnable = runnable;
    }

    @Override
    public void uncaughtException(Thread t, Throwable e) {
        String msg = String.format("Uncaught exception in thread %s.", t.getName());
        LOGGER.error(msg, e);
        System.err.println(msg);
        e.printStackTrace(System.err);
        try {
            Util.logThreadDump("Thread dump from uncaught exception handler.");
            this.runnable.run();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

