/*
 * Decompiled with CFR 0.152.
 */
package org.apache.samza.util;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.samza.SamzaException;
import org.apache.samza.config.Config;
import org.apache.samza.config.MetricsConfig;
import org.apache.samza.metrics.MetricsReporter;
import org.apache.samza.metrics.MetricsReporterFactory;
import org.apache.samza.util.Util;
import scala.collection.JavaConverters;

public class MetricsReporterLoader {
    private MetricsReporterLoader() {
    }

    public static Map<String, MetricsReporter> getMetricsReporters(MetricsConfig config, String containerName) {
        HashMap<String, MetricsReporter> metricsReporters = new HashMap<String, MetricsReporter>();
        for (String metricsReporterName : (List)JavaConverters.seqAsJavaListConverter(config.getMetricReporterNames()).asJava()) {
            String metricsFactoryClassName = (String)config.getMetricsFactoryClass(metricsReporterName).get();
            if (metricsFactoryClassName == null) {
                throw new SamzaException(String.format("Metrics reporter %s missing .class config", metricsReporterName));
            }
            MetricsReporterFactory metricsReporterFactory = Util.getObj(metricsFactoryClassName, MetricsReporterFactory.class);
            metricsReporters.put(metricsReporterName, metricsReporterFactory.getMetricsReporter(metricsReporterName, containerName, (Config)config));
        }
        return metricsReporters;
    }
}

