/*
 * Decompiled with CFR 0.152.
 */
package org.apache.samza.util;

import java.util.List;

public class MathUtil {
    public static long gcd(long a, long b) {
        while (b > 0L) {
            long temp = b;
            b = a % b;
            a = temp;
        }
        return a;
    }

    public static long gcd(List<Long> numbers) {
        if (numbers == null) {
            throw new IllegalArgumentException("Null list provided");
        }
        if (numbers.size() == 0) {
            throw new IllegalArgumentException("List of size 0 provided");
        }
        long result = numbers.get(0);
        for (int i = 1; i < numbers.size(); ++i) {
            result = MathUtil.gcd(result, numbers.get(i));
        }
        return result;
    }

    public static long clampAdd(long lhs, long rhs) {
        long sum = lhs + rhs;
        if (((lhs ^ rhs ^ 0xFFFFFFFFFFFFFFFFL) & (lhs ^ sum)) < 0L) {
            if (lhs >= 0L) {
                return Long.MAX_VALUE;
            }
            return Long.MIN_VALUE;
        }
        return sum;
    }
}

