/*
 * Decompiled with CFR 0.152.
 */
package org.apache.samza.util;

import com.google.common.base.Preconditions;
import com.google.common.base.Stopwatch;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.samza.container.TaskName;
import org.apache.samza.context.Context;
import org.apache.samza.context.TaskContextImpl;
import org.apache.samza.job.model.JobModel;
import org.apache.samza.util.RateLimiter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EmbeddedTaggedRateLimiter
implements RateLimiter {
    private static final Logger LOGGER = LoggerFactory.getLogger(EmbeddedTaggedRateLimiter.class);
    private static final String DEFAULT_TAG = "default-tag";
    private static final Map<String, Integer> DEFAULT_TAG_MAP = Collections.singletonMap("default-tag", 0);
    private final Map<String, Integer> tagToTargetRateMap;
    private Map<String, com.google.common.util.concurrent.RateLimiter> tagToRateLimiterMap;
    private boolean initialized;

    public EmbeddedTaggedRateLimiter(int creditsPerSecond) {
        this(Collections.singletonMap(DEFAULT_TAG, creditsPerSecond));
    }

    public EmbeddedTaggedRateLimiter(Map<String, Integer> tagToCreditsPerSecondMap) {
        Preconditions.checkArgument((tagToCreditsPerSecondMap.size() > 0 ? 1 : 0) != 0, (Object)"Map of tags can't be empty");
        tagToCreditsPerSecondMap.values().forEach(c -> Preconditions.checkArgument((c >= 0 ? 1 : 0) != 0, (Object)"Credits must be non-negative"));
        this.tagToTargetRateMap = tagToCreditsPerSecondMap;
    }

    public void acquire(Map<String, Integer> tagToCreditsMap) {
        this.ensureTagsAreValid(tagToCreditsMap);
        tagToCreditsMap.forEach((tag, numberOfCredits) -> this.tagToRateLimiterMap.get(tag).acquire(numberOfCredits.intValue()));
    }

    public Map<String, Integer> acquire(Map<String, Integer> tagToCreditsMap, long timeout, TimeUnit unit) {
        this.ensureTagsAreValid(tagToCreditsMap);
        long timeoutInNanos = TimeUnit.NANOSECONDS.convert(timeout, unit);
        Stopwatch stopwatch = Stopwatch.createStarted();
        return tagToCreditsMap.entrySet().stream().map(e -> {
            String tag = (String)e.getKey();
            int requiredCredits = (Integer)e.getValue();
            long remainingTimeoutInNanos = Math.max(0L, timeoutInNanos - stopwatch.elapsed(TimeUnit.NANOSECONDS));
            com.google.common.util.concurrent.RateLimiter rateLimiter = this.tagToRateLimiterMap.get(tag);
            int availableCredits = rateLimiter.tryAcquire(requiredCredits, remainingTimeoutInNanos, TimeUnit.NANOSECONDS) ? requiredCredits : 0;
            return new ImmutablePair((Object)tag, (Object)availableCredits);
        }).collect(Collectors.toMap(Pair::getKey, Pair::getValue));
    }

    public Set<String> getSupportedTags() {
        return Collections.unmodifiableSet(this.tagToRateLimiterMap.keySet());
    }

    public void acquire(int numberOfCredits) {
        this.ensureTagsAreValid(DEFAULT_TAG_MAP);
        this.tagToRateLimiterMap.get(DEFAULT_TAG).acquire(numberOfCredits);
    }

    public int acquire(int numberOfCredit, long timeout, TimeUnit unit) {
        this.ensureTagsAreValid(DEFAULT_TAG_MAP);
        return this.tagToRateLimiterMap.get(DEFAULT_TAG).tryAcquire(numberOfCredit, timeout, unit) ? numberOfCredit : 0;
    }

    public void init(Context context) {
        this.tagToRateLimiterMap = Collections.unmodifiableMap(this.tagToTargetRateMap.entrySet().stream().map(e -> {
            String tag = (String)e.getKey();
            JobModel jobModel = ((TaskContextImpl)context.getTaskContext()).getJobModel();
            int numTasks = jobModel.getContainers().values().stream().mapToInt(cm -> cm.getTasks().size()).sum();
            int effectiveRate = (Integer)e.getValue() / numTasks;
            TaskName taskName = context.getTaskContext().getTaskModel().getTaskName();
            LOGGER.info(String.format("Effective rate limit for task %s and tag %s is %d", taskName, tag, effectiveRate));
            return new ImmutablePair((Object)tag, (Object)com.google.common.util.concurrent.RateLimiter.create((double)effectiveRate));
        }).collect(Collectors.toMap(Pair::getKey, Pair::getValue)));
        this.initialized = true;
    }

    private void ensureInitialized() {
        Preconditions.checkState((boolean)this.initialized, (Object)"Not initialized");
    }

    private void ensureTagsAreValid(Map<String, ?> tagMap) {
        this.ensureInitialized();
        tagMap.keySet().forEach(tag -> Preconditions.checkArgument((boolean)this.tagToRateLimiterMap.containsKey(tag), (Object)("Invalid tag: " + tag)));
    }
}

