/*
 * Decompiled with CFR 0.152.
 */
package org.apache.samza.util;

import org.apache.samza.SamzaException;
import org.apache.samza.config.Config;
import org.apache.samza.config.ConfigException;
import org.apache.samza.config.JobConfig$;
import org.apache.samza.config.MapConfig;
import org.apache.samza.config.SystemConfig$;
import org.apache.samza.system.SystemFactory;
import org.apache.samza.system.SystemStream;
import org.apache.samza.util.Util$;
import scala.Function0;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.immutable.Map$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Map;
import scala.collection.mutable.MapLike;
import scala.collection.mutable.StringBuilder;
import scala.runtime.Nothing$;

public final class CoordinatorStreamUtil$ {
    public static final CoordinatorStreamUtil$ MODULE$;

    static {
        new CoordinatorStreamUtil$();
    }

    public MapConfig buildCoordinatorStreamConfig(Config config) {
        Tuple2<String, String> tuple2 = this.getJobNameAndId(config);
        if (tuple2 != null) {
            Tuple2 tuple22;
            String jobName = (String)tuple2._1();
            String jobId = (String)tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)jobName, (Object)jobId);
            String jobName2 = (String)tuple23._1();
            String jobId2 = (String)tuple23._2();
            Map map = ((MapLike)JavaConverters$.MODULE$.mapAsScalaMapConverter((java.util.Map)config.subset(new StringOps(Predef$.MODULE$.augmentString(SystemConfig$.MODULE$.SYSTEM_PREFIX())).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{JobConfig$.MODULE$.Config2Job(config).getCoordinatorSystemName()})), false)).asScala()).$plus$plus((GenTraversableOnce)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)JobConfig$.MODULE$.JOB_NAME()), (Object)jobName2), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)JobConfig$.MODULE$.JOB_ID()), (Object)jobId2), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)JobConfig$.MODULE$.JOB_COORDINATOR_SYSTEM()), (Object)JobConfig$.MODULE$.Config2Job(config).getCoordinatorSystemName()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)JobConfig$.MODULE$.MONITOR_PARTITION_CHANGE_FREQUENCY_MS()), (Object)String.valueOf(JobConfig$.MODULE$.Config2Job(config).getMonitorPartitionChangeFrequency()))})));
            return new MapConfig((java.util.Map)JavaConverters$.MODULE$.mutableMapAsJavaMapConverter(map).asJava());
        }
        throw new MatchError(tuple2);
    }

    public SystemStream getCoordinatorSystemStream(Config config) {
        String systemName = JobConfig$.MODULE$.Config2Job(config).getCoordinatorSystemName();
        Tuple2<String, String> tuple2 = this.getJobNameAndId(config);
        if (tuple2 != null) {
            Tuple2 tuple22;
            String jobName = (String)tuple2._1();
            String jobId = (String)tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)jobName, (Object)jobId);
            String jobName2 = (String)tuple23._1();
            String jobId2 = (String)tuple23._2();
            String streamName = this.getCoordinatorStreamName(jobName2, jobId2);
            return new SystemStream(systemName, streamName);
        }
        throw new MatchError(tuple2);
    }

    public SystemFactory getCoordinatorSystemFactory(Config config) {
        String systemName = JobConfig$.MODULE$.Config2Job(config).getCoordinatorSystemName();
        String systemFactoryClassName = (String)SystemConfig$.MODULE$.Config2System(config).getSystemFactory(systemName).getOrElse((Function0)new Serializable(systemName){
            public static final long serialVersionUID = 0L;
            private final String systemName$1;

            public final Nothing$ apply() {
                throw new SamzaException(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder().append((Object)"Missing configuration: ").append((Object)SystemConfig$.MODULE$.SYSTEM_FACTORY()).toString())).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.systemName$1})));
            }
            {
                this.systemName$1 = systemName$1;
            }
        });
        return Util$.MODULE$.getObj(systemFactoryClassName, SystemFactory.class);
    }

    public String getCoordinatorStreamName(String jobName, String jobId) {
        return new StringOps(Predef$.MODULE$.augmentString("__samza_coordinator_%s_%s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{jobName.replaceAll("_", "-"), jobId.replaceAll("_", "-")}));
    }

    private Tuple2<String, String> getJobNameAndId(Config config) {
        return new Tuple2(JobConfig$.MODULE$.Config2Job(config).getName().getOrElse((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Nothing$ apply() {
                throw new ConfigException("Missing required config: job.name");
            }
        }), (Object)JobConfig$.MODULE$.Config2Job(config).getJobId());
    }

    private CoordinatorStreamUtil$() {
        MODULE$ = this;
    }
}

