/*
 * Decompiled with CFR 0.152.
 */
package org.apache.samza.task;

import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.util.concurrent.ExecutorService;
import org.apache.commons.lang3.StringUtils;
import org.apache.samza.SamzaException;
import org.apache.samza.application.descriptors.ApplicationDescriptor;
import org.apache.samza.application.descriptors.ApplicationDescriptorImpl;
import org.apache.samza.application.descriptors.StreamApplicationDescriptorImpl;
import org.apache.samza.application.descriptors.TaskApplicationDescriptorImpl;
import org.apache.samza.config.ConfigException;
import org.apache.samza.task.AsyncStreamTask;
import org.apache.samza.task.AsyncStreamTaskAdapter;
import org.apache.samza.task.AsyncStreamTaskFactory;
import org.apache.samza.task.StreamOperatorTask;
import org.apache.samza.task.StreamTask;
import org.apache.samza.task.StreamTaskFactory;
import org.apache.samza.task.TaskFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskFactoryUtil {
    private static final Logger log = LoggerFactory.getLogger(TaskFactoryUtil.class);

    public static TaskFactory getTaskFactory(ApplicationDescriptorImpl<? extends ApplicationDescriptor> appDesc) {
        if (appDesc instanceof TaskApplicationDescriptorImpl) {
            return ((TaskApplicationDescriptorImpl)appDesc).getTaskFactory();
        }
        if (appDesc instanceof StreamApplicationDescriptorImpl) {
            return (StreamTaskFactory & Serializable)() -> new StreamOperatorTask(((StreamApplicationDescriptorImpl)appDesc).getOperatorSpecGraph());
        }
        throw new IllegalArgumentException(String.format("ApplicationDescriptorImpl has to be either TaskApplicationDescriptorImpl or StreamApplicationDescriptorImpl. class %s is not supported", appDesc.getClass().getName()));
    }

    public static TaskFactory getTaskFactory(String taskClassName) {
        boolean isAsyncTaskClass;
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)taskClassName), (Object)"task.class cannot be empty");
        log.info("Got task class name: {}", (Object)taskClassName);
        try {
            isAsyncTaskClass = AsyncStreamTask.class.isAssignableFrom(Class.forName(taskClassName));
        }
        catch (Throwable t) {
            throw new ConfigException(String.format("Invalid configuration for AsyncStreamTask class: %s", taskClassName), t);
        }
        if (isAsyncTaskClass) {
            return (AsyncStreamTaskFactory & Serializable)() -> {
                try {
                    return (AsyncStreamTask)Class.forName(taskClassName).newInstance();
                }
                catch (Throwable t) {
                    log.error("Error loading AsyncStreamTask class: {}. error: {}", (Object)taskClassName, (Object)t);
                    throw new SamzaException(String.format("Error loading AsyncStreamTask class: %s", taskClassName), t);
                }
            };
        }
        return (StreamTaskFactory & Serializable)() -> {
            try {
                return (StreamTask)Class.forName(taskClassName).newInstance();
            }
            catch (Throwable t) {
                log.error("Error loading StreamTask class: {}. error: {}", (Object)taskClassName, (Object)t);
                throw new SamzaException(String.format("Error loading StreamTask class: %s", taskClassName), t);
            }
        };
    }

    public static TaskFactory finalizeTaskFactory(TaskFactory factory, boolean singleThreadMode, ExecutorService taskThreadPool) {
        TaskFactoryUtil.validateFactory(factory);
        boolean isAsyncTaskClass = factory instanceof AsyncStreamTaskFactory;
        if (isAsyncTaskClass) {
            log.info("Got an AsyncStreamTask implementation.");
        }
        if (singleThreadMode && isAsyncTaskClass) {
            throw new SamzaException("AsyncStreamTask cannot run on single thread mode.");
        }
        if (!singleThreadMode && !isAsyncTaskClass) {
            log.info("Converting StreamTask to AsyncStreamTaskAdapter when running StreamTask with multiple threads");
            return (AsyncStreamTaskFactory & Serializable)() -> new AsyncStreamTaskAdapter((StreamTask)((StreamTaskFactory)factory).createInstance(), taskThreadPool);
        }
        return factory;
    }

    private static void validateFactory(TaskFactory factory) {
        if (factory == null) {
            throw new SamzaException("Either the task class name or the task factory instance is required.");
        }
        if (!(factory instanceof StreamTaskFactory) && !(factory instanceof AsyncStreamTaskFactory)) {
            throw new SamzaException(String.format("TaskFactory must be either StreamTaskFactory or AsyncStreamTaskFactory. %s is not supported", factory.getClass()));
        }
    }
}

